/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.common.logging.impl;

import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.RollingFileAppender;
import org.apache.log4j.helpers.CountingQuietWriter;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;

public class ExtendedRollingFileAppender
extends RollingFileAppender {
    private static final String DATE_FORMAT_FOR_TRANSFER = "yyyy-MM-dd'_'HH-mm-ss";
    protected int currentLevel = 50000;
    private long nextRollover = 0L;
    private volatile boolean cleanupInProgress = false;

    private static void cleanLogs(String startName, String folderPath, int maxBackupIndex) {
        String fileStartName = startName.toLowerCase(Locale.US);
        File file = new File(folderPath);
        if (file.exists()) {
            File[] files = file.listFiles(f -> !f.isDirectory() && f.getName().toLowerCase(Locale.US).startsWith(fileStartName));
            if (null == files) {
                return;
            }
            int backupFiles = files.length - 1;
            if (backupFiles <= maxBackupIndex) {
                return;
            }
            TreeMap<String, File> sortedMap = new TreeMap<String, File>();
            for (File file1 : files) {
                sortedMap.put(file1.getName(), file1);
            }
            sortedMap.remove(sortedMap.firstKey());
            Iterator it = sortedMap.entrySet().iterator();
            while (it.hasNext() && backupFiles > maxBackupIndex) {
                Map.Entry temp = it.next();
                File deleteFile = (File)temp.getValue();
                if (deleteFile.delete()) {
                    --backupFiles;
                    continue;
                }
                LogLog.error((String)("Couldn't delete file :: " + deleteFile.getPath()));
            }
        }
    }

    public void rollOver() {
        File file = new File(this.fileName);
        String fileStartName = file.getName();
        int dotIndex = fileStartName.indexOf(46);
        if (dotIndex != -1) {
            fileStartName = fileStartName.substring(0, dotIndex);
        }
        String startName = fileStartName;
        String folderPath = file.getParent();
        if (this.qw != null) {
            long size = ((CountingQuietWriter)this.qw).getCount();
            LogLog.debug((String)("rolling over count=" + size));
            this.nextRollover = size + this.maxFileSize;
        }
        LogLog.debug((String)("maxBackupIndex=" + this.maxBackupIndex));
        boolean renameSucceeded = true;
        if (this.maxBackupIndex > 0) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT_FOR_TRANSFER);
            StringBuilder buffer = new StringBuilder();
            String extension = "";
            if (this.fileName.contains(".")) {
                extension = this.fileName.substring(this.fileName.lastIndexOf("."));
                buffer.append(this.fileName, 0, this.fileName.lastIndexOf("."));
            } else {
                buffer.append(this.fileName);
            }
            buffer.append("_").append(dateFormat.format(new Date())).append(extension);
            File target = new File(buffer.toString());
            this.closeFile();
            LogLog.debug((String)("Renaming file " + file + " to " + target));
            renameSucceeded = file.renameTo(target);
            if (!renameSucceeded) {
                try {
                    this.setFile(this.fileName, true, this.bufferedIO, this.bufferSize);
                }
                catch (InterruptedIOException e) {
                    Thread.currentThread().interrupt();
                }
                catch (IOException e) {
                    LogLog.error((String)("setFile(" + this.fileName + ", true) call failed."), (Throwable)e);
                }
            }
        }
        if (renameSucceeded) {
            try {
                this.setFile(this.fileName, false, this.bufferedIO, this.bufferSize);
                this.nextRollover = 0L;
            }
            catch (InterruptedIOException e) {
                Thread.currentThread().interrupt();
            }
            catch (IOException e) {
                LogLog.error((String)("setFile(" + this.fileName + ", false) call failed."), (Throwable)e);
            }
        }
        if (!this.cleanupInProgress) {
            this.cleanUpLogs(startName, folderPath);
        }
    }

    private void cleanUpLogs(final String startName, final String folderPath) {
        if (this.maxBackupIndex > 0) {
            Runnable r = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Class<ExtendedRollingFileAppender> clazz = ExtendedRollingFileAppender.class;
                    synchronized (ExtendedRollingFileAppender.class) {
                        ExtendedRollingFileAppender.this.cleanupInProgress = true;
                        try {
                            ExtendedRollingFileAppender.cleanLogs(startName, folderPath, ExtendedRollingFileAppender.this.maxBackupIndex);
                        }
                        catch (Throwable e) {
                            LogLog.error((String)"Cleaning logs failed", (Throwable)e);
                        }
                        finally {
                            ExtendedRollingFileAppender.this.cleanupInProgress = false;
                        }
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            };
            Thread t = new Thread(r);
            t.start();
        }
    }

    protected void subAppend(LoggingEvent event) {
        if (event.getLevel().toInt() <= this.currentLevel) {
            long size;
            super.subAppend(event);
            if (this.fileName != null && this.qw != null && (size = ((CountingQuietWriter)this.qw).getCount()) >= this.maxFileSize && size >= this.nextRollover) {
                this.rollOver();
            }
        }
    }
}

