/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.common.logging.impl;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.carbondata.common.logging.LogService;
import org.apache.carbondata.common.logging.impl.AuditLevel;
import org.apache.carbondata.common.logging.impl.StatisticLevel;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.log4j.Logger;
import org.apache.log4j.MDC;
import org.apache.log4j.Priority;

public final class StandardLogService
implements LogService {
    private static final String PARTITION_ID = "[partitionID:";
    private Logger logger;

    public StandardLogService(String clazzName) {
        this.logger = Logger.getLogger((String)clazzName);
    }

    public StandardLogService() {
        this("Carbon");
    }

    public static String getPartitionID(String tableName) {
        return tableName.substring(tableName.lastIndexOf(95) + 1, tableName.length());
    }

    public static void setThreadName(String partitionID, String queryID) {
        StringBuilder b = new StringBuilder(PARTITION_ID);
        b.append(partitionID);
        if (null != queryID) {
            b.append(";queryID:");
            b.append(queryID);
        }
        b.append("]");
        Thread.currentThread().setName(StandardLogService.getThreadName() + b.toString());
    }

    private static String getThreadName() {
        String name = Thread.currentThread().getName();
        int index = name.indexOf(PARTITION_ID);
        name = index > -1 ? name.substring(0, index) : '[' + name + ']';
        return name.trim();
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isEnabledFor((Priority)org.apache.log4j.Level.WARN);
    }

    @Override
    public void debug(String message) {
        if (this.logger.isDebugEnabled()) {
            this.logMessage(Level.DEBUG, null, message);
        }
    }

    @Override
    public void error(String message) {
        this.logMessage(Level.ERROR, null, message);
    }

    @Override
    public void error(Throwable throwable, String message) {
        this.logMessage(Level.ERROR, throwable, message);
    }

    @Override
    public void error(Throwable throwable) {
        this.logMessage(Level.ERROR, throwable, "");
    }

    @Override
    public void info(String message) {
        if (this.logger.isInfoEnabled()) {
            this.logMessage(Level.INFO, null, message);
        }
    }

    private void logMessage(Level logLevel, Throwable throwable, String message) {
        try {
            StringBuilder buff = new StringBuilder(Thread.currentThread().getName());
            buff.append(" ");
            buff.append(message);
            message = buff.toString();
            if (Level.ERROR.toString().equalsIgnoreCase(logLevel.toString())) {
                this.logErrorMessage(throwable, message);
            } else if (Level.DEBUG.toString().equalsIgnoreCase(logLevel.toString())) {
                this.logDebugMessage(throwable, message);
            } else if (Level.INFO.toString().equalsIgnoreCase(logLevel.toString())) {
                this.logInfoMessage(throwable, message);
            } else if (Level.WARN.toString().equalsIgnoreCase(logLevel.toString())) {
                this.logWarnMessage(throwable, message);
            } else if (Level.AUDIT.toString().equalsIgnoreCase(logLevel.toString())) {
                this.audit(message);
            } else if (Level.STATISTICS == logLevel) {
                this.statistic(message);
            }
        }
        catch (Throwable t) {
            this.logger.error((Object)t);
        }
    }

    private void logErrorMessage(Throwable throwable, String message) {
        if (null == throwable) {
            this.logger.error((Object)message);
        } else {
            this.logger.error((Object)message, throwable);
        }
    }

    private void logInfoMessage(Throwable throwable, String message) {
        if (null == throwable) {
            this.logger.info((Object)message);
        } else {
            this.logger.info((Object)message, throwable);
        }
    }

    private void logDebugMessage(Throwable throwable, String message) {
        if (null == throwable) {
            this.logger.debug((Object)message);
        } else {
            this.logger.debug((Object)message, throwable);
        }
    }

    private void logWarnMessage(Throwable throwable, String message) {
        if (null == throwable) {
            this.logger.warn((Object)message);
        } else {
            this.logger.warn((Object)message, throwable);
        }
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public void warn(String message) {
        if (this.isWarnEnabled()) {
            this.logMessage(Level.WARN, null, message);
        }
    }

    public void setEventProperties(String propertyName, String propertyValue) {
        MDC.put((String)propertyName, (Object)propertyValue);
    }

    @Override
    public void audit(String msg) {
        String username;
        String hostName;
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            hostName = "localhost";
        }
        try {
            username = UserGroupInformation.getCurrentUser().getShortUserName();
        }
        catch (IOException e) {
            username = "unknown";
        }
        String threadid = Thread.currentThread().getId() + "";
        this.logger.log((Priority)AuditLevel.AUDIT, (Object)("[" + hostName + "][" + username + "][Thread-" + threadid + "]" + msg));
    }

    @Override
    public void statistic(String message) {
        this.logger.log((Priority)StatisticLevel.STATISTIC, (Object)message);
    }

    static enum Level {
        NONE(0),
        DEBUG(1),
        INFO(2),
        STATISTICS(3),
        ERROR(4),
        AUDIT(5),
        WARN(6);


        private Level(int level) {
        }
    }
}

