/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.generator.swagger;

import io.swagger.models.Swagger;
import java.nio.file.Path;
import javax.annotation.processing.Filer;
import org.apache.camel.generator.swagger.AppendableGenerator;
import org.apache.camel.generator.swagger.DestinationGenerator;
import org.apache.camel.generator.swagger.DirectToOperationId;
import org.apache.camel.generator.swagger.FilerGenerator;
import org.apache.camel.generator.swagger.PathGenerator;
import org.apache.camel.generator.swagger.RestDslDefinitionGenerator;
import org.apache.camel.generator.swagger.RestDslSourceCodeGenerator;
import org.apache.camel.util.ObjectHelper;

public abstract class RestDslGenerator<G> {
    final Swagger swagger;
    private DestinationGenerator destinationGenerator = new DirectToOperationId();

    RestDslGenerator(Swagger swagger) {
        this.swagger = (Swagger)ObjectHelper.notNull((Object)swagger, (String)"swagger");
    }

    public G withDestinationGenerator(DestinationGenerator directRouteGenerator) {
        ObjectHelper.notNull((Object)directRouteGenerator, (String)"directRouteGenerator");
        this.destinationGenerator = directRouteGenerator;
        RestDslGenerator that = this;
        return (G)that;
    }

    DestinationGenerator destinationGenerator() {
        return this.destinationGenerator;
    }

    public static RestDslSourceCodeGenerator<Appendable> toAppendable(Swagger swagger) {
        return new AppendableGenerator(swagger);
    }

    public static RestDslDefinitionGenerator toDefinition(Swagger swagger) {
        return new RestDslDefinitionGenerator(swagger);
    }

    public static RestDslSourceCodeGenerator<Filer> toFiler(Swagger swagger) {
        return new FilerGenerator(swagger);
    }

    public static RestDslSourceCodeGenerator<Path> toPath(Swagger swagger) {
        return new PathGenerator(swagger);
    }
}

