/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.jsonapi.springboot;

import org.apache.camel.spring.boot.DataFormatConfigurationPropertiesCommon;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * Marshal and unmarshal JSON:API resources using JSONAPI-Converter library.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@ConfigurationProperties(prefix = "camel.dataformat.json-api")
public class JsonApiDataFormatConfiguration
        extends
            DataFormatConfigurationPropertiesCommon {

    /**
     * Whether to enable auto configuration of the jsonApi data format. This is
     * enabled by default.
     */
    private Boolean enabled;
    /**
     * The classes to take into account for the marshalling. Multiple classes
     * can be separated by comma.
     */
    private String dataFormatTypes;
    /**
     * The class to take into account while unmarshalling.
     */
    private String mainFormatType;

    public String getDataFormatTypes() {
        return dataFormatTypes;
    }

    public void setDataFormatTypes(String dataFormatTypes) {
        this.dataFormatTypes = dataFormatTypes;
    }

    public String getMainFormatType() {
        return mainFormatType;
    }

    public void setMainFormatType(String mainFormatType) {
        this.mainFormatType = mainFormatType;
    }
}