/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.milo.server.springboot;

import java.security.cert.X509Certificate;
import java.util.Set;
import javax.annotation.Generated;
import org.apache.camel.spring.boot.ComponentConfigurationPropertiesCommon;
import org.eclipse.milo.opcua.stack.core.security.CertificateManager;
import org.eclipse.milo.opcua.stack.core.security.CertificateValidator;
import org.eclipse.milo.opcua.stack.core.security.SecurityPolicy;
import org.eclipse.milo.opcua.stack.core.types.structured.BuildInfo;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.DeprecatedConfigurationProperty;

/**
 * Make telemetry data available as an OPC UA server.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.springboot.maven.SpringBootAutoConfigurationMojo")
@ConfigurationProperties(prefix = "camel.component.milo-server")
public class MiloServerComponentConfiguration
        extends
            ComponentConfigurationPropertiesCommon {

    /**
     * Whether to enable auto configuration of the milo-server component. This
     * is enabled by default.
     */
    private Boolean enabled;
    /**
     * The application name
     */
    private String applicationName;
    /**
     * The application URI
     */
    private String applicationUri;
    /**
     * Set the addresses of the local addresses the server should bind to
     */
    private String bindAddresses;
    /**
     * Server build info. The option is a
     * org.eclipse.milo.opcua.stack.core.types.structured.BuildInfo type.
     */
    private BuildInfo buildInfo;
    /**
     * The URI of the namespace, defaults to urn:org:apache:camel
     */
    private String namespaceUri = "urn:org:apache:camel";
    /**
     * The path to be appended to the end of the endpoint url. (doesn't need to
     * start with '/')
     */
    private String path;
    /**
     * The TCP port the server binds to
     */
    private Integer port;
    /**
     * The product URI
     */
    private String productUri;
    /**
     * Allows for bridging the consumer to the Camel routing Error Handler,
     * which mean any exceptions occurred while the consumer is trying to pickup
     * incoming messages, or the likes, will now be processed as a message and
     * handled by the routing Error Handler. By default the consumer will use
     * the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that
     * will be logged at WARN or ERROR level and ignored.
     */
    private Boolean bridgeErrorHandler = false;
    /**
     * Whether the producer should be started lazy (on the first message). By
     * starting lazy you can use this to allow CamelContext and routes to
     * startup in situations where a producer may otherwise fail during starting
     * and cause the route to fail being started. By deferring this startup to
     * be lazy then the startup failure can be handled during routing messages
     * via Camel's routing error handlers. Beware that when the first message is
     * processed then creating and starting the producer may take a little time
     * and prolong the total processing time of the processing.
     */
    private Boolean lazyStartProducer = false;
    /**
     * Whether the component should use basic property binding (Camel 2.x) or
     * the newer property binding with additional capabilities
     */
    @Deprecated
    private Boolean basicPropertyBinding = false;
    /**
     * Server certificate. The option is a java.security.cert.X509Certificate
     * type.
     */
    private X509Certificate certificate;
    /**
     * Server certificate manager. The option is a
     * org.eclipse.milo.opcua.stack.core.security.CertificateManager type.
     */
    private CertificateManager certificateManager;
    /**
     * Validator for client certificates. The option is a
     * org.eclipse.milo.opcua.stack.core.security.CertificateValidator type.
     */
    private CertificateValidator certificateValidator;
    /**
     * Validator for client certificates using default file based approach
     */
    private String defaultCertificateValidator;
    /**
     * Enable anonymous authentication, disabled by default
     */
    private Boolean enableAnonymousAuthentication = false;
    /**
     * Security policies
     */
    private Set<SecurityPolicy> securityPolicies;
    /**
     * Security policies by URI or name. Multiple policies can be separated by
     * comma.
     */
    private String securityPoliciesById;
    /**
     * Set user password combinations in the form of user1:pwd1,user2:pwd2
     * Usernames and passwords will be URL decoded
     */
    private String userAuthenticationCredentials;
    /**
     * Set the UserTokenPolicy used when
     */
    private SecurityPolicy usernameSecurityPolicyUri;

    public String getApplicationName() {
        return applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getApplicationUri() {
        return applicationUri;
    }

    public void setApplicationUri(String applicationUri) {
        this.applicationUri = applicationUri;
    }

    public String getBindAddresses() {
        return bindAddresses;
    }

    public void setBindAddresses(String bindAddresses) {
        this.bindAddresses = bindAddresses;
    }

    public BuildInfo getBuildInfo() {
        return buildInfo;
    }

    public void setBuildInfo(BuildInfo buildInfo) {
        this.buildInfo = buildInfo;
    }

    public String getNamespaceUri() {
        return namespaceUri;
    }

    public void setNamespaceUri(String namespaceUri) {
        this.namespaceUri = namespaceUri;
    }

    public String getPath() {
        return path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Integer getPort() {
        return port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public String getProductUri() {
        return productUri;
    }

    public void setProductUri(String productUri) {
        this.productUri = productUri;
    }

    public Boolean getBridgeErrorHandler() {
        return bridgeErrorHandler;
    }

    public void setBridgeErrorHandler(Boolean bridgeErrorHandler) {
        this.bridgeErrorHandler = bridgeErrorHandler;
    }

    public Boolean getLazyStartProducer() {
        return lazyStartProducer;
    }

    public void setLazyStartProducer(Boolean lazyStartProducer) {
        this.lazyStartProducer = lazyStartProducer;
    }

    @Deprecated
    @DeprecatedConfigurationProperty
    public Boolean getBasicPropertyBinding() {
        return basicPropertyBinding;
    }

    @Deprecated
    public void setBasicPropertyBinding(Boolean basicPropertyBinding) {
        this.basicPropertyBinding = basicPropertyBinding;
    }

    public X509Certificate getCertificate() {
        return certificate;
    }

    public void setCertificate(X509Certificate certificate) {
        this.certificate = certificate;
    }

    public CertificateManager getCertificateManager() {
        return certificateManager;
    }

    public void setCertificateManager(CertificateManager certificateManager) {
        this.certificateManager = certificateManager;
    }

    public CertificateValidator getCertificateValidator() {
        return certificateValidator;
    }

    public void setCertificateValidator(
            CertificateValidator certificateValidator) {
        this.certificateValidator = certificateValidator;
    }

    public String getDefaultCertificateValidator() {
        return defaultCertificateValidator;
    }

    public void setDefaultCertificateValidator(
            String defaultCertificateValidator) {
        this.defaultCertificateValidator = defaultCertificateValidator;
    }

    public Boolean getEnableAnonymousAuthentication() {
        return enableAnonymousAuthentication;
    }

    public void setEnableAnonymousAuthentication(
            Boolean enableAnonymousAuthentication) {
        this.enableAnonymousAuthentication = enableAnonymousAuthentication;
    }

    public Set<SecurityPolicy> getSecurityPolicies() {
        return securityPolicies;
    }

    public void setSecurityPolicies(Set<SecurityPolicy> securityPolicies) {
        this.securityPolicies = securityPolicies;
    }

    public String getSecurityPoliciesById() {
        return securityPoliciesById;
    }

    public void setSecurityPoliciesById(String securityPoliciesById) {
        this.securityPoliciesById = securityPoliciesById;
    }

    public String getUserAuthenticationCredentials() {
        return userAuthenticationCredentials;
    }

    public void setUserAuthenticationCredentials(
            String userAuthenticationCredentials) {
        this.userAuthenticationCredentials = userAuthenticationCredentials;
    }

    public SecurityPolicy getUsernameSecurityPolicyUri() {
        return usernameSecurityPolicyUri;
    }

    public void setUsernameSecurityPolicyUri(
            SecurityPolicy usernameSecurityPolicyUri) {
        this.usernameSecurityPolicyUri = usernameSecurityPolicyUri;
    }
}