/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.crypto.springboot;

import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import javax.annotation.Generated;
import org.apache.camel.component.crypto.DigitalSignatureConfiguration;
import org.apache.camel.spring.boot.ComponentConfigurationPropertiesCommon;
import org.apache.camel.support.jsse.KeyStoreParameters;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.DeprecatedConfigurationProperty;

/**
 * Sign and verify exchanges using the Signature Service of the Java
 * Cryptographic Extension (JCE).
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.springboot.maven.SpringBootAutoConfigurationMojo")
@ConfigurationProperties(prefix = "camel.component.crypto")
public class DigitalSignatureComponentConfiguration
        extends
            ComponentConfigurationPropertiesCommon {

    /**
     * Whether to enable auto configuration of the crypto component. This is
     * enabled by default.
     */
    private Boolean enabled;
    /**
     * Sets the JCE name of the Algorithm that should be used for the signer.
     */
    private String algorithm = "SHA256withRSA";
    /**
     * Sets the alias used to query the KeyStore for keys and {link
     * java.security.cert.Certificate Certificates} to be used in signing and
     * verifying exchanges. This value can be provided at runtime via the
     * message header
     * org.apache.camel.component.crypto.DigitalSignatureConstants#KEYSTORE_ALIAS
     */
    private String alias;
    /**
     * Sets the reference name for a PrivateKey that can be found in the
     * registry.
     */
    private String certificateName;
    /**
     * Sets the KeyStore that can contain keys and Certficates for use in
     * signing and verifying exchanges. A KeyStore is typically used with an
     * alias, either one supplied in the Route definition or dynamically via the
     * message header CamelSignatureKeyStoreAlias. If no alias is supplied and
     * there is only a single entry in the Keystore, then this single entry will
     * be used. The option is a java.security.KeyStore type.
     */
    private KeyStore keystore;
    /**
     * Sets the reference name for a Keystore that can be found in the registry.
     */
    private String keystoreName;
    /**
     * Whether the producer should be started lazy (on the first message). By
     * starting lazy you can use this to allow CamelContext and routes to
     * startup in situations where a producer may otherwise fail during starting
     * and cause the route to fail being started. By deferring this startup to
     * be lazy then the startup failure can be handled during routing messages
     * via Camel's routing error handlers. Beware that when the first message is
     * processed then creating and starting the producer may take a little time
     * and prolong the total processing time of the processing.
     */
    private Boolean lazyStartProducer = false;
    /**
     * Set the PrivateKey that should be used to sign the exchange. The option
     * is a java.security.PrivateKey type.
     */
    private PrivateKey privateKey;
    /**
     * Sets the reference name for a PrivateKey that can be found in the
     * registry.
     */
    private String privateKeyName;
    /**
     * Set the id of the security provider that provides the configured
     * Signature algorithm.
     */
    private String provider;
    /**
     * references that should be resolved when the context changes
     */
    private String publicKeyName;
    /**
     * Sets the reference name for a SecureRandom that can be found in the
     * registry.
     */
    private String secureRandomName;
    /**
     * Set the name of the message header that should be used to store the
     * base64 encoded signature. This defaults to 'CamelDigitalSignature'
     */
    private String signatureHeaderName;
    /**
     * Whether the component should use basic property binding (Camel 2.x) or
     * the newer property binding with additional capabilities
     */
    @Deprecated
    private Boolean basicPropertyBinding = false;
    /**
     * Set the size of the buffer used to read in the Exchange payload data.
     */
    private Integer bufferSize = 2048;
    /**
     * Set the Certificate that should be used to verify the signature in the
     * exchange based on its payload. The option is a
     * java.security.cert.Certificate type.
     */
    private Certificate certificate;
    /**
     * Determines if the Signature specific headers be cleared after signing and
     * verification. Defaults to true, and should only be made otherwise at your
     * extreme peril as vital private information such as Keys and passwords may
     * escape if unset.
     */
    private Boolean clearHeaders = true;
    /**
     * To use the shared DigitalSignatureConfiguration as configuration. The
     * option is a
     * org.apache.camel.component.crypto.DigitalSignatureConfiguration type.
     */
    private DigitalSignatureConfiguration configuration;
    /**
     * Sets the KeyStore that can contain keys and Certficates for use in
     * signing and verifying exchanges based on the given KeyStoreParameters. A
     * KeyStore is typically used with an alias, either one supplied in the
     * Route definition or dynamically via the message header
     * CamelSignatureKeyStoreAlias. If no alias is supplied and there is only a
     * single entry in the Keystore, then this single entry will be used. The
     * option is a org.apache.camel.support.jsse.KeyStoreParameters type.
     */
    private KeyStoreParameters keyStoreParameters;
    /**
     * Set the PublicKey that should be used to verify the signature in the
     * exchange. The option is a java.security.PublicKey type.
     */
    private PublicKey publicKey;
    /**
     * Set the SecureRandom used to initialize the Signature service. The option
     * is a java.security.SecureRandom type.
     */
    private SecureRandom secureRandom;
    /**
     * Sets the password used to access an aliased PrivateKey in the KeyStore.
     */
    private String password;

    public String getAlgorithm() {
        return algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public String getAlias() {
        return alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getCertificateName() {
        return certificateName;
    }

    public void setCertificateName(String certificateName) {
        this.certificateName = certificateName;
    }

    public KeyStore getKeystore() {
        return keystore;
    }

    public void setKeystore(KeyStore keystore) {
        this.keystore = keystore;
    }

    public String getKeystoreName() {
        return keystoreName;
    }

    public void setKeystoreName(String keystoreName) {
        this.keystoreName = keystoreName;
    }

    public Boolean getLazyStartProducer() {
        return lazyStartProducer;
    }

    public void setLazyStartProducer(Boolean lazyStartProducer) {
        this.lazyStartProducer = lazyStartProducer;
    }

    public PrivateKey getPrivateKey() {
        return privateKey;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public String getPrivateKeyName() {
        return privateKeyName;
    }

    public void setPrivateKeyName(String privateKeyName) {
        this.privateKeyName = privateKeyName;
    }

    public String getProvider() {
        return provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public String getPublicKeyName() {
        return publicKeyName;
    }

    public void setPublicKeyName(String publicKeyName) {
        this.publicKeyName = publicKeyName;
    }

    public String getSecureRandomName() {
        return secureRandomName;
    }

    public void setSecureRandomName(String secureRandomName) {
        this.secureRandomName = secureRandomName;
    }

    public String getSignatureHeaderName() {
        return signatureHeaderName;
    }

    public void setSignatureHeaderName(String signatureHeaderName) {
        this.signatureHeaderName = signatureHeaderName;
    }

    @Deprecated
    @DeprecatedConfigurationProperty
    public Boolean getBasicPropertyBinding() {
        return basicPropertyBinding;
    }

    @Deprecated
    public void setBasicPropertyBinding(Boolean basicPropertyBinding) {
        this.basicPropertyBinding = basicPropertyBinding;
    }

    public Integer getBufferSize() {
        return bufferSize;
    }

    public void setBufferSize(Integer bufferSize) {
        this.bufferSize = bufferSize;
    }

    public Certificate getCertificate() {
        return certificate;
    }

    public void setCertificate(Certificate certificate) {
        this.certificate = certificate;
    }

    public Boolean getClearHeaders() {
        return clearHeaders;
    }

    public void setClearHeaders(Boolean clearHeaders) {
        this.clearHeaders = clearHeaders;
    }

    public DigitalSignatureConfiguration getConfiguration() {
        return configuration;
    }

    public void setConfiguration(DigitalSignatureConfiguration configuration) {
        this.configuration = configuration;
    }

    public KeyStoreParameters getKeyStoreParameters() {
        return keyStoreParameters;
    }

    public void setKeyStoreParameters(KeyStoreParameters keyStoreParameters) {
        this.keyStoreParameters = keyStoreParameters;
    }

    public PublicKey getPublicKey() {
        return publicKey;
    }

    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public SecureRandom getSecureRandom() {
        return secureRandom;
    }

    public void setSecureRandom(SecureRandom secureRandom) {
        this.secureRandom = secureRandom;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}