/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.language.bean.springboot;

import javax.annotation.Generated;
import org.apache.camel.spring.boot.LanguageConfigurationPropertiesCommon;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * Call a method of the specified Java bean passing the Exchange, Body or
 * specific headers to it.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.springboot.maven.SpringBootAutoConfigurationMojo")
@ConfigurationProperties(prefix = "camel.language.bean")
public class BeanLanguageConfiguration
        extends
            LanguageConfigurationPropertiesCommon {

    /**
     * Whether to enable auto configuration of the bean language. This is
     * enabled by default.
     */
    private Boolean enabled;
    /**
     * Scope of bean. When using singleton scope (default) the bean is created
     * or looked up only once and reused for the lifetime of the endpoint. The
     * bean should be thread-safe in case concurrent threads is calling the bean
     * at the same time. When using request scope the bean is created or looked
     * up once per request (exchange). This can be used if you want to store
     * state on a bean while processing a request and you want to call the same
     * bean instance multiple times while processing the request. The bean does
     * not have to be thread-safe as the instance is only called from the same
     * request. When using prototype scope, then the bean will be looked up or
     * created per call. However in case of lookup then this is delegated to the
     * bean registry such as Spring or CDI (if in use), which depends on their
     * configuration can act as either singleton or prototype scope. so when
     * using prototype scope then this depends on the bean registry
     * implementation.
     */
    private String scope = "Singleton";
    /**
     * Whether to trim the value to remove leading and trailing whitespaces and
     * line breaks
     */
    private Boolean trim = true;

    public String getScope() {
        return scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public Boolean getTrim() {
        return trim;
    }

    public void setTrim(Boolean trim) {
        this.trim = trim;
    }
}