/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.aws.ddb.springboot;

import javax.annotation.Generated;
import com.amazonaws.Protocol;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import org.apache.camel.component.aws.ddb.DdbComponent;
import org.apache.camel.component.aws.ddb.DdbConfiguration;
import org.apache.camel.component.aws.ddb.DdbOperations;
import org.apache.camel.spring.boot.ComponentConfigurationPropertiesCommon;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.DeprecatedConfigurationProperty;

/**
 * Store and retrieve data from AWS DynamoDB service.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.springboot.maven.SpringBootAutoConfigurationMojo")
@ConfigurationProperties(prefix = "camel.component.aws-ddb")
public class DdbComponentConfiguration
        extends
            ComponentConfigurationPropertiesCommon {

    /**
     * Whether to enable auto configuration of the aws-ddb component. This is
     * enabled by default.
     */
    private Boolean enabled;
    /**
     * To use the AmazonDynamoDB as the client. The option is a
     * com.amazonaws.services.dynamodbv2.AmazonDynamoDB type.
     */
    private AmazonDynamoDB amazonDDBClient;
    /**
     * Setting the autoDiscoverClient mechanism, if true, the component will
     * look for a client instance in the registry automatically otherwise it
     * will skip that checking.
     */
    private Boolean autoDiscoverClient = true;
    /**
     * The component configuration. The option is a
     * org.apache.camel.component.aws.ddb.DdbConfiguration type.
     */
    private DdbConfiguration configuration;
    /**
     * Determines whether or not strong consistency should be enforced when data
     * is read.
     */
    private Boolean consistentRead = false;
    /**
     * Attribute name when creating table
     */
    private String keyAttributeName;
    /**
     * Attribute type when creating table
     */
    private String keyAttributeType;
    /**
     * Whether the producer should be started lazy (on the first message). By
     * starting lazy you can use this to allow CamelContext and routes to
     * startup in situations where a producer may otherwise fail during starting
     * and cause the route to fail being started. By deferring this startup to
     * be lazy then the startup failure can be handled during routing messages
     * via Camel's routing error handlers. Beware that when the first message is
     * processed then creating and starting the producer may take a little time
     * and prolong the total processing time of the processing.
     */
    private Boolean lazyStartProducer = false;
    /**
     * What operation to perform
     */
    private DdbOperations operation = DdbOperations.PutItem;
    /**
     * To define a proxy host when instantiating the DDB client
     */
    private String proxyHost;
    /**
     * To define a proxy port when instantiating the DDB client. When using this
     * parameter, the configuration will expect the capitalized name of the
     * region (for example AP_EAST_1) You'll need to use the name
     * Regions.EU_WEST_1.name()
     */
    private Integer proxyPort;
    /**
     * To define a proxy protocol when instantiating the DDB client
     */
    private Protocol proxyProtocol = Protocol.HTTPS;
    /**
     * The provisioned throughput to reserve for reading resources from your
     * table
     */
    private Long readCapacity;
    /**
     * The region in which DDB client needs to work
     */
    private String region;
    /**
     * The provisioned throughput to reserved for writing resources to your
     * table
     */
    private Long writeCapacity;
    /**
     * Whether the component should use basic property binding (Camel 2.x) or
     * the newer property binding with additional capabilities
     */
    @Deprecated
    private Boolean basicPropertyBinding = false;
    /**
     * Amazon AWS Access Key
     */
    private String accessKey;
    /**
     * Amazon AWS Secret Key
     */
    private String secretKey;

    public AmazonDynamoDB getAmazonDDBClient() {
        return amazonDDBClient;
    }

    public void setAmazonDDBClient(AmazonDynamoDB amazonDDBClient) {
        this.amazonDDBClient = amazonDDBClient;
    }

    public Boolean getAutoDiscoverClient() {
        return autoDiscoverClient;
    }

    public void setAutoDiscoverClient(Boolean autoDiscoverClient) {
        this.autoDiscoverClient = autoDiscoverClient;
    }

    public DdbConfiguration getConfiguration() {
        return configuration;
    }

    public void setConfiguration(DdbConfiguration configuration) {
        this.configuration = configuration;
    }

    public Boolean getConsistentRead() {
        return consistentRead;
    }

    public void setConsistentRead(Boolean consistentRead) {
        this.consistentRead = consistentRead;
    }

    public String getKeyAttributeName() {
        return keyAttributeName;
    }

    public void setKeyAttributeName(String keyAttributeName) {
        this.keyAttributeName = keyAttributeName;
    }

    public String getKeyAttributeType() {
        return keyAttributeType;
    }

    public void setKeyAttributeType(String keyAttributeType) {
        this.keyAttributeType = keyAttributeType;
    }

    public Boolean getLazyStartProducer() {
        return lazyStartProducer;
    }

    public void setLazyStartProducer(Boolean lazyStartProducer) {
        this.lazyStartProducer = lazyStartProducer;
    }

    public DdbOperations getOperation() {
        return operation;
    }

    public void setOperation(DdbOperations operation) {
        this.operation = operation;
    }

    public String getProxyHost() {
        return proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public Integer getProxyPort() {
        return proxyPort;
    }

    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    public Protocol getProxyProtocol() {
        return proxyProtocol;
    }

    public void setProxyProtocol(Protocol proxyProtocol) {
        this.proxyProtocol = proxyProtocol;
    }

    public Long getReadCapacity() {
        return readCapacity;
    }

    public void setReadCapacity(Long readCapacity) {
        this.readCapacity = readCapacity;
    }

    public String getRegion() {
        return region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public Long getWriteCapacity() {
        return writeCapacity;
    }

    public void setWriteCapacity(Long writeCapacity) {
        this.writeCapacity = writeCapacity;
    }

    @Deprecated
    @DeprecatedConfigurationProperty
    public Boolean getBasicPropertyBinding() {
        return basicPropertyBinding;
    }

    @Deprecated
    public void setBasicPropertyBinding(Boolean basicPropertyBinding) {
        this.basicPropertyBinding = basicPropertyBinding;
    }

    public String getAccessKey() {
        return accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }
}