/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.jms.springboot;

import javax.annotation.Generated;
import javax.jms.ConnectionFactory;
import javax.jms.ExceptionListener;
import org.apache.camel.LoggingLevel;
import org.apache.camel.component.jms.*;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spring.boot.ComponentConfigurationPropertiesCommon;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.core.task.TaskExecutor;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.ErrorHandler;

/**
 * Sent and receive messages to/from a JMS Queue or Topic.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.springboot.maven.SpringBootAutoConfigurationMojo")
@ConfigurationProperties(prefix = "camel.component.jms")
public class JmsComponentConfiguration
        extends
            ComponentConfigurationPropertiesCommon {

    /**
     * Whether to enable auto configuration of the jms component. This is
     * enabled by default.
     */
    private Boolean enabled;
    /**
     * Sets the JMS client ID to use. Note that this value, if specified, must
     * be unique and can only be used by a single JMS connection instance. It is
     * typically only required for durable topic subscriptions. If using Apache
     * ActiveMQ you may prefer to use Virtual Topics instead.
     */
    private String clientId;
    /**
     * The connection factory to be use. A connection factory must be configured
     * either on the component or endpoint. The option is a
     * javax.jms.ConnectionFactory type.
     */
    private ConnectionFactory connectionFactory;
    /**
     * Specifies whether Camel ignores the JMSReplyTo header in messages. If
     * true, Camel does not send a reply back to the destination specified in
     * the JMSReplyTo header. You can use this option if you want Camel to
     * consume from a route and you do not want Camel to automatically send back
     * a reply message because another component in your code handles the reply
     * message. You can also use this option if you want to use Camel as a proxy
     * between different message brokers and you want to route message from one
     * system to another.
     */
    private Boolean disableReplyTo = false;
    /**
     * The durable subscriber name for specifying durable topic subscriptions.
     * The clientId option must be configured as well.
     */
    private String durableSubscriptionName;
    /**
     * Allows you to force the use of a specific javax.jms.Message
     * implementation for sending JMS messages. Possible values are: Bytes, Map,
     * Object, Stream, Text. By default, Camel would determine which JMS message
     * type to use from the In body type. This option allows you to specify it.
     */
    private JmsMessageType jmsMessageType;
    /**
     * Provides an explicit ReplyTo destination (overrides any incoming value of
     * Message.getJMSReplyTo() in consumer).
     */
    private String replyTo;
    /**
     * Specifies whether to test the connection on startup. This ensures that
     * when Camel starts that all the JMS consumers have a valid connection to
     * the JMS broker. If a connection cannot be granted then Camel throws an
     * exception on startup. This ensures that Camel is not started with failed
     * connections. The JMS producers is tested as well.
     */
    private Boolean testConnectionOnStartup = false;
    /**
     * The JMS acknowledgement name, which is one of: SESSION_TRANSACTED,
     * CLIENT_ACKNOWLEDGE, AUTO_ACKNOWLEDGE, DUPS_OK_ACKNOWLEDGE
     */
    private String acknowledgementModeName = "AUTO_ACKNOWLEDGE";
    /**
     * Consumer priorities allow you to ensure that high priority consumers
     * receive messages while they are active. Normally, active consumers
     * connected to a queue receive messages from it in a round-robin fashion.
     * When consumer priorities are in use, messages are delivered round-robin
     * if multiple active consumers exist with the same high priority. Messages
     * will only going to lower priority consumers when the high priority
     * consumers do not have credit available to consume the message, or those
     * high priority consumers have declined to accept the message (for instance
     * because it does not meet the criteria of any selectors associated with
     * the consumer).
     */
    private Integer artemisConsumerPriority;
    /**
     * Whether the JmsConsumer processes the Exchange asynchronously. If enabled
     * then the JmsConsumer may pickup the next message from the JMS queue,
     * while the previous message is being processed asynchronously (by the
     * Asynchronous Routing Engine). This means that messages may be processed
     * not 100% strictly in order. If disabled (as default) then the Exchange is
     * fully processed before the JmsConsumer will pickup the next message from
     * the JMS queue. Note if transacted has been enabled, then
     * asyncConsumer=true does not run asynchronously, as transaction must be
     * executed synchronously (Camel 3.0 may support async transactions).
     */
    private Boolean asyncConsumer = false;
    /**
     * Specifies whether the consumer container should auto-startup.
     */
    private Boolean autoStartup = true;
    /**
     * Sets the cache level by ID for the underlying JMS resources. See
     * cacheLevelName option for more details.
     */
    private Integer cacheLevel;
    /**
     * Sets the cache level by name for the underlying JMS resources. Possible
     * values are: CACHE_AUTO, CACHE_CONNECTION, CACHE_CONSUMER, CACHE_NONE, and
     * CACHE_SESSION. The default setting is CACHE_AUTO. See the Spring
     * documentation and Transactions Cache Levels for more information.
     */
    private String cacheLevelName = "CACHE_AUTO";
    /**
     * Specifies the default number of concurrent consumers when consuming from
     * JMS (not for request/reply over JMS). See also the maxMessagesPerTask
     * option to control dynamic scaling up/down of threads. When doing
     * request/reply over JMS then the option replyToConcurrentConsumers is used
     * to control number of concurrent consumers on the reply message listener.
     */
    private Integer concurrentConsumers = 1;
    /**
     * Specifies the maximum number of concurrent consumers when consuming from
     * JMS (not for request/reply over JMS). See also the maxMessagesPerTask
     * option to control dynamic scaling up/down of threads. When doing
     * request/reply over JMS then the option replyToMaxConcurrentConsumers is
     * used to control number of concurrent consumers on the reply message
     * listener.
     */
    private Integer maxConcurrentConsumers;
    /**
     * Specifies whether to use persistent delivery by default for replies.
     */
    private Boolean replyToDeliveryPersistent = true;
    /**
     * Sets the JMS selector to use
     */
    private String selector;
    /**
     * Set whether to make the subscription durable. The durable subscription
     * name to be used can be specified through the subscriptionName property.
     * Default is false. Set this to true to register a durable subscription,
     * typically in combination with a subscriptionName value (unless your
     * message listener class name is good enough as subscription name). Only
     * makes sense when listening to a topic (pub-sub domain), therefore this
     * method switches the pubSubDomain flag as well.
     */
    private Boolean subscriptionDurable = false;
    /**
     * Set the name of a subscription to create. To be applied in case of a
     * topic (pub-sub domain) with a shared or durable subscription. The
     * subscription name needs to be unique within this client's JMS client id.
     * Default is the class name of the specified message listener. Note: Only 1
     * concurrent consumer (which is the default of this message listener
     * container) is allowed for each subscription, except for a shared
     * subscription (which requires JMS 2.0).
     */
    private String subscriptionName;
    /**
     * Set whether to make the subscription shared. The shared subscription name
     * to be used can be specified through the subscriptionName property.
     * Default is false. Set this to true to register a shared subscription,
     * typically in combination with a subscriptionName value (unless your
     * message listener class name is good enough as subscription name). Note
     * that shared subscriptions may also be durable, so this flag can (and
     * often will) be combined with subscriptionDurable as well. Only makes
     * sense when listening to a topic (pub-sub domain), therefore this method
     * switches the pubSubDomain flag as well. Requires a JMS 2.0 compatible
     * message broker.
     */
    private Boolean subscriptionShared = false;
    /**
     * Specifies whether the consumer accept messages while it is stopping. You
     * may consider enabling this option, if you start and stop JMS routes at
     * runtime, while there are still messages enqueued on the queue. If this
     * option is false, and you stop the JMS route, then messages may be
     * rejected, and the JMS broker would have to attempt redeliveries, which
     * yet again may be rejected, and eventually the message may be moved at a
     * dead letter queue on the JMS broker. To avoid this its recommended to
     * enable this option.
     */
    private Boolean acceptMessagesWhileStopping = false;
    /**
     * Whether the DefaultMessageListenerContainer used in the reply managers
     * for request-reply messaging allow the
     * DefaultMessageListenerContainer.runningAllowed flag to quick stop in case
     * JmsConfiguration#isAcceptMessagesWhileStopping is enabled, and
     * org.apache.camel.CamelContext is currently being stopped. This quick stop
     * ability is enabled by default in the regular JMS consumers but to enable
     * for reply managers you must enable this flag.
     */
    private Boolean allowReplyManagerQuickStop = false;
    /**
     * The consumer type to use, which can be one of: Simple, Default, or
     * Custom. The consumer type determines which Spring JMS listener to use.
     * Default will use
     * org.springframework.jms.listener.DefaultMessageListenerContainer, Simple
     * will use org.springframework.jms.listener.SimpleMessageListenerContainer.
     * When Custom is specified, the MessageListenerContainerFactory defined by
     * the messageListenerContainerFactory option will determine what
     * org.springframework.jms.listener.AbstractMessageListenerContainer to use.
     */
    private ConsumerType consumerType = ConsumerType.Default;
    /**
     * Specifies what default TaskExecutor type to use in the
     * DefaultMessageListenerContainer, for both consumer endpoints and the
     * ReplyTo consumer of producer endpoints. Possible values: SimpleAsync
     * (uses Spring's SimpleAsyncTaskExecutor) or ThreadPool (uses Spring's
     * ThreadPoolTaskExecutor with optimal values - cached threadpool-like). If
     * not set, it defaults to the previous behaviour, which uses a cached
     * thread pool for consumer endpoints and SimpleAsync for reply consumers.
     * The use of ThreadPool is recommended to reduce thread trash in elastic
     * configurations with dynamically increasing and decreasing concurrent
     * consumers.
     */
    private DefaultTaskExecutorType defaultTaskExecutorType;
    /**
     * Enables eager loading of JMS properties and payload as soon as a message
     * is loaded which generally is inefficient as the JMS properties may not be
     * required but sometimes can catch early any issues with the underlying JMS
     * provider and the use of JMS properties. See also the option
     * eagerPoisonBody.
     */
    private Boolean eagerLoadingOfProperties = false;
    /**
     * If eagerLoadingOfProperties is enabled and the JMS message payload (JMS
     * body or JMS properties) is poison (cannot be read/mapped), then set this
     * text as the message body instead so the message can be processed (the
     * cause of the poison are already stored as exception on the Exchange).
     * This can be turned off by setting eagerPoisonBody=false. See also the
     * option eagerLoadingOfProperties.
     */
    private String eagerPoisonBody = "Poison JMS message due to ${exception.message}";
    /**
     * Specifies whether the listener session should be exposed when consuming
     * messages.
     */
    private Boolean exposeListenerSession = false;
    /**
     * Whether a JMS consumer is allowed to send a reply message to the same
     * destination that the consumer is using to consume from. This prevents an
     * endless loop by consuming and sending back the same message to itself.
     */
    private Boolean replyToSameDestinationAllowed = false;
    /**
     * Allows you to specify a custom task executor for consuming messages. The
     * option is a org.springframework.core.task.TaskExecutor type.
     */
    private TaskExecutor taskExecutor;
    /**
     * Sets delivery delay to use for send calls for JMS. This option requires
     * JMS 2.0 compliant broker.
     */
    private Long deliveryDelay = -1L;
    /**
     * Specifies the delivery mode to be used. Possible values are those defined
     * by javax.jms.DeliveryMode. NON_PERSISTENT = 1 and PERSISTENT = 2.
     */
    private Integer deliveryMode;
    /**
     * Specifies whether persistent delivery is used by default.
     */
    private Boolean deliveryPersistent = true;
    /**
     * Set if the deliveryMode, priority or timeToLive qualities of service
     * should be used when sending messages. This option is based on Spring's
     * JmsTemplate. The deliveryMode, priority and timeToLive options are
     * applied to the current endpoint. This contrasts with the
     * preserveMessageQos option, which operates at message granularity, reading
     * QoS properties exclusively from the Camel In message headers.
     */
    private Boolean explicitQosEnabled = false;
    /**
     * Sets whether JMS date properties should be formatted according to the ISO
     * 8601 standard.
     */
    private Boolean formatDateHeadersToIso8601 = false;
    /**
     * Whether the producer should be started lazy (on the first message). By
     * starting lazy you can use this to allow CamelContext and routes to
     * startup in situations where a producer may otherwise fail during starting
     * and cause the route to fail being started. By deferring this startup to
     * be lazy then the startup failure can be handled during routing messages
     * via Camel's routing error handlers. Beware that when the first message is
     * processed then creating and starting the producer may take a little time
     * and prolong the total processing time of the processing.
     */
    private Boolean lazyStartProducer = false;
    /**
     * Set to true, if you want to send message using the QoS settings specified
     * on the message, instead of the QoS settings on the JMS endpoint. The
     * following three headers are considered JMSPriority, JMSDeliveryMode, and
     * JMSExpiration. You can provide all or only some of them. If not provided,
     * Camel will fall back to use the values from the endpoint instead. So,
     * when using this option, the headers override the values from the
     * endpoint. The explicitQosEnabled option, by contrast, will only use
     * options set on the endpoint, and not values from the message header.
     */
    private Boolean preserveMessageQos = false;
    /**
     * Values greater than 1 specify the message priority when sending (where 1
     * is the lowest priority and 9 is the highest). The explicitQosEnabled
     * option must also be enabled in order for this option to have any effect.
     */
    private Integer priority = 4;
    /**
     * Specifies the default number of concurrent consumers when doing
     * request/reply over JMS. See also the maxMessagesPerTask option to control
     * dynamic scaling up/down of threads.
     */
    private Integer replyToConcurrentConsumers = 1;
    /**
     * Specifies the maximum number of concurrent consumers when using
     * request/reply over JMS. See also the maxMessagesPerTask option to control
     * dynamic scaling up/down of threads.
     */
    private Integer replyToMaxConcurrentConsumers;
    /**
     * Specifies the maximum number of concurrent consumers for continue routing
     * when timeout occurred when using request/reply over JMS.
     */
    private Integer replyToOnTimeoutMaxConcurrentConsumers = 1;
    /**
     * Provides an explicit ReplyTo destination in the JMS message, which
     * overrides the setting of replyTo. It is useful if you want to forward the
     * message to a remote Queue and receive the reply message from the ReplyTo
     * destination.
     */
    private String replyToOverride;
    /**
     * Allows for explicitly specifying which kind of strategy to use for
     * replyTo queues when doing request/reply over JMS. Possible values are:
     * Temporary, Shared, or Exclusive. By default Camel will use temporary
     * queues. However if replyTo has been configured, then Shared is used by
     * default. This option allows you to use exclusive queues instead of shared
     * ones. See Camel JMS documentation for more details, and especially the
     * notes about the implications if running in a clustered environment, and
     * the fact that Shared reply queues has lower performance than its
     * alternatives Temporary and Exclusive.
     */
    private ReplyToType replyToType;
    /**
     * The timeout for waiting for a reply when using the InOut Exchange Pattern
     * (in milliseconds). The default is 20 seconds. You can include the header
     * CamelJmsRequestTimeout to override this endpoint configured timeout
     * value, and thus have per message individual timeout values. See also the
     * requestTimeoutCheckerInterval option. The option is a long type.
     */
    private Long requestTimeout = 20000L;
    /**
     * When sending messages, specifies the time-to-live of the message (in
     * milliseconds).
     */
    private Long timeToLive = -1L;
    /**
     * This option is used to allow additional headers which may have values
     * that are invalid according to JMS specification. For example some message
     * systems such as WMQ do this with header names using prefix JMS_IBM_MQMD_
     * containing values with byte array or other invalid types. You can specify
     * multiple header names separated by comma, and use as suffix for wildcard
     * matching.
     */
    private String allowAdditionalHeaders;
    /**
     * Whether to allow sending messages with no body. If this option is false
     * and the message body is null, then an JMSException is thrown.
     */
    private Boolean allowNullBody = true;
    /**
     * If true, Camel will always make a JMS message copy of the message when it
     * is passed to the producer for sending. Copying the message is needed in
     * some situations, such as when a replyToDestinationSelectorName is set
     * (incidentally, Camel will set the alwaysCopyMessage option to true, if a
     * replyToDestinationSelectorName is set)
     */
    private Boolean alwaysCopyMessage = false;
    /**
     * When using InOut exchange pattern use this JMS property instead of
     * JMSCorrelationID JMS property to correlate messages. If set messages will
     * be correlated solely on the value of this property JMSCorrelationID
     * property will be ignored and not set by Camel.
     */
    private String correlationProperty;
    /**
     * Use this option to force disabling time to live. For example when you do
     * request/reply over JMS, then Camel will by default use the requestTimeout
     * value as time to live on the message being sent. The problem is that the
     * sender and receiver systems have to have their clocks synchronized, so
     * they are in sync. This is not always so easy to archive. So you can use
     * disableTimeToLive=true to not set a time to live value on the sent
     * message. Then the message will not expire on the receiver system. See
     * below in section About time to live for more details.
     */
    private Boolean disableTimeToLive = false;
    /**
     * When using mapJmsMessage=false Camel will create a new JMS message to
     * send to a new JMS destination if you touch the headers (get or set)
     * during the route. Set this option to true to force Camel to send the
     * original JMS message that was received.
     */
    private Boolean forceSendOriginalMessage = false;
    /**
     * Only applicable when sending to JMS destination using InOnly (eg fire and
     * forget). Enabling this option will enrich the Camel Exchange with the
     * actual JMSMessageID that was used by the JMS client when the message was
     * sent to the JMS destination.
     */
    private Boolean includeSentJMSMessageID = false;
    /**
     * Sets the cache level by name for the reply consumer when doing
     * request/reply over JMS. This option only applies when using fixed reply
     * queues (not temporary). Camel will by default use: CACHE_CONSUMER for
     * exclusive or shared w/ replyToSelectorName. And CACHE_SESSION for shared
     * without replyToSelectorName. Some JMS brokers such as IBM WebSphere may
     * require to set the replyToCacheLevelName=CACHE_NONE to work. Note: If
     * using temporary queues then CACHE_NONE is not allowed, and you must use a
     * higher value such as CACHE_CONSUMER or CACHE_SESSION.
     */
    private String replyToCacheLevelName;
    /**
     * Sets the JMS Selector using the fixed name to be used so you can filter
     * out your own replies from the others when using a shared queue (that is,
     * if you are not using a temporary reply queue).
     */
    private String replyToDestinationSelectorName;
    /**
     * Sets whether StreamMessage type is enabled or not. Message payloads of
     * streaming kind such as files, InputStream, etc will either by sent as
     * BytesMessage or StreamMessage. This option controls which kind will be
     * used. By default BytesMessage is used which enforces the entire message
     * payload to be read into memory. By enabling this option the message
     * payload is read into memory in chunks and each chunk is then written to
     * the StreamMessage until no more data.
     */
    private Boolean streamMessageTypeEnabled = false;
    /**
     * Whether to auto-discover ConnectionFactory from the registry, if no
     * connection factory has been configured. If only one instance of
     * ConnectionFactory is found then it will be used. This is enabled by
     * default.
     */
    private Boolean allowAutoWiredConnectionFactory = true;
    /**
     * Whether to auto-discover DestinationResolver from the registry, if no
     * destination resolver has been configured. If only one instance of
     * DestinationResolver is found then it will be used. This is enabled by
     * default.
     */
    private Boolean allowAutoWiredDestinationResolver = true;
    /**
     * Controls whether or not to include serialized headers. Applies only when
     * transferExchange is true. This requires that the objects are
     * serializable. Camel will exclude any non-serializable objects and log it
     * at WARN level.
     */
    private Boolean allowSerializedHeaders = false;
    /**
     * Whether optimizing for Apache Artemis streaming mode.
     */
    private Boolean artemisStreamingEnabled = true;
    /**
     * Whether to startup the JmsConsumer message listener asynchronously, when
     * starting a route. For example if a JmsConsumer cannot get a connection to
     * a remote JMS broker, then it may block while retrying and/or failover.
     * This will cause Camel to block while starting routes. By setting this
     * option to true, you will let routes startup, while the JmsConsumer
     * connects to the JMS broker using a dedicated thread in asynchronous mode.
     * If this option is used, then beware that if the connection could not be
     * established, then an exception is logged at WARN level, and the consumer
     * will not be able to receive messages; You can then restart the route to
     * retry.
     */
    private Boolean asyncStartListener = false;
    /**
     * Whether to stop the JmsConsumer message listener asynchronously, when
     * stopping a route.
     */
    private Boolean asyncStopListener = false;
    /**
     * Whether autowiring is enabled. This is used for automatic autowiring
     * options (the option must be marked as autowired) by looking up in the
     * registry to find if there is a single instance of matching type, which
     * then gets configured on the component. This can be used for automatic
     * configuring JDBC data sources, JMS connection factories, AWS Clients,
     * etc.
     */
    private Boolean autowiredEnabled = true;
    /**
     * To use a shared JMS configuration. The option is a
     * org.apache.camel.component.jms.JmsConfiguration type.
     */
    private JmsConfiguration configuration;
    /**
     * A pluggable
     * org.springframework.jms.support.destination.DestinationResolver that
     * allows you to use your own resolver (for example, to lookup the real
     * destination in a JNDI registry). The option is a
     * org.springframework.jms.support.destination.DestinationResolver type.
     */
    private DestinationResolver destinationResolver;
    /**
     * Specifies a org.springframework.util.ErrorHandler to be invoked in case
     * of any uncaught exceptions thrown while processing a Message. By default
     * these exceptions will be logged at the WARN level, if no errorHandler has
     * been configured. You can configure logging level and whether stack traces
     * should be logged using errorHandlerLoggingLevel and
     * errorHandlerLogStackTrace options. This makes it much easier to
     * configure, than having to code a custom errorHandler. The option is a
     * org.springframework.util.ErrorHandler type.
     */
    private ErrorHandler errorHandler;
    /**
     * Specifies the JMS Exception Listener that is to be notified of any
     * underlying JMS exceptions. The option is a javax.jms.ExceptionListener
     * type.
     */
    private ExceptionListener exceptionListener;
    /**
     * Specify the limit for the number of consumers that are allowed to be idle
     * at any given time.
     */
    private Integer idleConsumerLimit = 1;
    /**
     * Specifies the limit for idle executions of a receive task, not having
     * received any message within its execution. If this limit is reached, the
     * task will shut down and leave receiving to other executing tasks (in the
     * case of dynamic scheduling; see the maxConcurrentConsumers setting).
     * There is additional doc available from Spring.
     */
    private Integer idleTaskExecutionLimit = 1;
    /**
     * Whether to include all JMSXxxx properties when mapping from JMS to Camel
     * Message. Setting this to true will include properties such as JMSXAppID,
     * and JMSXUserID etc. Note: If you are using a custom headerFilterStrategy
     * then this option does not apply.
     */
    private Boolean includeAllJMSXProperties = false;
    /**
     * Pluggable strategy for encoding and decoding JMS keys so they can be
     * compliant with the JMS specification. Camel provides two implementations
     * out of the box: default and passthrough. The default strategy will safely
     * marshal dots and hyphens (. and -). The passthrough strategy leaves the
     * key as is. Can be used for JMS brokers which do not care whether JMS
     * header keys contain illegal characters. You can provide your own
     * implementation of the org.apache.camel.component.jms.JmsKeyFormatStrategy
     * and refer to it using the # notation.
     */
    private JmsKeyFormatStrategy jmsKeyFormatStrategy;
    /**
     * Specifies whether Camel should auto map the received JMS message to a
     * suited payload type, such as javax.jms.TextMessage to a String etc.
     */
    private Boolean mapJmsMessage = true;
    /**
     * The number of messages per task. -1 is unlimited. If you use a range for
     * concurrent consumers (eg min max), then this option can be used to set a
     * value to eg 100 to control how fast the consumers will shrink when less
     * work is required.
     */
    private Integer maxMessagesPerTask = -1;
    /**
     * To use a custom Spring
     * org.springframework.jms.support.converter.MessageConverter so you can be
     * in control how to map to/from a javax.jms.Message. The option is a
     * org.springframework.jms.support.converter.MessageConverter type.
     */
    private MessageConverter messageConverter;
    /**
     * To use the given MessageCreatedStrategy which are invoked when Camel
     * creates new instances of javax.jms.Message objects when Camel is sending
     * a JMS message. The option is a
     * org.apache.camel.component.jms.MessageCreatedStrategy type.
     */
    private MessageCreatedStrategy messageCreatedStrategy;
    /**
     * When sending, specifies whether message IDs should be added. This is just
     * an hint to the JMS broker. If the JMS provider accepts this hint, these
     * messages must have the message ID set to null; if the provider ignores
     * the hint, the message ID must be set to its normal unique value.
     */
    private Boolean messageIdEnabled = true;
    /**
     * Registry ID of the MessageListenerContainerFactory used to determine what
     * org.springframework.jms.listener.AbstractMessageListenerContainer to use
     * to consume messages. Setting this will automatically set consumerType to
     * Custom. The option is a
     * org.apache.camel.component.jms.MessageListenerContainerFactory type.
     */
    private MessageListenerContainerFactory messageListenerContainerFactory;
    /**
     * Specifies whether timestamps should be enabled by default on sending
     * messages. This is just an hint to the JMS broker. If the JMS provider
     * accepts this hint, these messages must have the timestamp set to zero; if
     * the provider ignores the hint the timestamp must be set to its normal
     * value.
     */
    private Boolean messageTimestampEnabled = true;
    /**
     * Specifies whether to inhibit the delivery of messages published by its
     * own connection.
     */
    private Boolean pubSubNoLocal = false;
    /**
     * To use a custom QueueBrowseStrategy when browsing queues. The option is a
     * org.apache.camel.component.jms.QueueBrowseStrategy type.
     */
    private QueueBrowseStrategy queueBrowseStrategy;
    /**
     * The timeout for receiving messages (in milliseconds). The option is a
     * long type.
     */
    private Long receiveTimeout = 1000L;
    /**
     * Specifies the interval between recovery attempts, i.e. when a connection
     * is being refreshed, in milliseconds. The default is 5000 ms, that is, 5
     * seconds. The option is a long type.
     */
    private Long recoveryInterval = 5000L;
    /**
     * Configures how often Camel should check for timed out Exchanges when
     * doing request/reply over JMS. By default Camel checks once per second.
     * But if you must react faster when a timeout occurs, then you can lower
     * this interval, to check more frequently. The timeout is determined by the
     * option requestTimeout. The option is a long type.
     */
    private Long requestTimeoutCheckerInterval = 1000L;
    /**
     * Sets whether synchronous processing should be strictly used
     */
    private Boolean synchronous = false;
    /**
     * If enabled and you are using Request Reply messaging (InOut) and an
     * Exchange failed on the consumer side, then the caused Exception will be
     * send back in response as a javax.jms.ObjectMessage. If the client is
     * Camel, the returned Exception is rethrown. This allows you to use Camel
     * JMS as a bridge in your routing - for example, using persistent queues to
     * enable robust routing. Notice that if you also have transferExchange
     * enabled, this option takes precedence. The caught exception is required
     * to be serializable. The original Exception on the consumer side can be
     * wrapped in an outer exception such as
     * org.apache.camel.RuntimeCamelException when returned to the producer. Use
     * this with caution as the data is using Java Object serialization and
     * requires the received to be able to deserialize the data at Class level,
     * which forces a strong coupling between the producers and consumer!
     */
    private Boolean transferException = false;
    /**
     * You can transfer the exchange over the wire instead of just the body and
     * headers. The following fields are transferred: In body, Out body, Fault
     * body, In headers, Out headers, Fault headers, exchange properties,
     * exchange exception. This requires that the objects are serializable.
     * Camel will exclude any non-serializable objects and log it at WARN level.
     * You must enable this option on both the producer and consumer side, so
     * Camel knows the payloads is an Exchange and not a regular payload. Use
     * this with caution as the data is using Java Object serialization and
     * requires the receiver to be able to deserialize the data at Class level,
     * which forces a strong coupling between the producers and consumers having
     * to use compatible Camel versions!
     */
    private Boolean transferExchange = false;
    /**
     * Specifies whether JMSMessageID should always be used as JMSCorrelationID
     * for InOut messages.
     */
    private Boolean useMessageIDAsCorrelationID = false;
    /**
     * Number of times to wait for provisional correlation id to be updated to
     * the actual correlation id when doing request/reply over JMS and when the
     * option useMessageIDAsCorrelationID is enabled.
     */
    private Integer waitForProvisionCorrelationToBeUpdatedCounter = 50;
    /**
     * Interval in millis to sleep each time while waiting for provisional
     * correlation id to be updated. The option is a long type.
     */
    private Long waitForProvisionCorrelationToBeUpdatedThreadSleepingTime = 100L;
    /**
     * To use a custom org.apache.camel.spi.HeaderFilterStrategy to filter
     * header to and from Camel message. The option is a
     * org.apache.camel.spi.HeaderFilterStrategy type.
     */
    private HeaderFilterStrategy headerFilterStrategy;
    /**
     * Allows to configure the default errorHandler logging level for logging
     * uncaught exceptions.
     */
    private LoggingLevel errorHandlerLoggingLevel = LoggingLevel.WARN;
    /**
     * Allows to control whether stacktraces should be logged or not, by the
     * default errorHandler.
     */
    private Boolean errorHandlerLogStackTrace = true;
    /**
     * Password to use with the ConnectionFactory. You can also configure
     * username/password directly on the ConnectionFactory.
     */
    private String password;
    /**
     * Username to use with the ConnectionFactory. You can also configure
     * username/password directly on the ConnectionFactory.
     */
    private String username;
    /**
     * Specifies whether to use transacted mode
     */
    private Boolean transacted = false;
    /**
     * Specifies whether InOut operations (request reply) default to using
     * transacted mode If this flag is set to true, then Spring JmsTemplate will
     * have sessionTransacted set to true, and the acknowledgeMode as transacted
     * on the JmsTemplate used for InOut operations. Note from Spring JMS: that
     * within a JTA transaction, the parameters passed to createQueue,
     * createTopic methods are not taken into account. Depending on the Java EE
     * transaction context, the container makes its own decisions on these
     * values. Analogously, these parameters are not taken into account within a
     * locally managed transaction either, since Spring JMS operates on an
     * existing JMS Session in this case. Setting this flag to true will use a
     * short local JMS transaction when running outside of a managed
     * transaction, and a synchronized local JMS transaction in case of a
     * managed transaction (other than an XA transaction) being present. This
     * has the effect of a local JMS transaction being managed alongside the
     * main transaction (which might be a native JDBC transaction), with the JMS
     * transaction committing right after the main transaction.
     */
    private Boolean transactedInOut = false;
    /**
     * If true, Camel will create a JmsTransactionManager, if there is no
     * transactionManager injected when option transacted=true.
     */
    private Boolean lazyCreateTransactionManager = true;
    /**
     * The Spring transaction manager to use. The option is a
     * org.springframework.transaction.PlatformTransactionManager type.
     */
    private PlatformTransactionManager transactionManager;
    /**
     * The name of the transaction to use.
     */
    private String transactionName;
    /**
     * The timeout value of the transaction (in seconds), if using transacted
     * mode.
     */
    private Integer transactionTimeout = -1;

    public String getClientId() {
        return clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public ConnectionFactory getConnectionFactory() {
        return connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public Boolean getDisableReplyTo() {
        return disableReplyTo;
    }

    public void setDisableReplyTo(Boolean disableReplyTo) {
        this.disableReplyTo = disableReplyTo;
    }

    public String getDurableSubscriptionName() {
        return durableSubscriptionName;
    }

    public void setDurableSubscriptionName(String durableSubscriptionName) {
        this.durableSubscriptionName = durableSubscriptionName;
    }

    public JmsMessageType getJmsMessageType() {
        return jmsMessageType;
    }

    public void setJmsMessageType(JmsMessageType jmsMessageType) {
        this.jmsMessageType = jmsMessageType;
    }

    public String getReplyTo() {
        return replyTo;
    }

    public void setReplyTo(String replyTo) {
        this.replyTo = replyTo;
    }

    public Boolean getTestConnectionOnStartup() {
        return testConnectionOnStartup;
    }

    public void setTestConnectionOnStartup(Boolean testConnectionOnStartup) {
        this.testConnectionOnStartup = testConnectionOnStartup;
    }

    public String getAcknowledgementModeName() {
        return acknowledgementModeName;
    }

    public void setAcknowledgementModeName(String acknowledgementModeName) {
        this.acknowledgementModeName = acknowledgementModeName;
    }

    public Integer getArtemisConsumerPriority() {
        return artemisConsumerPriority;
    }

    public void setArtemisConsumerPriority(Integer artemisConsumerPriority) {
        this.artemisConsumerPriority = artemisConsumerPriority;
    }

    public Boolean getAsyncConsumer() {
        return asyncConsumer;
    }

    public void setAsyncConsumer(Boolean asyncConsumer) {
        this.asyncConsumer = asyncConsumer;
    }

    public Boolean getAutoStartup() {
        return autoStartup;
    }

    public void setAutoStartup(Boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public Integer getCacheLevel() {
        return cacheLevel;
    }

    public void setCacheLevel(Integer cacheLevel) {
        this.cacheLevel = cacheLevel;
    }

    public String getCacheLevelName() {
        return cacheLevelName;
    }

    public void setCacheLevelName(String cacheLevelName) {
        this.cacheLevelName = cacheLevelName;
    }

    public Integer getConcurrentConsumers() {
        return concurrentConsumers;
    }

    public void setConcurrentConsumers(Integer concurrentConsumers) {
        this.concurrentConsumers = concurrentConsumers;
    }

    public Integer getMaxConcurrentConsumers() {
        return maxConcurrentConsumers;
    }

    public void setMaxConcurrentConsumers(Integer maxConcurrentConsumers) {
        this.maxConcurrentConsumers = maxConcurrentConsumers;
    }

    public Boolean getReplyToDeliveryPersistent() {
        return replyToDeliveryPersistent;
    }

    public void setReplyToDeliveryPersistent(Boolean replyToDeliveryPersistent) {
        this.replyToDeliveryPersistent = replyToDeliveryPersistent;
    }

    public String getSelector() {
        return selector;
    }

    public void setSelector(String selector) {
        this.selector = selector;
    }

    public Boolean getSubscriptionDurable() {
        return subscriptionDurable;
    }

    public void setSubscriptionDurable(Boolean subscriptionDurable) {
        this.subscriptionDurable = subscriptionDurable;
    }

    public String getSubscriptionName() {
        return subscriptionName;
    }

    public void setSubscriptionName(String subscriptionName) {
        this.subscriptionName = subscriptionName;
    }

    public Boolean getSubscriptionShared() {
        return subscriptionShared;
    }

    public void setSubscriptionShared(Boolean subscriptionShared) {
        this.subscriptionShared = subscriptionShared;
    }

    public Boolean getAcceptMessagesWhileStopping() {
        return acceptMessagesWhileStopping;
    }

    public void setAcceptMessagesWhileStopping(
            Boolean acceptMessagesWhileStopping) {
        this.acceptMessagesWhileStopping = acceptMessagesWhileStopping;
    }

    public Boolean getAllowReplyManagerQuickStop() {
        return allowReplyManagerQuickStop;
    }

    public void setAllowReplyManagerQuickStop(Boolean allowReplyManagerQuickStop) {
        this.allowReplyManagerQuickStop = allowReplyManagerQuickStop;
    }

    public ConsumerType getConsumerType() {
        return consumerType;
    }

    public void setConsumerType(ConsumerType consumerType) {
        this.consumerType = consumerType;
    }

    public DefaultTaskExecutorType getDefaultTaskExecutorType() {
        return defaultTaskExecutorType;
    }

    public void setDefaultTaskExecutorType(
            DefaultTaskExecutorType defaultTaskExecutorType) {
        this.defaultTaskExecutorType = defaultTaskExecutorType;
    }

    public Boolean getEagerLoadingOfProperties() {
        return eagerLoadingOfProperties;
    }

    public void setEagerLoadingOfProperties(Boolean eagerLoadingOfProperties) {
        this.eagerLoadingOfProperties = eagerLoadingOfProperties;
    }

    public String getEagerPoisonBody() {
        return eagerPoisonBody;
    }

    public void setEagerPoisonBody(String eagerPoisonBody) {
        this.eagerPoisonBody = eagerPoisonBody;
    }

    public Boolean getExposeListenerSession() {
        return exposeListenerSession;
    }

    public void setExposeListenerSession(Boolean exposeListenerSession) {
        this.exposeListenerSession = exposeListenerSession;
    }

    public Boolean getReplyToSameDestinationAllowed() {
        return replyToSameDestinationAllowed;
    }

    public void setReplyToSameDestinationAllowed(
            Boolean replyToSameDestinationAllowed) {
        this.replyToSameDestinationAllowed = replyToSameDestinationAllowed;
    }

    public TaskExecutor getTaskExecutor() {
        return taskExecutor;
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public Long getDeliveryDelay() {
        return deliveryDelay;
    }

    public void setDeliveryDelay(Long deliveryDelay) {
        this.deliveryDelay = deliveryDelay;
    }

    public Integer getDeliveryMode() {
        return deliveryMode;
    }

    public void setDeliveryMode(Integer deliveryMode) {
        this.deliveryMode = deliveryMode;
    }

    public Boolean getDeliveryPersistent() {
        return deliveryPersistent;
    }

    public void setDeliveryPersistent(Boolean deliveryPersistent) {
        this.deliveryPersistent = deliveryPersistent;
    }

    public Boolean getExplicitQosEnabled() {
        return explicitQosEnabled;
    }

    public void setExplicitQosEnabled(Boolean explicitQosEnabled) {
        this.explicitQosEnabled = explicitQosEnabled;
    }

    public Boolean getFormatDateHeadersToIso8601() {
        return formatDateHeadersToIso8601;
    }

    public void setFormatDateHeadersToIso8601(Boolean formatDateHeadersToIso8601) {
        this.formatDateHeadersToIso8601 = formatDateHeadersToIso8601;
    }

    public Boolean getLazyStartProducer() {
        return lazyStartProducer;
    }

    public void setLazyStartProducer(Boolean lazyStartProducer) {
        this.lazyStartProducer = lazyStartProducer;
    }

    public Boolean getPreserveMessageQos() {
        return preserveMessageQos;
    }

    public void setPreserveMessageQos(Boolean preserveMessageQos) {
        this.preserveMessageQos = preserveMessageQos;
    }

    public Integer getPriority() {
        return priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public Integer getReplyToConcurrentConsumers() {
        return replyToConcurrentConsumers;
    }

    public void setReplyToConcurrentConsumers(Integer replyToConcurrentConsumers) {
        this.replyToConcurrentConsumers = replyToConcurrentConsumers;
    }

    public Integer getReplyToMaxConcurrentConsumers() {
        return replyToMaxConcurrentConsumers;
    }

    public void setReplyToMaxConcurrentConsumers(
            Integer replyToMaxConcurrentConsumers) {
        this.replyToMaxConcurrentConsumers = replyToMaxConcurrentConsumers;
    }

    public Integer getReplyToOnTimeoutMaxConcurrentConsumers() {
        return replyToOnTimeoutMaxConcurrentConsumers;
    }

    public void setReplyToOnTimeoutMaxConcurrentConsumers(
            Integer replyToOnTimeoutMaxConcurrentConsumers) {
        this.replyToOnTimeoutMaxConcurrentConsumers = replyToOnTimeoutMaxConcurrentConsumers;
    }

    public String getReplyToOverride() {
        return replyToOverride;
    }

    public void setReplyToOverride(String replyToOverride) {
        this.replyToOverride = replyToOverride;
    }

    public ReplyToType getReplyToType() {
        return replyToType;
    }

    public void setReplyToType(ReplyToType replyToType) {
        this.replyToType = replyToType;
    }

    public Long getRequestTimeout() {
        return requestTimeout;
    }

    public void setRequestTimeout(Long requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public Long getTimeToLive() {
        return timeToLive;
    }

    public void setTimeToLive(Long timeToLive) {
        this.timeToLive = timeToLive;
    }

    public String getAllowAdditionalHeaders() {
        return allowAdditionalHeaders;
    }

    public void setAllowAdditionalHeaders(String allowAdditionalHeaders) {
        this.allowAdditionalHeaders = allowAdditionalHeaders;
    }

    public Boolean getAllowNullBody() {
        return allowNullBody;
    }

    public void setAllowNullBody(Boolean allowNullBody) {
        this.allowNullBody = allowNullBody;
    }

    public Boolean getAlwaysCopyMessage() {
        return alwaysCopyMessage;
    }

    public void setAlwaysCopyMessage(Boolean alwaysCopyMessage) {
        this.alwaysCopyMessage = alwaysCopyMessage;
    }

    public String getCorrelationProperty() {
        return correlationProperty;
    }

    public void setCorrelationProperty(String correlationProperty) {
        this.correlationProperty = correlationProperty;
    }

    public Boolean getDisableTimeToLive() {
        return disableTimeToLive;
    }

    public void setDisableTimeToLive(Boolean disableTimeToLive) {
        this.disableTimeToLive = disableTimeToLive;
    }

    public Boolean getForceSendOriginalMessage() {
        return forceSendOriginalMessage;
    }

    public void setForceSendOriginalMessage(Boolean forceSendOriginalMessage) {
        this.forceSendOriginalMessage = forceSendOriginalMessage;
    }

    public Boolean getIncludeSentJMSMessageID() {
        return includeSentJMSMessageID;
    }

    public void setIncludeSentJMSMessageID(Boolean includeSentJMSMessageID) {
        this.includeSentJMSMessageID = includeSentJMSMessageID;
    }

    public String getReplyToCacheLevelName() {
        return replyToCacheLevelName;
    }

    public void setReplyToCacheLevelName(String replyToCacheLevelName) {
        this.replyToCacheLevelName = replyToCacheLevelName;
    }

    public String getReplyToDestinationSelectorName() {
        return replyToDestinationSelectorName;
    }

    public void setReplyToDestinationSelectorName(
            String replyToDestinationSelectorName) {
        this.replyToDestinationSelectorName = replyToDestinationSelectorName;
    }

    public Boolean getStreamMessageTypeEnabled() {
        return streamMessageTypeEnabled;
    }

    public void setStreamMessageTypeEnabled(Boolean streamMessageTypeEnabled) {
        this.streamMessageTypeEnabled = streamMessageTypeEnabled;
    }

    public Boolean getAllowAutoWiredConnectionFactory() {
        return allowAutoWiredConnectionFactory;
    }

    public void setAllowAutoWiredConnectionFactory(
            Boolean allowAutoWiredConnectionFactory) {
        this.allowAutoWiredConnectionFactory = allowAutoWiredConnectionFactory;
    }

    public Boolean getAllowAutoWiredDestinationResolver() {
        return allowAutoWiredDestinationResolver;
    }

    public void setAllowAutoWiredDestinationResolver(
            Boolean allowAutoWiredDestinationResolver) {
        this.allowAutoWiredDestinationResolver = allowAutoWiredDestinationResolver;
    }

    public Boolean getAllowSerializedHeaders() {
        return allowSerializedHeaders;
    }

    public void setAllowSerializedHeaders(Boolean allowSerializedHeaders) {
        this.allowSerializedHeaders = allowSerializedHeaders;
    }

    public Boolean getArtemisStreamingEnabled() {
        return artemisStreamingEnabled;
    }

    public void setArtemisStreamingEnabled(Boolean artemisStreamingEnabled) {
        this.artemisStreamingEnabled = artemisStreamingEnabled;
    }

    public Boolean getAsyncStartListener() {
        return asyncStartListener;
    }

    public void setAsyncStartListener(Boolean asyncStartListener) {
        this.asyncStartListener = asyncStartListener;
    }

    public Boolean getAsyncStopListener() {
        return asyncStopListener;
    }

    public void setAsyncStopListener(Boolean asyncStopListener) {
        this.asyncStopListener = asyncStopListener;
    }

    public Boolean getAutowiredEnabled() {
        return autowiredEnabled;
    }

    public void setAutowiredEnabled(Boolean autowiredEnabled) {
        this.autowiredEnabled = autowiredEnabled;
    }

    public JmsConfiguration getConfiguration() {
        return configuration;
    }

    public void setConfiguration(JmsConfiguration configuration) {
        this.configuration = configuration;
    }

    public DestinationResolver getDestinationResolver() {
        return destinationResolver;
    }

    public void setDestinationResolver(DestinationResolver destinationResolver) {
        this.destinationResolver = destinationResolver;
    }

    public ErrorHandler getErrorHandler() {
        return errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public ExceptionListener getExceptionListener() {
        return exceptionListener;
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    public Integer getIdleConsumerLimit() {
        return idleConsumerLimit;
    }

    public void setIdleConsumerLimit(Integer idleConsumerLimit) {
        this.idleConsumerLimit = idleConsumerLimit;
    }

    public Integer getIdleTaskExecutionLimit() {
        return idleTaskExecutionLimit;
    }

    public void setIdleTaskExecutionLimit(Integer idleTaskExecutionLimit) {
        this.idleTaskExecutionLimit = idleTaskExecutionLimit;
    }

    public Boolean getIncludeAllJMSXProperties() {
        return includeAllJMSXProperties;
    }

    public void setIncludeAllJMSXProperties(Boolean includeAllJMSXProperties) {
        this.includeAllJMSXProperties = includeAllJMSXProperties;
    }

    public JmsKeyFormatStrategy getJmsKeyFormatStrategy() {
        return jmsKeyFormatStrategy;
    }

    public void setJmsKeyFormatStrategy(
            JmsKeyFormatStrategy jmsKeyFormatStrategy) {
        this.jmsKeyFormatStrategy = jmsKeyFormatStrategy;
    }

    public Boolean getMapJmsMessage() {
        return mapJmsMessage;
    }

    public void setMapJmsMessage(Boolean mapJmsMessage) {
        this.mapJmsMessage = mapJmsMessage;
    }

    public Integer getMaxMessagesPerTask() {
        return maxMessagesPerTask;
    }

    public void setMaxMessagesPerTask(Integer maxMessagesPerTask) {
        this.maxMessagesPerTask = maxMessagesPerTask;
    }

    public MessageConverter getMessageConverter() {
        return messageConverter;
    }

    public void setMessageConverter(MessageConverter messageConverter) {
        this.messageConverter = messageConverter;
    }

    public MessageCreatedStrategy getMessageCreatedStrategy() {
        return messageCreatedStrategy;
    }

    public void setMessageCreatedStrategy(
            MessageCreatedStrategy messageCreatedStrategy) {
        this.messageCreatedStrategy = messageCreatedStrategy;
    }

    public Boolean getMessageIdEnabled() {
        return messageIdEnabled;
    }

    public void setMessageIdEnabled(Boolean messageIdEnabled) {
        this.messageIdEnabled = messageIdEnabled;
    }

    public MessageListenerContainerFactory getMessageListenerContainerFactory() {
        return messageListenerContainerFactory;
    }

    public void setMessageListenerContainerFactory(
            MessageListenerContainerFactory messageListenerContainerFactory) {
        this.messageListenerContainerFactory = messageListenerContainerFactory;
    }

    public Boolean getMessageTimestampEnabled() {
        return messageTimestampEnabled;
    }

    public void setMessageTimestampEnabled(Boolean messageTimestampEnabled) {
        this.messageTimestampEnabled = messageTimestampEnabled;
    }

    public Boolean getPubSubNoLocal() {
        return pubSubNoLocal;
    }

    public void setPubSubNoLocal(Boolean pubSubNoLocal) {
        this.pubSubNoLocal = pubSubNoLocal;
    }

    public QueueBrowseStrategy getQueueBrowseStrategy() {
        return queueBrowseStrategy;
    }

    public void setQueueBrowseStrategy(QueueBrowseStrategy queueBrowseStrategy) {
        this.queueBrowseStrategy = queueBrowseStrategy;
    }

    public Long getReceiveTimeout() {
        return receiveTimeout;
    }

    public void setReceiveTimeout(Long receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }

    public Long getRecoveryInterval() {
        return recoveryInterval;
    }

    public void setRecoveryInterval(Long recoveryInterval) {
        this.recoveryInterval = recoveryInterval;
    }

    public Long getRequestTimeoutCheckerInterval() {
        return requestTimeoutCheckerInterval;
    }

    public void setRequestTimeoutCheckerInterval(
            Long requestTimeoutCheckerInterval) {
        this.requestTimeoutCheckerInterval = requestTimeoutCheckerInterval;
    }

    public Boolean getSynchronous() {
        return synchronous;
    }

    public void setSynchronous(Boolean synchronous) {
        this.synchronous = synchronous;
    }

    public Boolean getTransferException() {
        return transferException;
    }

    public void setTransferException(Boolean transferException) {
        this.transferException = transferException;
    }

    public Boolean getTransferExchange() {
        return transferExchange;
    }

    public void setTransferExchange(Boolean transferExchange) {
        this.transferExchange = transferExchange;
    }

    public Boolean getUseMessageIDAsCorrelationID() {
        return useMessageIDAsCorrelationID;
    }

    public void setUseMessageIDAsCorrelationID(
            Boolean useMessageIDAsCorrelationID) {
        this.useMessageIDAsCorrelationID = useMessageIDAsCorrelationID;
    }

    public Integer getWaitForProvisionCorrelationToBeUpdatedCounter() {
        return waitForProvisionCorrelationToBeUpdatedCounter;
    }

    public void setWaitForProvisionCorrelationToBeUpdatedCounter(
            Integer waitForProvisionCorrelationToBeUpdatedCounter) {
        this.waitForProvisionCorrelationToBeUpdatedCounter = waitForProvisionCorrelationToBeUpdatedCounter;
    }

    public Long getWaitForProvisionCorrelationToBeUpdatedThreadSleepingTime() {
        return waitForProvisionCorrelationToBeUpdatedThreadSleepingTime;
    }

    public void setWaitForProvisionCorrelationToBeUpdatedThreadSleepingTime(
            Long waitForProvisionCorrelationToBeUpdatedThreadSleepingTime) {
        this.waitForProvisionCorrelationToBeUpdatedThreadSleepingTime = waitForProvisionCorrelationToBeUpdatedThreadSleepingTime;
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(
            HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
    }

    public LoggingLevel getErrorHandlerLoggingLevel() {
        return errorHandlerLoggingLevel;
    }

    public void setErrorHandlerLoggingLevel(
            LoggingLevel errorHandlerLoggingLevel) {
        this.errorHandlerLoggingLevel = errorHandlerLoggingLevel;
    }

    public Boolean getErrorHandlerLogStackTrace() {
        return errorHandlerLogStackTrace;
    }

    public void setErrorHandlerLogStackTrace(Boolean errorHandlerLogStackTrace) {
        this.errorHandlerLogStackTrace = errorHandlerLogStackTrace;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public Boolean getTransacted() {
        return transacted;
    }

    public void setTransacted(Boolean transacted) {
        this.transacted = transacted;
    }

    public Boolean getTransactedInOut() {
        return transactedInOut;
    }

    public void setTransactedInOut(Boolean transactedInOut) {
        this.transactedInOut = transactedInOut;
    }

    public Boolean getLazyCreateTransactionManager() {
        return lazyCreateTransactionManager;
    }

    public void setLazyCreateTransactionManager(
            Boolean lazyCreateTransactionManager) {
        this.lazyCreateTransactionManager = lazyCreateTransactionManager;
    }

    public PlatformTransactionManager getTransactionManager() {
        return transactionManager;
    }

    public void setTransactionManager(
            PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public String getTransactionName() {
        return transactionName;
    }

    public void setTransactionName(String transactionName) {
        this.transactionName = transactionName;
    }

    public Integer getTransactionTimeout() {
        return transactionTimeout;
    }

    public void setTransactionTimeout(Integer transactionTimeout) {
        this.transactionTimeout = transactionTimeout;
    }
}