/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xmlsecurity.springboot;

import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.component.xmlsecurity.XmlVerifierComponent;
import org.apache.camel.component.xmlsecurity.springboot.XmlVerifierComponentConfiguration;
import org.apache.camel.component.xmlsecurity.springboot.XmlVerifierComponentConverter;
import org.apache.camel.spi.ComponentCustomizer;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.apache.camel.spring.boot.ComponentConfigurationProperties;
import org.apache.camel.spring.boot.util.CamelPropertiesHelper;
import org.apache.camel.spring.boot.util.ConditionalOnCamelContextAndAutoConfigurationBeans;
import org.apache.camel.spring.boot.util.ConditionalOnHierarchicalProperties;
import org.apache.camel.spring.boot.util.HierarchicalPropertiesEvaluator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration(proxyBeanMethods=false)
@Conditional(value={ConditionalOnCamelContextAndAutoConfigurationBeans.class})
@EnableConfigurationProperties(value={ComponentConfigurationProperties.class, XmlVerifierComponentConfiguration.class})
@ConditionalOnHierarchicalProperties(value={"camel.component", "camel.component.xmlsecurity-verify"})
@AutoConfigureAfter(value={CamelAutoConfiguration.class, XmlVerifierComponentConverter.class})
public class XmlVerifierComponentAutoConfiguration {
    @Autowired
    private ApplicationContext applicationContext;
    private final CamelContext camelContext;
    @Autowired
    private XmlVerifierComponentConfiguration configuration;

    public XmlVerifierComponentAutoConfiguration(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Lazy
    @Bean
    public ComponentCustomizer configureXmlVerifierComponent() {
        return new ComponentCustomizer(){

            public void configure(String name, Component target) {
                CamelPropertiesHelper.copyProperties((CamelContext)XmlVerifierComponentAutoConfiguration.this.camelContext, (Object)((Object)XmlVerifierComponentAutoConfiguration.this.configuration), (Object)target);
            }

            public boolean isEnabled(String name, Component target) {
                return HierarchicalPropertiesEvaluator.evaluate((ApplicationContext)XmlVerifierComponentAutoConfiguration.this.applicationContext, (String[])new String[]{"camel.component.customizer", "camel.component.xmlsecurity-verify.customizer"}) && target instanceof XmlVerifierComponent;
            }
        };
    }
}

