/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xmlsecurity.springboot;

import java.util.LinkedHashSet;
import java.util.Set;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.dsig.spec.XPathFilterParameterSpec;
import org.apache.camel.component.xmlsecurity.api.KeyAccessor;
import org.apache.camel.component.xmlsecurity.api.XmlSignatureProperties;
import org.apache.camel.component.xmlsecurity.processor.XmlSignerConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinding;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.stereotype.Component;

@Configuration(proxyBeanMethods=false)
@ConfigurationPropertiesBinding
@Component
public class XmlSignerComponentConverter
implements GenericConverter {
    @Autowired
    private ApplicationContext applicationContext;

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        LinkedHashSet<GenericConverter.ConvertiblePair> answer = new LinkedHashSet<GenericConverter.ConvertiblePair>();
        answer.add(new GenericConverter.ConvertiblePair(String.class, AlgorithmMethod.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, KeyAccessor.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, XPathFilterParameterSpec.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, XmlSignatureProperties.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, XmlSignerConfiguration.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, URIDereferencer.class));
        return answer;
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return null;
        }
        String ref = source.toString();
        if (!ref.startsWith("#")) {
            return null;
        }
        ref = ref.startsWith("#bean:") ? ref.substring(6) : ref.substring(1);
        switch (targetType.getName()) {
            case "javax.xml.crypto.AlgorithmMethod": {
                return this.applicationContext.getBean(ref, AlgorithmMethod.class);
            }
            case "org.apache.camel.component.xmlsecurity.api.KeyAccessor": {
                return this.applicationContext.getBean(ref, KeyAccessor.class);
            }
            case "javax.xml.crypto.dsig.spec.XPathFilterParameterSpec": {
                return this.applicationContext.getBean(ref, XPathFilterParameterSpec.class);
            }
            case "org.apache.camel.component.xmlsecurity.api.XmlSignatureProperties": {
                return this.applicationContext.getBean(ref, XmlSignatureProperties.class);
            }
            case "org.apache.camel.component.xmlsecurity.processor.XmlSignerConfiguration": {
                return this.applicationContext.getBean(ref, XmlSignerConfiguration.class);
            }
            case "javax.xml.crypto.URIDereferencer": {
                return this.applicationContext.getBean(ref, URIDereferencer.class);
            }
        }
        return null;
    }
}

