/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xmlsecurity.springboot;

import java.util.LinkedHashSet;
import java.util.Set;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.URIDereferencer;
import org.apache.camel.component.xmlsecurity.api.ValidationFailedHandler;
import org.apache.camel.component.xmlsecurity.api.XmlSignature2Message;
import org.apache.camel.component.xmlsecurity.api.XmlSignatureChecker;
import org.apache.camel.component.xmlsecurity.processor.XmlVerifierConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinding;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.stereotype.Component;

@Configuration(proxyBeanMethods=false)
@ConfigurationPropertiesBinding
@Component
public class XmlVerifierComponentConverter
implements GenericConverter {
    @Autowired
    private ApplicationContext applicationContext;

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        LinkedHashSet<GenericConverter.ConvertiblePair> answer = new LinkedHashSet<GenericConverter.ConvertiblePair>();
        answer.add(new GenericConverter.ConvertiblePair(String.class, KeySelector.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, ValidationFailedHandler.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, XmlSignature2Message.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, XmlSignatureChecker.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, URIDereferencer.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, XmlVerifierConfiguration.class));
        return answer;
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return null;
        }
        String ref = source.toString();
        if (!ref.startsWith("#")) {
            return null;
        }
        ref = ref.startsWith("#bean:") ? ref.substring(6) : ref.substring(1);
        switch (targetType.getName()) {
            case "javax.xml.crypto.KeySelector": {
                return this.applicationContext.getBean(ref, KeySelector.class);
            }
            case "org.apache.camel.component.xmlsecurity.api.ValidationFailedHandler": {
                return this.applicationContext.getBean(ref, ValidationFailedHandler.class);
            }
            case "org.apache.camel.component.xmlsecurity.api.XmlSignature2Message": {
                return this.applicationContext.getBean(ref, XmlSignature2Message.class);
            }
            case "org.apache.camel.component.xmlsecurity.api.XmlSignatureChecker": {
                return this.applicationContext.getBean(ref, XmlSignatureChecker.class);
            }
            case "javax.xml.crypto.URIDereferencer": {
                return this.applicationContext.getBean(ref, URIDereferencer.class);
            }
            case "org.apache.camel.component.xmlsecurity.processor.XmlVerifierConfiguration": {
                return this.applicationContext.getBean(ref, XmlVerifierConfiguration.class);
            }
        }
        return null;
    }
}

