/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.xml.jaxb.springboot.graalvm;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.glassfish.jaxb.core.v2.model.annotation.Locatable;
import org.glassfish.jaxb.runtime.v2.model.annotation.LocatableAnnotation;
import org.glassfish.jaxb.runtime.v2.model.annotation.RuntimeInlineAnnotationReader;

@TargetClass(value=RuntimeInlineAnnotationReader.class)
final class SubstituteRuntimeInlineAnnotationReader {
    @Alias
    private Map<Class<? extends Annotation>, Map<Package, Annotation>> packageCache;

    SubstituteRuntimeInlineAnnotationReader() {
    }

    @Substitute
    public <A extends Annotation> A getFieldAnnotation(Class<A> annotation, Field field, Locatable srcPos) {
        return field.getAnnotation(annotation);
    }

    @Substitute
    public Annotation[] getAllFieldAnnotations(Field field, Locatable srcPos) {
        return field.getAnnotations();
    }

    @Substitute
    public <A extends Annotation> A getClassAnnotation(Class<A> a, Class clazz, Locatable srcPos) {
        A ann = clazz.getAnnotation(a);
        return (A)(ann != null && ann.annotationType() == XmlSeeAlso.class ? LocatableAnnotation.create(ann, (Locatable)srcPos) : ann);
    }

    @Substitute
    public <A extends Annotation> A getMethodAnnotation(Class<A> annotation, Method method, Locatable srcPos) {
        return method.getAnnotation(annotation);
    }

    @Substitute
    public Annotation[] getAllMethodAnnotations(Method method, Locatable srcPos) {
        return method.getAnnotations();
    }

    @Substitute
    public <A extends Annotation> A getMethodParameterAnnotation(Class<A> annotation, Method method, int paramIndex, Locatable srcPos) {
        Annotation[] pa;
        for (Annotation a : pa = method.getParameterAnnotations()[paramIndex]) {
            if (a.annotationType() != annotation) continue;
            return (A)a;
        }
        return null;
    }

    @Substitute
    public <A extends Annotation> A getPackageAnnotation(Class<A> a, Class clazz, Locatable srcPos) {
        Package p = clazz.getPackage();
        if (p == null) {
            return null;
        }
        Map<Package, Annotation> cache = this.packageCache.get(a);
        if (cache == null) {
            cache = new HashMap<Package, Annotation>();
            this.packageCache.put(a, cache);
        }
        if (cache.containsKey(p)) {
            return (A)cache.get(p);
        }
        A ann = p.getAnnotation(a);
        cache.put(p, (Annotation)ann);
        return ann;
    }
}

