/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.xml.jaxb.springboot;

import jakarta.xml.bind.annotation.XmlAccessOrder;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAnyAttribute;
import jakarta.xml.bind.annotation.XmlAnyElement;
import jakarta.xml.bind.annotation.XmlAttachmentRef;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementDecl;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlElementRefs;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlID;
import jakarta.xml.bind.annotation.XmlIDREF;
import jakarta.xml.bind.annotation.XmlInlineBinaryData;
import jakarta.xml.bind.annotation.XmlList;
import jakarta.xml.bind.annotation.XmlMimeType;
import jakarta.xml.bind.annotation.XmlMixed;
import jakarta.xml.bind.annotation.XmlNs;
import jakarta.xml.bind.annotation.XmlRegistry;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchema;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlSchemaTypes;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.XmlValue;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapters;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.camel.spring.boot.aot.ReflectionHelper;
import org.apache.camel.spring.boot.aot.RuntimeHintsHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.aot.hint.TypeReference;
import org.springframework.asm.ClassReader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

final class JAXBRuntimeHints
implements RuntimeHintsRegistrar {
    private static final Logger LOG = LoggerFactory.getLogger(JAXBRuntimeHints.class);
    private static final List<Class<? extends Annotation>> JAXB_ROOT_ANNOTATIONS = List.of(XmlRootElement.class, XmlType.class, XmlRegistry.class, XmlJavaTypeAdapter.class, XmlSeeAlso.class);
    private static final List<Class<? extends Annotation>> JAXB_ANNOTATIONS = List.of(XmlAccessorType.class, XmlAnyAttribute.class, XmlAnyElement.class, XmlAttachmentRef.class, XmlAttribute.class, XmlElement.class, XmlElementDecl.class, XmlElementRef.class, XmlElementRefs.class, XmlElements.class, XmlElementWrapper.class, XmlEnum.class, XmlEnumValue.class, XmlID.class, XmlIDREF.class, XmlInlineBinaryData.class, XmlList.class, XmlMimeType.class, XmlMixed.class, XmlNs.class, XmlRegistry.class, XmlRootElement.class, XmlSchema.class, XmlSchemaType.class, XmlSchemaTypes.class, XmlSeeAlso.class, XmlTransient.class, XmlType.class, XmlValue.class, XmlJavaTypeAdapter.class, XmlJavaTypeAdapters.class);
    private static final List<String> NATIVE_PROXY_DEFINITIONS = List.of("org.glassfish.jaxb.core.marshaller.CharacterEscapeHandler", "com.sun.xml.txw2.output.CharacterEscapeHandler", "org.glassfish.jaxb.core.v2.schemagen.episode.Bindings", "org.glassfish.jaxb.core.v2.schemagen.episode.SchemaBindings", "org.glassfish.jaxb.core.v2.schemagen.episode.Klass", "org.glassfish.jaxb.core.v2.schemagen.episode.Package", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.Annotated", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.Annotation", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.Any", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.Appinfo", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.AttrDecls", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.AttributeType", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.ComplexContent", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.ComplexExtension", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.ComplexRestriction", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.ComplexType", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.ComplexTypeHost", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.ComplexTypeModel", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.ContentModelContainer", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.Documentation", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.Element", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.ExplicitGroup", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.ExtensionType", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.FixedOrDefault", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.Import", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.List", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.LocalAttribute", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.LocalElement", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.NestedParticle", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.NoFixedFacet", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.Occurs", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.Particle", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.Redefinable", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.Schema", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.SchemaTop", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.SimpleContent", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.SimpleDerivation", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.SimpleExtension", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.SimpleRestriction", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.SimpleRestrictionModel", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.SimpleType", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.SimpleTypeHost", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.TopLevelAttribute", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.TopLevelElement", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.TypeDefParticle", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.TypeHost", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.Union", "org.glassfish.jaxb.runtime.v2.schemagen.xmlschema.Wildcard", "com.sun.xml.txw2.TypedXmlWriter");
    private static final List<String> JAXB_RUNTIME_CLASSES = List.of("org.glassfish.jaxb.runtime.v2.ContextFactory", "com.sun.xml.internal.stream.XMLInputFactoryImpl", "com.sun.xml.internal.stream.XMLOutputFactoryImpl", "com.sun.org.apache.xpath.internal.functions.FuncNot", "org.glassfish.jaxb.core.v2.model.nav.ReflectionNavigator", "org.glassfish.jaxb.runtime.v2.runtime.property.SingleElementLeafProperty", "org.glassfish.jaxb.runtime.v2.runtime.property.ArrayElementLeafProperty", "org.glassfish.jaxb.runtime.v2.runtime.property.SingleElementNodeProperty", "org.glassfish.jaxb.runtime.v2.runtime.property.SingleReferenceNodeProperty", "org.glassfish.jaxb.runtime.v2.runtime.property.SingleMapNodeProperty", "org.glassfish.jaxb.runtime.v2.runtime.property.ArrayElementNodeProperty", "org.glassfish.jaxb.runtime.v2.runtime.property.ArrayReferenceNodeProperty", "com.sun.org.apache.xerces.internal.impl.dv.xs.SchemaDVFactoryImpl", XmlAccessOrder.class.getName());

    JAXBRuntimeHints() {
    }

    public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
        List classes = ReflectionHelper.getClassesByAnnotations((ClassLoader)classLoader, JAXB_ROOT_ANNOTATIONS);
        for (Class c : classes) {
            if (c.isAnnotationPresent(XmlSeeAlso.class)) {
                XmlSeeAlso xmlSeeAlso = c.getAnnotation(XmlSeeAlso.class);
                for (Class type2 : xmlSeeAlso.value()) {
                    hints.reflection().registerType(type2, new MemberCategory[]{MemberCategory.INVOKE_PUBLIC_CONSTRUCTORS});
                }
            }
            ReflectionHelper.applyIfMatch((Class)c, XmlJavaTypeAdapter.class, XmlJavaTypeAdapter::value, type -> hints.reflection().registerType(type, new MemberCategory[]{MemberCategory.INVOKE_PUBLIC_CONSTRUCTORS, MemberCategory.INVOKE_DECLARED_METHODS, MemberCategory.DECLARED_FIELDS}));
            hints.reflection().registerType(c, new MemberCategory[]{MemberCategory.INVOKE_PUBLIC_CONSTRUCTORS, MemberCategory.INVOKE_DECLARED_METHODS, MemberCategory.DECLARED_FIELDS});
        }
        boolean classDetected = false;
        for (String string : JAXBRuntimeHints.getClassesFromIndexes(classLoader)) {
            RuntimeHintsHelper.registerClassHierarchy((RuntimeHints)hints, (ClassLoader)classLoader, (String)string, (MemberCategory[])new MemberCategory[]{MemberCategory.INVOKE_PUBLIC_CONSTRUCTORS, MemberCategory.INTROSPECT_DECLARED_METHODS, MemberCategory.DECLARED_FIELDS});
            classDetected = true;
        }
        if (classes.isEmpty() && !classDetected) {
            return;
        }
        hints.resources().registerPattern("*/jaxb.index");
        hints.reflection().registerTypeIfPresent(classLoader, "jakarta.xml.bind.annotation.W3CDomHandler", new MemberCategory[]{MemberCategory.INVOKE_PUBLIC_CONSTRUCTORS});
        for (Class clazz : JAXB_ANNOTATIONS) {
            hints.reflection().registerType(clazz, new MemberCategory[]{MemberCategory.INVOKE_PUBLIC_CONSTRUCTORS, MemberCategory.INVOKE_DECLARED_METHODS});
        }
        hints.proxies().registerJdkProxy(new TypeReference[]{TypeReference.of(XmlSeeAlso.class), TypeReference.of((String)"org.glassfish.jaxb.core.v2.model.annotation.Locatable")});
        for (String string : NATIVE_PROXY_DEFINITIONS) {
            hints.proxies().registerJdkProxy(new TypeReference[]{TypeReference.of((String)string)});
        }
        for (String string : JAXB_RUNTIME_CLASSES) {
            hints.reflection().registerTypeIfPresent(classLoader, string, new MemberCategory[]{MemberCategory.INVOKE_PUBLIC_CONSTRUCTORS, MemberCategory.INVOKE_DECLARED_METHODS});
        }
        hints.reflection().registerTypeIfPresent(classLoader, "jakarta.xml.bind.Messages", new MemberCategory[0]);
        hints.resources().registerPattern("jakarta/xml/bind/Messages.properties");
        hints.reflection().registerTypeIfPresent(classLoader, "jakarta.xml.bind.helpers.Messages", new MemberCategory[0]);
        hints.resources().registerPattern("jakarta/xml/bind/helpers/Messages.properties");
    }

    private static List<String> getClassesFromIndexes(ClassLoader classLoader) {
        ArrayList<String> classNames = new ArrayList<String>();
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver(classLoader);
        try {
            for (Resource resource : resolver.getResources("classpath*:**/jaxb.index")) {
                String filename = resource.getFilename();
                if (filename == null || filename.isBlank()) continue;
                String packageName = JAXBRuntimeHints.getPackageName(resource, "jaxb.index");
                if (packageName == null) {
                    LOG.debug("The package name could not be found for the resource {}", (Object)resource);
                    continue;
                }
                try (BufferedReader reader = new BufferedReader(new StringReader(resource.getContentAsString(StandardCharsets.UTF_8)));){
                    String line = reader.readLine();
                    while (line != null) {
                        if (line.startsWith("#") || line.isBlank()) {
                            line = reader.readLine();
                            continue;
                        }
                        String className = "%s%s".formatted(packageName, line.trim());
                        LOG.debug("Found the class {} to register", (Object)className);
                        classNames.add(className);
                        line = reader.readLine();
                    }
                }
            }
        }
        catch (IOException e) {
            LOG.debug("Could not load the JAXB indexes: {}", (Object)e.getMessage());
        }
        return classNames;
    }

    private static String getPackageName(Resource resource, String fileName) throws IOException {
        URL url = resource.getURL();
        String protocol = url.getProtocol();
        String packageName = null;
        if ("jar".equals(protocol)) {
            String suffix;
            String path = url.getPath();
            int index = path.indexOf(suffix = ".jar!/");
            if (index == -1) {
                LOG.trace("The jar suffix could not be found in {}", (Object)path);
            } else {
                packageName = path.substring(index + suffix.length(), path.length() - fileName.length());
            }
        } else if (resource.isFile()) {
            File file = resource.getFile();
            File[] files = file.getParentFile().listFiles((dir, name) -> name.endsWith(".class"));
            if (files != null && files.length > 0) {
                try (FileInputStream is = new FileInputStream(files[0]);){
                    ClassReader reader = new ClassReader((InputStream)is);
                    String className = reader.getClassName();
                    int index = className.lastIndexOf(47);
                    if (index == -1) {
                        packageName = "";
                    }
                    packageName = className.substring(0, index + 1);
                }
            } else {
                LOG.trace("No class file could be found in {}", (Object)file.getParentFile());
            }
        }
        if (packageName != null) {
            packageName = packageName.replace('/', '.');
        }
        return packageName;
    }
}

