/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.websocket.jsr356.springboot;

import java.util.EventListener;
import java.util.Optional;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.websocket.server.ServerContainer;
import org.apache.camel.websocket.jsr356.JSR356WebSocketComponent;
import org.apache.camel.websocket.jsr356.springboot.JSR356WebSocketComponentAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@AutoConfigureBefore(value={JSR356WebSocketComponentAutoConfiguration.class})
public class JSR356WebSocketContextListenerAutoConfiguration {
    @Bean
    public ServletContextInitializer jsr356ServletContextInitializer() {
        return new ServletContextInitializer(){

            public void onStartup(ServletContext servletContext) throws ServletException {
                servletContext.addListener((EventListener)new ServletContextListener(){

                    public void contextInitialized(ServletContextEvent sce) {
                        String contextPath = sce.getServletContext().getContextPath();
                        Optional.ofNullable(sce.getServletContext().getAttribute(ServerContainer.class.getName())).map(ServerContainer.class::cast).ifPresent(container -> JSR356WebSocketComponent.registerServer((String)contextPath, (ServerContainer)container));
                    }

                    public void contextDestroyed(ServletContextEvent sce) {
                        JSR356WebSocketComponent.unregisterServer((String)sce.getServletContext().getContextPath());
                    }
                });
            }
        };
    }
}

