/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot.actuate.health;

import java.util.Collection;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckHelper;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.context.ApplicationContext;

public class CamelHealthCheckIndicator
extends AbstractHealthIndicator {
    private final ApplicationContext applicationContext;
    private final CamelContext camelContext;

    public CamelHealthCheckIndicator(ApplicationContext applicationContext, CamelContext camelContext) {
        this.applicationContext = applicationContext;
        this.camelContext = camelContext;
    }

    protected void doHealthCheck(Health.Builder builder) throws Exception {
        builder.withDetail("name", (Object)"camel-health-check");
        builder.up();
        Collection results = HealthCheckHelper.invoke((CamelContext)this.camelContext);
        for (HealthCheck.Result result : results) {
            Map details = result.getDetails();
            boolean enabled = true;
            if (details.containsKey("check.enabled")) {
                enabled = (Boolean)details.get("check.enabled");
            }
            if (!enabled) continue;
            builder.withDetail(result.getCheck().getId(), (Object)result.getState().name());
            if (result.getState() != HealthCheck.State.DOWN) continue;
            builder.down();
        }
    }
}

