/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot.routetemplate;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.main.PropertiesRouteTemplateParametersSource;
import org.apache.camel.spi.RouteTemplateParameterSource;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.apache.camel.spring.boot.routetemplate.CamelRouteTemplateConfigurationProperties;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnBean(value={CamelAutoConfiguration.class})
@EnableConfigurationProperties(value={CamelRouteTemplateConfigurationProperties.class})
@AutoConfigureAfter(value={CamelAutoConfiguration.class})
public class CamelRouteTemplateAutoConfiguration {
    @Bean
    public RouteTemplateParameterSource routeTemplate(CamelContext camelContext, CamelRouteTemplateConfigurationProperties rt) {
        if (rt.getConfig() == null) {
            return null;
        }
        PropertiesRouteTemplateParametersSource source = new PropertiesRouteTemplateParametersSource();
        int counter = 0;
        for (Map<String, String> e : rt.getConfig()) {
            String routeId = e.remove("routeId");
            if (routeId == null) {
                routeId = e.remove("route-id");
            }
            if (routeId == null) {
                routeId = String.valueOf(counter);
                ++counter;
            }
            for (Map.Entry<String, String> entry : e.entrySet()) {
                source.addParameter(routeId, entry.getKey(), (Object)entry.getValue());
            }
        }
        camelContext.getRegistry().bind("CamelSpringBootRouteTemplateParametersSource", RouteTemplateParameterSource.class, (Object)source);
        return source;
    }
}

