/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.springboot.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.camel.maven.packaging.MvelHelper;
import org.apache.camel.springboot.maven.model.SpringBootAutoConfigureOptionModel;
import org.apache.camel.springboot.maven.model.SpringBootModel;
import org.apache.camel.tooling.util.PackageHelper;
import org.apache.camel.tooling.util.Strings;
import org.apache.camel.util.json.DeserializationException;
import org.apache.camel.util.json.JsonArray;
import org.apache.camel.util.json.JsonObject;
import org.apache.camel.util.json.Jsoner;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.mvel2.templates.TemplateRuntime;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="update-spring-boot-auto-configuration-readme", threadSafe=true)
public class UpdateSpringBootAutoConfigurationReadmeMojo
extends AbstractMojo {
    @Parameter(property="project", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${project.build.directory}")
    protected File buildDir;
    @Parameter
    protected Boolean failFast;
    @Parameter
    protected Boolean failOnMissingDescription;
    @Component
    private BuildContext buildContext;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.executeStarter(this.buildDir.getParentFile());
        }
        catch (Exception e) {
            throw new MojoFailureException("Error processing spring-configuration-metadata.json", (Throwable)e);
        }
    }

    private void executeStarter(File starter) throws Exception {
        File jsonFile = new File(this.buildDir, "classes/META-INF/spring-configuration-metadata.json");
        if (jsonFile.exists()) {
            this.getLog().debug((CharSequence)("Processing Spring Boot auto-configuration file: " + jsonFile));
            Object js = Jsoner.deserialize((Reader)new FileReader(jsonFile));
            if (js != null) {
                String name = starter.getName();
                if (!UpdateSpringBootAutoConfigurationReadmeMojo.isValidStarter(name)) {
                    return;
                }
                String componentName = name.substring(6, name.length() - 8);
                this.getLog().debug((CharSequence)("Camel component: " + componentName));
                File docFolder = new File(starter, "src/main/docs/");
                File docFile = new File(docFolder, componentName + "-starter.adoc");
                List<SpringBootAutoConfigureOptionModel> models = this.parseSpringBootAutoConfigureModels(jsonFile, null);
                boolean noDescription = false;
                for (SpringBootAutoConfigureOptionModel o : models) {
                    if (!Strings.isEmpty((String)o.getDescription())) continue;
                    noDescription = true;
                    this.getLog().warn((CharSequence)("Option " + o.getName() + " has no description"));
                }
                if (noDescription && this.isFailOnNoDescription()) {
                    throw new MojoExecutionException("Failed build due failOnMissingDescription=true");
                }
                String changed = this.templateAutoConfigurationOptions(models, componentName);
                boolean updated = this.updateAutoConfigureOptions(docFile, changed);
                if (updated) {
                    this.getLog().info((CharSequence)("Updated doc file: " + docFile));
                } else {
                    this.getLog().debug((CharSequence)("No changes to doc file: " + docFile));
                }
            }
        }
    }

    private static String asComponentName(String componentName) {
        if ("fastjson".equals(componentName)) {
            return "json-fastjson";
        }
        if ("gson".equals(componentName)) {
            return "json-gson";
        }
        if ("jackson".equals(componentName)) {
            return "json-jackson";
        }
        if ("johnzon".equals(componentName)) {
            return "json-johnzon";
        }
        if ("snakeyaml".equals(componentName)) {
            return "yaml-snakeyaml";
        }
        if ("cassandraql".equals(componentName)) {
            return "cql";
        }
        if ("josql".equals(componentName)) {
            return "sql";
        }
        if ("juel".equals(componentName)) {
            return "el";
        }
        if ("jsch".equals(componentName)) {
            return "scp";
        }
        if ("printer".equals(componentName)) {
            return "lpr";
        }
        if ("saxon".equals(componentName)) {
            return "xquery";
        }
        if ("stringtemplate".equals(componentName)) {
            return "string-template";
        }
        if ("tagsoup".equals(componentName)) {
            return "tidyMarkup";
        }
        return componentName;
    }

    private static boolean isValidStarter(String name) {
        return true;
    }

    private List<SpringBootAutoConfigureOptionModel> parseSpringBootAutoConfigureModels(File file, String include) throws IOException, DeserializationException {
        this.getLog().debug((CharSequence)("Parsing Spring Boot AutoConfigureModel using include: " + include));
        ArrayList<SpringBootAutoConfigureOptionModel> answer = new ArrayList<SpringBootAutoConfigureOptionModel>();
        JsonObject obj = (JsonObject)Jsoner.deserialize((Reader)new FileReader(file));
        JsonArray arr = (JsonArray)obj.getCollection("properties");
        if (arr != null && !arr.isEmpty()) {
            arr.forEach(e -> {
                boolean skip;
                JsonObject row = (JsonObject)e;
                String name = row.getString("name");
                String javaType = row.getString("type");
                String desc = row.getStringOrDefault("description", "");
                String defaultValue = row.getStringOrDefault("defaultValue", "");
                String deprecated = row.getStringOrDefault("deprecated", "");
                String deprecationNote = row.getStringOrDefault("deprecationNote", "");
                if ("true".equals(deprecated)) {
                    desc = "*Deprecated* " + desc;
                    if (!Strings.isEmpty((String)deprecationNote)) {
                        desc = !desc.endsWith(".") ? desc + ". Deprecation note: " + deprecationNote : desc + " Deprecation note: " + deprecationNote;
                    }
                }
                boolean bl = skip = name.endsWith("customizer.enabled") || include != null && !name.contains("." + include + ".");
                if (!skip) {
                    SpringBootAutoConfigureOptionModel model = new SpringBootAutoConfigureOptionModel();
                    model.setName(name);
                    model.setJavaType(javaType);
                    model.setDefaultValue(defaultValue);
                    model.setDescription(desc);
                    answer.add(model);
                }
            });
        }
        return answer;
    }

    private boolean updateAutoConfigureOptions(File file, String changed) throws MojoExecutionException {
        try {
            if (!file.exists()) {
                changed = "// spring-boot-auto-configure options: START\n" + changed + "\n// spring-boot-auto-configure options: END\n";
                PackageHelper.writeText((File)file, (String)changed);
                return true;
            }
            String text = PackageHelper.loadText((InputStream)new FileInputStream(file));
            String existing = Strings.between((String)text, (String)"// spring-boot-auto-configure options: START", (String)"// spring-boot-auto-configure options: END");
            if (existing != null) {
                if ((existing = existing.trim()).equals(changed = changed.trim())) {
                    return false;
                }
                String before = Strings.before((String)text, (String)"// spring-boot-auto-configure options: START");
                String after = Strings.after((String)text, (String)"// spring-boot-auto-configure options: END");
                text = before + "// spring-boot-auto-configure options: START\n" + changed + "\n// spring-boot-auto-configure options: END" + after;
                PackageHelper.writeText((File)file, (String)text);
                return true;
            }
            this.getLog().warn((CharSequence)("Cannot find markers in file " + file));
            this.getLog().warn((CharSequence)"Add the following markers");
            this.getLog().warn((CharSequence)"\t// spring-boot-auto-configure options: START");
            this.getLog().warn((CharSequence)"\t// spring-boot-auto-configure options: END");
            if (this.isFailFast()) {
                throw new MojoExecutionException("Failed build due failFast=true");
            }
            return false;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error reading file " + file + " Reason: " + e, e);
        }
    }

    private String templateAutoConfigurationOptions(List<SpringBootAutoConfigureOptionModel> options, String componentName) throws MojoExecutionException {
        SpringBootModel model = new SpringBootModel();
        model.setGroupId(this.project.getGroupId());
        model.setArtifactId("camel-" + componentName + "-starter");
        model.setVersion(this.project.getVersion());
        model.setOptions(options);
        model.setTitle(componentName);
        try {
            String template = PackageHelper.loadText((InputStream)UpdateSpringBootAutoConfigurationReadmeMojo.class.getClassLoader().getResourceAsStream("spring-boot-auto-configure-options.mvel"));
            String out = (String)TemplateRuntime.eval((String)template, (Object)model, Collections.singletonMap("util", MvelHelper.INSTANCE));
            return out;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error processing mvel template. Reason: " + e, e);
        }
    }

    private boolean isFailFast() {
        return this.failFast != null && this.failFast != false;
    }

    private boolean isFailOnNoDescription() {
        return this.failOnMissingDescription != null && this.failOnMissingDescription != false;
    }
}

