/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.springboot.maven;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate-starter", threadSafe=true, defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public class StarterGeneratorMojo
extends AbstractMojo {
    @Component
    protected ArtifactFactory artifactFactory;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${basedir}/template-starter-pom.xml")
    protected File sourcePom;
    @Parameter(defaultValue="${basedir}/../../components-starter")
    protected File startersDir;
    @Parameter(property="action", required=true)
    protected String action;
    @Parameter(property="name", required=true)
    protected String name;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!"create".equals(this.action) && !"delete".equals(this.action)) {
            throw new MojoFailureException("Unknown action: " + this.action);
        }
        if (this.name == null || this.name.isEmpty()) {
            throw new MojoFailureException("Starter name must be specified as the parameter");
        }
        if (this.name.startsWith("camel-")) {
            this.name = this.name.substring("camel-".length());
        }
        if (this.name.endsWith("-starter")) {
            this.name = this.name.substring(0, this.name.length() - "-starter".length());
        }
        try {
            this.doExecute();
        }
        catch (MojoExecutionException | MojoFailureException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to " + this.action + " starter " + this.name, e);
        }
    }

    protected void doExecute() throws Exception {
        switch (this.action) {
            case "create": {
                this.createStarter();
                break;
            }
            case "delete": {
                this.deleteStarter();
            }
        }
    }

    private void deleteStarter() throws MojoFailureException, IOException {
        this.getLog().info((CharSequence)("Deleting starter for " + this.name));
        File directory = new File(this.startersDir, "camel-" + this.name + "-starter");
        if (!directory.exists()) {
            throw new MojoFailureException("Starter does not exist: " + this.name);
        }
        FileUtils.deleteDirectory((File)directory);
        Path parent = new File(this.startersDir, "pom.xml").toPath();
        List<String> lines = Files.readAllLines(parent);
        int modulesStart = -1;
        int modulesEnd = -1;
        for (int i = 0; i < lines.size(); ++i) {
            String s2 = lines.get(i);
            if (s2.contains("<modules>")) {
                modulesStart = i + 1;
                continue;
            }
            if (!s2.contains("</modules>")) continue;
            modulesEnd = i;
        }
        lines = StarterGeneratorMojo.concat(lines.subList(0, modulesStart).stream(), lines.subList(modulesStart, modulesEnd).stream().filter(s -> !s.contains("<module>camel-" + this.name + "-starter</module>")), lines.subList(modulesEnd, lines.size()).stream()).collect(Collectors.toList());
        Files.write(parent, lines, new OpenOption[0]);
    }

    private void createStarter() throws MojoFailureException, IOException {
        this.getLog().info((CharSequence)("Creating starter for " + this.name));
        File directory = new File(this.startersDir, "camel-" + this.name + "-starter");
        if (directory.exists()) {
            if (directory.isDirectory()) {
                throw new MojoFailureException("Directory already exists: " + directory);
            }
            throw new MojoFailureException("Can not create directory as a file already exists: " + directory);
        }
        if (!directory.mkdirs()) {
            throw new MojoFailureException("Unable to create directory: " + directory);
        }
        Files.write(new File(directory, "pom.xml").toPath(), (Iterable<? extends CharSequence>)Files.lines(this.sourcePom.toPath()).map(s -> s.replaceAll("%NAME%", this.name)).collect(Collectors.toList()), new OpenOption[0]);
        Path parent = new File(this.startersDir, "pom.xml").toPath();
        List<String> lines = Files.readAllLines(parent);
        int modulesStart = -1;
        int modulesEnd = -1;
        for (int i = 0; i < lines.size(); ++i) {
            String s2 = lines.get(i);
            if (s2.contains("<modules>")) {
                modulesStart = i + 1;
                continue;
            }
            if (!s2.contains("</modules>")) continue;
            modulesEnd = i;
        }
        lines = StarterGeneratorMojo.concat(lines.subList(0, modulesStart).stream(), Stream.concat(lines.subList(modulesStart, modulesEnd).stream(), Stream.of("    <module>camel-" + this.name + "-starter</module>")).sorted().distinct(), lines.subList(modulesEnd, lines.size()).stream()).collect(Collectors.toList());
        Files.write(parent, lines, new OpenOption[0]);
    }

    private static <T> Stream<T> concat(Stream<T> s1, Stream<T> s2, Stream<T> s3) {
        return Stream.concat(s1, Stream.concat(s2, s3));
    }
}

