/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.springboot.maven;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Iterator;
import java.util.List;
import org.objectweb.asm.ClassWriter;

class DynamicClassLoader
extends URLClassLoader {
    public DynamicClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    public static DynamicClassLoader createDynamicClassLoader(List<String> classpathElements) {
        URL[] urls = new URL[classpathElements.size()];
        int i = 0;
        Iterator<String> it = classpathElements.iterator();
        while (it.hasNext()) {
            try {
                urls[i] = new File(it.next()).toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            ++i;
        }
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        return new DynamicClassLoader(urls, tccl != null ? tccl : DynamicClassLoader.class.getClassLoader());
    }

    public Class defineClass(String name, byte[] data) {
        return super.defineClass(name, data, 0, data.length);
    }

    public Class generateDummyClass(String clazzName) {
        try {
            return this.loadClass(clazzName);
        }
        catch (ClassNotFoundException e) {
            ClassWriter cw = new ClassWriter(2);
            cw.visit(52, 1, clazzName.replace('.', '/'), null, "java/lang/Object", null);
            cw.visitEnd();
            return this.defineClass(clazzName, cw.toByteArray());
        }
    }
}

