/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.springboot.maven;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="update-spring-boot-auto-configuration-readme", threadSafe=true)
public class UpdateSpringBootAutoConfigurationReadmeMojo
extends AbstractMojo {
    @Parameter(property="project", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${project.build.directory}")
    protected File buildDir;
    @Component
    private BuildContext buildContext;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.executeStarter(this.buildDir.getParentFile());
        }
        catch (Exception e) {
            throw new MojoFailureException("Error processing spring-configuration-metadata.json", (Throwable)e);
        }
    }

    private void executeStarter(File starter) throws Exception {
        String name = starter.getName();
        if ("components-starter".equals(name) || "core".equals(name)) {
            return;
        }
        if (name.startsWith("camel-")) {
            name = name.substring(6);
        }
        if (name.endsWith("-starter")) {
            name = name.substring(0, name.length() - 8);
        }
        String componentName = name;
        this.getLog().debug((CharSequence)("Camel component: " + componentName));
        Path starterPath = starter.toPath();
        Path docFolder = starterPath.resolve("src/main/docs/");
        Files.createDirectories(docFolder, new FileAttribute[0]);
        Path jsonFileCopy = docFolder.resolve(componentName + ".json");
        File jsonFile = new File(this.buildDir, "classes/META-INF/spring-configuration-metadata.json");
        if (jsonFile.exists()) {
            this.getLog().debug((CharSequence)("Copying generated Spring Boot auto-configuration file to: " + jsonFileCopy));
            byte[] contents = Files.readAllBytes(jsonFile.toPath());
            Files.write(jsonFileCopy, contents, new OpenOption[0]);
        }
    }

    private static String asComponentName(String componentName) {
        if ("fastjson".equals(componentName)) {
            return "json-fastjson";
        }
        if ("gson".equals(componentName)) {
            return "json-gson";
        }
        if ("jackson".equals(componentName)) {
            return "json-jackson";
        }
        if ("johnzon".equals(componentName)) {
            return "json-johnzon";
        }
        if ("snakeyaml".equals(componentName)) {
            return "yaml-snakeyaml";
        }
        if ("cassandraql".equals(componentName)) {
            return "cql";
        }
        if ("josql".equals(componentName)) {
            return "sql";
        }
        if ("juel".equals(componentName)) {
            return "el";
        }
        if ("jsch".equals(componentName)) {
            return "scp";
        }
        if ("printer".equals(componentName)) {
            return "lpr";
        }
        if ("saxon".equals(componentName)) {
            return "xquery";
        }
        if ("stringtemplate".equals(componentName)) {
            return "string-template";
        }
        if ("tagsoup".equals(componentName)) {
            return "tidyMarkup";
        }
        return componentName;
    }
}

