/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.springboot.maven;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.time.Duration;
import java.time.format.DateTimeParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import javax.annotation.Generated;
import org.apache.camel.maven.packaging.AbstractGeneratorMojo;
import org.apache.camel.springboot.maven.AbstractSpringBootGenerator;
import org.apache.camel.springboot.maven.DynamicClassLoader;
import org.apache.camel.tooling.model.BaseModel;
import org.apache.camel.tooling.model.ComponentModel;
import org.apache.camel.tooling.model.DataFormatModel;
import org.apache.camel.tooling.model.EipModel;
import org.apache.camel.tooling.model.JsonMapper;
import org.apache.camel.tooling.model.LanguageModel;
import org.apache.camel.tooling.model.Strings;
import org.apache.camel.tooling.util.PackageHelper;
import org.apache.camel.tooling.util.srcgen.Annotation;
import org.apache.camel.tooling.util.srcgen.GenericType;
import org.apache.camel.tooling.util.srcgen.JavaClass;
import org.apache.camel.tooling.util.srcgen.Method;
import org.apache.camel.tooling.util.srcgen.Property;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.DeprecatedConfigurationProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Mojo(name="prepare-spring-boot-auto-configuration", threadSafe=true, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public class SpringBootAutoConfigurationMojo
extends AbstractSpringBootGenerator {
    private static final String[] IGNORE_MODULES = new String[]{"camel-spring-boot-xml", "camel-spring-boot-engine"};
    private static final boolean DELETE_FILES_ON_MAIN_ARTIFACTS = false;
    private static final Map<String, String> PRIMITIVEMAP;
    private static final Map<Type, Type> PRIMITIVE_CLASSES;
    @Parameter(defaultValue="${project.build.directory}/classes")
    protected File classesDir;
    @Parameter(defaultValue="${basedir}")
    protected File baseDir;
    DynamicClassLoader projectClassLoader;
    JarFile componentJar;

    @Override
    protected boolean isIgnore(String artifactId) {
        return Arrays.asList(IGNORE_MODULES).contains(artifactId);
    }

    @Override
    protected void executeAll() throws MojoExecutionException, MojoFailureException, IOException {
        if ("camel-core".equals(this.getMainDepArtifactId())) {
            this.executeAll(this.getMainDepGroupId(), "camel-core");
            this.executeAll(this.getMainDepGroupId(), "camel-base");
            this.executeAll(this.getMainDepGroupId(), "camel-core-engine");
            this.executeAll(this.getMainDepGroupId(), "camel-core-languages");
        } else {
            this.executeAll(this.getMainDepGroupId(), this.getMainDepArtifactId());
        }
    }

    private void executeAll(String groupId, String artifactId) throws MojoExecutionException, MojoFailureException, IOException {
        try (JarFile componentJar = this.getJarFile(groupId, artifactId);){
            Map<String, Supplier<String>> files = this.getJSonFiles(componentJar);
            this.executeModels(componentJar, files);
            this.executeComponents(componentJar, files);
            this.executeDataFormats(componentJar, files);
            this.executeLanguages(componentJar, files);
        }
    }

    private void executeModels(JarFile componentJar, Map<String, Supplier<String>> files) throws MojoExecutionException, MojoFailureException {
        String pkg;
        int pos;
        EipModel model;
        String json = this.loadModelJson(files, "hystrixConfiguration");
        if (json != null) {
            model = JsonMapper.generateEipModel((String)json);
            pos = model.getJavaType().lastIndexOf(".");
            pkg = model.getJavaType().substring(0, pos) + ".springboot";
            this.createEipModelConfigurationSource(pkg, model, "camel.hystrix", true);
        }
        if ((json = this.loadModelJson(files, "resilience4jConfiguration")) != null) {
            model = JsonMapper.generateEipModel((String)json);
            pos = model.getJavaType().lastIndexOf(".");
            pkg = model.getJavaType().substring(0, pos) + ".springboot";
            this.createEipModelConfigurationSource(pkg, model, "camel.resilience4j", true);
        }
        if ((json = this.loadModelJson(files, "consulServiceDiscovery")) != null) {
            model = JsonMapper.generateEipModel((String)json);
            pos = model.getJavaType().lastIndexOf(".");
            pkg = model.getJavaType().substring(0, pos) + ".springboot";
            this.createEipModelConfigurationSource(pkg, model, "camel.cloud.consul.service-discovery", true);
        }
        if ((json = this.loadModelJson(files, "dnsServiceDiscovery")) != null) {
            model = JsonMapper.generateEipModel((String)json);
            pos = model.getJavaType().lastIndexOf(".");
            pkg = model.getJavaType().substring(0, pos) + ".springboot";
            this.createEipModelConfigurationSource(pkg, model, "camel.cloud.dns.service-discovery", true);
        }
        if ((json = this.loadModelJson(files, "etcdServiceDiscovery")) != null) {
            model = JsonMapper.generateEipModel((String)json);
            pos = model.getJavaType().lastIndexOf(".");
            pkg = model.getJavaType().substring(0, pos) + ".springboot";
            this.createEipModelConfigurationSource(pkg, model, "camel.cloud.etcd.service-discovery", true);
        }
        if ((json = this.loadModelJson(files, "kubernetesServiceDiscovery")) != null) {
            model = JsonMapper.generateEipModel((String)json);
            pos = model.getJavaType().lastIndexOf(".");
            pkg = model.getJavaType().substring(0, pos) + ".springboot";
            this.createEipModelConfigurationSource(pkg, model, "camel.cloud.kubernetes.service-discovery", true);
        }
        if ((json = this.loadModelJson(files, "ribbonLoadBalancer")) != null) {
            model = JsonMapper.generateEipModel((String)json);
            pos = model.getJavaType().lastIndexOf(".");
            pkg = model.getJavaType().substring(0, pos) + ".springboot";
            this.createEipModelConfigurationSource(pkg, model, "camel.cloud.ribbon.load-balancer", true);
        }
        if ((json = this.loadModelJson(files, "restConfiguration")) != null) {
            model = JsonMapper.generateEipModel((String)json);
            pos = model.getJavaType().lastIndexOf(".");
            pkg = model.getJavaType().substring(0, pos) + ".springboot";
            this.createRestConfigurationSource(pkg, model, "camel.rest");
            this.createRestModuleAutoConfigurationSource(pkg, model);
        }
    }

    private void createEipModelConfigurationSource(String packageName, EipModel model, String propertiesPrefix, boolean generatedNestedConfig) throws MojoFailureException {
        int pos = model.getJavaType().lastIndexOf(".");
        String commonName = model.getJavaType().substring(pos + 1) + (generatedNestedConfig ? "Common" : "Properties");
        String configName = model.getJavaType().substring(pos + 1) + (generatedNestedConfig ? "Properties" : null);
        JavaClass commonClass = new JavaClass((ClassLoader)this.getProjectClassLoader());
        commonClass.setPackage(packageName);
        commonClass.setName(commonName);
        String doc = "Generated by camel-package-maven-plugin - do not edit this file!";
        if (!Strings.isNullOrEmpty((String)model.getDescription())) {
            doc = model.getDescription() + "\n\n" + doc;
        }
        commonClass.getJavaDoc().setFullText(doc);
        commonClass.addAnnotation(Generated.class).setStringValue("value", SpringBootAutoConfigurationMojo.class.getName());
        for (EipModel.EipOptionModel option : model.getOptions()) {
            String type = option.getJavaType();
            String name = option.getName();
            if ("id".equalsIgnoreCase(name) || "parent".equalsIgnoreCase(name) || "camelContext".equalsIgnoreCase(name)) continue;
            if ("java.util.List<org.apache.camel.model.PropertyDefinition>".equalsIgnoreCase(type)) {
                type = "java.util.Map<java.lang.String, java.lang.String>";
            }
            Property prop = commonClass.addProperty(type, option.getName());
            if (!Strings.isNullOrEmpty((String)option.getDescription())) {
                prop.getField().getJavaDoc().setFullText(option.getDescription());
            }
            if (this.isBlank(option.getDefaultValue())) continue;
            if ("java.lang.String".equals(type)) {
                prop.getField().setStringInitializer(option.getDefaultValue().toString());
                continue;
            }
            if ("long".equals(type) || "java.lang.Long".equals(type)) {
                String value = option.getDefaultValue() + "L";
                prop.getField().setLiteralInitializer(value);
                continue;
            }
            if ("integer".equals(option.getType()) || "java.lang.Integer".equals(option.getJavaType()) || "boolean".equals(option.getType()) || "java.lang.Boolean".equals(option.getJavaType())) {
                prop.getField().setLiteralInitializer(option.getDefaultValue().toString());
                continue;
            }
            if (this.isBlank(option.getEnums())) continue;
            String enumShortName = type.substring(type.lastIndexOf(".") + 1);
            prop.getField().setLiteralInitializer(enumShortName + "." + option.getDefaultValue());
            commonClass.addImport(model.getJavaType());
        }
        this.writeSourceIfChanged(commonClass, packageName.replaceAll("\\.", "\\/") + "/" + commonName + ".java", true);
        Class<?> commonClazz = this.generateDummyClass(commonClass.getCanonicalName());
        if (generatedNestedConfig) {
            JavaClass configClass = new JavaClass((ClassLoader)this.getProjectClassLoader());
            configClass.setPackage(packageName);
            configClass.setName(configName);
            configClass.extendSuperType(commonClass);
            configClass.addAnnotation(Generated.class).setStringValue("value", SpringBootAutoConfigurationMojo.class.getName());
            configClass.addAnnotation(this.loadClass("org.springframework.boot.context.properties.ConfigurationProperties")).setStringValue("prefix", propertiesPrefix);
            configClass.addImport(Map.class);
            configClass.addImport(HashMap.class);
            configClass.removeImport(commonClass);
            configClass.addField().setName("enabled").setType(Boolean.TYPE).setPrivate().setLiteralInitializer("true").getJavaDoc().setFullText("Enable the component");
            configClass.addField().setName("configurations").setType(this.loadType("java.util.Map<java.lang.String, " + packageName + "." + commonName + ">")).setPrivate().setLiteralInitializer("new HashMap<>()").getJavaDoc().setFullText("Define additional configuration definitions");
            Method method = configClass.addMethod();
            method.setName("getConfigurations");
            method.setReturnType(this.loadType("java.util.Map<java.lang.String, " + packageName + "." + commonName + ">"));
            method.setPublic();
            method.setBody("return configurations;");
            method = configClass.addMethod();
            method.setName("isEnabled");
            method.setReturnType(Boolean.TYPE);
            method.setPublic();
            method.setBody("return enabled;");
            method = configClass.addMethod();
            method.setName("setEnabled");
            method.addParameter(Boolean.TYPE, "enabled");
            method.setPublic();
            method.setBody("this.enabled = enabled;");
            String fileName = packageName.replaceAll("\\.", "\\/") + "/" + configName + ".java";
            this.writeSourceIfChanged(configClass, fileName, true);
        }
    }

    private void createRestConfigurationSource(String packageName, EipModel model, String propertiesPrefix) throws MojoFailureException {
        int pos = model.getJavaType().lastIndexOf(".");
        String className = model.getJavaType().substring(pos + 1) + "Properties";
        this.generateDummyClass(packageName + "." + className);
        JavaClass javaClass = new JavaClass((ClassLoader)this.getProjectClassLoader());
        javaClass.setPackage(packageName);
        javaClass.setName(className);
        javaClass.addAnnotation(Generated.class).setStringValue("value", SpringBootAutoConfigurationMojo.class.getName());
        javaClass.addAnnotation("org.springframework.boot.context.properties.ConfigurationProperties").setStringValue("prefix", propertiesPrefix);
        String doc = "Generated by camel-package-maven-plugin - do not edit this file!";
        if (!Strings.isNullOrEmpty((String)model.getDescription())) {
            doc = model.getDescription() + "\n\n" + doc;
        }
        javaClass.getJavaDoc().setFullText(doc);
        for (EipModel.EipOptionModel option : model.getOptions()) {
            String type = option.getJavaType();
            String name = option.getName();
            if ("id".equalsIgnoreCase(name) || "parent".equalsIgnoreCase(name) || "camelContext".equalsIgnoreCase(name)) continue;
            if ("java.util.List<org.apache.camel.model.PropertyDefinition>".equalsIgnoreCase(type)) {
                type = "java.util.Map<java.lang.String, java.lang.String>";
            } else if ("java.util.List<org.apache.camel.model.rest.RestPropertyDefinition>".equalsIgnoreCase(type)) {
                type = "java.util.Map<java.lang.String, java.lang.Object>";
            }
            if ("enableCORS".equalsIgnoreCase(name)) {
                name = "enableCors";
            }
            Property prop = javaClass.addProperty(type, name);
            if (!Strings.isNullOrEmpty((String)option.getDescription())) {
                prop.getField().getJavaDoc().setFullText(option.getDescription());
            }
            if (this.isBlank(option.getDefaultValue())) continue;
            if ("java.lang.String".equals(type)) {
                prop.getField().setStringInitializer(option.getDefaultValue().toString());
                continue;
            }
            if ("long".equals(type) || "java.lang.Long".equals(type)) {
                String value = option.getDefaultValue() + "L";
                prop.getField().setLiteralInitializer(value);
                continue;
            }
            if ("integer".equals(option.getType()) || "java.lang.Integer".equals(option.getJavaType()) || "boolean".equals(option.getType()) || "java.lang.Boolean".equals(option.getJavaType())) {
                prop.getField().setLiteralInitializer(option.getDefaultValue().toString());
                continue;
            }
            if (this.isBlank(option.getEnums())) continue;
            String enumShortName = type.substring(type.lastIndexOf(".") + 1);
            prop.getField().setLiteralInitializer(enumShortName + "." + option.getDefaultValue());
            javaClass.addImport(model.getJavaType());
        }
        String fileName = packageName.replaceAll("\\.", "\\/") + "/" + className + ".java";
        this.writeSourceIfChanged(javaClass, fileName, true);
    }

    private void createRestModuleAutoConfigurationSource(String packageName, EipModel model) throws MojoFailureException {
        JavaClass javaClass = new JavaClass((ClassLoader)this.getProjectClassLoader());
        int pos = model.getJavaType().lastIndexOf(".");
        String name = model.getJavaType().substring(pos + 1) + "AutoConfiguration";
        String configType = model.getJavaType().substring(pos + 1) + "Properties";
        javaClass.setPackage(packageName);
        javaClass.setName(name);
        String doc = "Generated by camel-package-maven-plugin - do not edit this file!";
        javaClass.getJavaDoc().setFullText(doc);
        javaClass.addAnnotation(Generated.class).setStringValue("value", SpringBootAutoConfigurationMojo.class.getName());
        javaClass.addAnnotation(Configuration.class).setLiteralValue("proxyBeanMethods", "false");
        javaClass.addAnnotation(ConditionalOnBean.class).setStringValue("type", "org.apache.camel.spring.boot.CamelAutoConfiguration");
        javaClass.addAnnotation(ConditionalOnProperty.class).setStringValue("name", "camel.rest.enabled").setLiteralValue("matchIfMissing", "true");
        javaClass.addAnnotation(AutoConfigureAfter.class).setStringValue("name", "org.apache.camel.spring.boot.CamelAutoConfiguration");
        javaClass.addAnnotation(EnableConfigurationProperties.class).setLiteralValue("value", configType + ".class");
        javaClass.addImport("java.util.Map");
        javaClass.addImport("java.util.HashMap");
        javaClass.addImport("org.apache.camel.util.CollectionHelper");
        javaClass.addImport("org.apache.camel.support.IntrospectionSupport");
        javaClass.addImport("org.apache.camel.spring.boot.util.CamelPropertiesHelper");
        javaClass.addImport("org.apache.camel.CamelContext");
        javaClass.addImport("org.apache.camel.component.rest.RestComponent");
        javaClass.addImport("org.apache.camel.spi.RestConfiguration");
        javaClass.addField().setName("camelContext").setType(this.loadClass("org.apache.camel.CamelContext")).setPrivate().addAnnotation(Autowired.class);
        javaClass.addField().setName("config").setType(this.loadClass(packageName + "." + configType)).setPrivate().addAnnotation(Autowired.class);
        Method method = javaClass.addMethod();
        method.setName("configure" + model.getShortJavaType());
        method.setPublic();
        method.addThrows(Exception.class);
        method.setReturnType(this.loadClass("org.apache.camel.spi.RestConfiguration"));
        method.addAnnotation(Lazy.class);
        method.addAnnotation(Bean.class).setLiteralValue("name", "RestComponent.DEFAULT_REST_CONFIGURATION_ID");
        method.addAnnotation(ConditionalOnClass.class).setLiteralValue("value", "CamelContext.class");
        method.addAnnotation(ConditionalOnMissingBean.class);
        method.setBody("Map<String, Object> properties = new HashMap<>();\nIntrospectionSupport.getProperties(config, properties, null, false);\n// These options is configured specially further below, so remove them first\nproperties.remove(\"enableCors\");\nproperties.remove(\"apiProperty\");\nproperties.remove(\"componentProperty\");\nproperties.remove(\"consumerProperty\");\nproperties.remove(\"dataFormatProperty\");\nproperties.remove(\"endpointProperty\");\nproperties.remove(\"corsHeaders\");\n\nRestConfiguration definition = new RestConfiguration();\nCamelPropertiesHelper.setCamelProperties(camelContext, definition, properties, true);\n\n// Workaround for spring-boot properties name as It would appear\n// as enable-c-o-r-s if left uppercase in Configuration\ndefinition.setEnableCORS(config.getEnableCors());\n\nif (config.getApiProperty() != null) {\n    definition.setApiProperties(new HashMap<>(CollectionHelper.flattenKeysInMap(config.getApiProperty(), \".\")));\n}\nif (config.getComponentProperty() != null) {\n    definition.setComponentProperties(new HashMap<>(CollectionHelper.flattenKeysInMap(config.getComponentProperty(), \".\")));\n}\nif (config.getConsumerProperty() != null) {\n    definition.setConsumerProperties(new HashMap<>(CollectionHelper.flattenKeysInMap(config.getConsumerProperty(), \".\")));\n}\nif (config.getDataFormatProperty() != null) {\n    definition.setDataFormatProperties(new HashMap<>(CollectionHelper.flattenKeysInMap(config.getDataFormatProperty(), \".\")));\n}\nif (config.getEndpointProperty() != null) {\n    definition.setEndpointProperties(new HashMap<>(CollectionHelper.flattenKeysInMap(config.getEndpointProperty(), \".\")));\n}\nif (config.getCorsHeaders() != null) {\n    Map<String, Object> map = CollectionHelper.flattenKeysInMap(config.getCorsHeaders(), \".\");\n    Map<String, String> target = new HashMap<>();\n    map.forEach((k, v) -> target.put(k, v.toString()));\n    definition.setCorsHeaders(target);\n}\nreturn definition;");
        String fileName = packageName.replaceAll("\\.", "\\/") + "/" + name + ".java";
        this.writeSourceIfChanged(javaClass, fileName, true);
        this.writeComponentSpringFactorySource(packageName, name);
    }

    private void executeComponents(JarFile componentJar, Map<String, Supplier<String>> jsonFiles) throws MojoFailureException {
        List<String> componentNames = this.findComponentNames(componentJar);
        if (!componentNames.isEmpty()) {
            this.getLog().debug((CharSequence)("Found " + componentNames.size() + " components"));
            LinkedList<ComponentModel> allModels = new LinkedList<ComponentModel>();
            for (String componentName : componentNames) {
                String json = this.loadComponentJson(jsonFiles, componentName);
                if (json == null) continue;
                ComponentModel model = JsonMapper.generateComponentModel((String)json);
                allModels.add(model);
            }
            Map<String, List<ComponentModel>> grModels = allModels.stream().collect(Collectors.groupingBy(BaseModel::getJavaType));
            for (String componentClass : grModels.keySet()) {
                List<ComponentModel> compModels = grModels.get(componentClass);
                ComponentModel model = compModels.get(0);
                List aliases = compModels.stream().map(ComponentModel::getScheme).sorted().collect(Collectors.toList());
                int pos = model.getJavaType().lastIndexOf(".");
                String pkg = model.getJavaType().substring(0, pos) + ".springboot";
                String overrideComponentName = null;
                if (aliases.size() > 1) {
                    overrideComponentName = model.getArtifactId().replace("camel-", "");
                }
                this.beforeGenerateComponentSource(model);
                boolean complexOptions = model.getOptions().stream().anyMatch(this::isComplexType);
                this.createComponentConfigurationSource(pkg, model, overrideComponentName);
                this.createComponentAutoConfigurationSource(pkg, model, overrideComponentName, complexOptions);
                if (complexOptions) {
                    this.createComponentConverterSource(pkg, model);
                }
                this.createComponentSpringFactorySource(pkg, model);
            }
        }
    }

    private void beforeGenerateComponentSource(ComponentModel model) {
        if ("activemq".equals(model.getScheme()) || "amqp".equals(model.getScheme()) || "stomp".equals(model.getScheme())) {
            model.getComponentOptions().stream().filter(o -> "brokerURL".equals(o.getName())).findFirst().ifPresent(o -> o.setName("brokerUrl"));
            model.getComponentOptions().stream().filter(o -> "useMessageIDAsCorrelationID".equals(o.getName())).findFirst().ifPresent(o -> o.setName("useMessageIdAsCorrelationId"));
            model.getComponentOptions().stream().filter(o -> "includeAllJMSXProperties".equals(o.getName())).findFirst().ifPresent(o -> o.setName("includeAllJmsxProperties"));
            model.getComponentOptions().stream().filter(o -> "includeSentJMSMessageID".equals(o.getName())).findFirst().ifPresent(o -> o.setName("includeSentJmsMessageId"));
        }
    }

    private void executeDataFormats(JarFile componentJar, Map<String, Supplier<String>> jsonFiles) throws MojoFailureException {
        List<String> dataFormatNames = this.findDataFormatNames(componentJar);
        if (!dataFormatNames.isEmpty()) {
            this.getLog().debug((CharSequence)("Found " + dataFormatNames.size() + " dataformats"));
            LinkedList<DataFormatModel> allModels = new LinkedList<DataFormatModel>();
            for (String dataFormatName : dataFormatNames) {
                String json = this.loadDataFormatJson(jsonFiles, dataFormatName);
                if (json == null) continue;
                DataFormatModel model = JsonMapper.generateDataFormatModel((String)json);
                allModels.add(model);
            }
            Map<String, List<DataFormatModel>> grModels = allModels.stream().collect(Collectors.groupingBy(BaseModel::getJavaType));
            for (String dataFormatClass : grModels.keySet()) {
                List<DataFormatModel> dfModels = grModels.get(dataFormatClass);
                DataFormatModel model = dfModels.get(0);
                List aliases = dfModels.stream().map(BaseModel::getName).sorted().collect(Collectors.toList());
                int pos = model.getJavaType().lastIndexOf(".");
                String pkg = model.getJavaType().substring(0, pos) + ".springboot";
                String overrideDataFormatName = null;
                if (aliases.size() > 1) {
                    overrideDataFormatName = model.getArtifactId().replace("camel-", "");
                }
                boolean complexOptions = model.getOptions().stream().anyMatch(this::isComplexType);
                this.createDataFormatConfigurationSource(pkg, model, overrideDataFormatName);
                this.createDataFormatAutoConfigurationSource(pkg, model, overrideDataFormatName, complexOptions);
                if (complexOptions) {
                    this.createDataFormatConverterSource(pkg, model);
                }
                this.createDataFormatSpringFactorySource(pkg, model);
            }
        }
    }

    private void executeLanguages(JarFile componentJar, Map<String, Supplier<String>> jsonFiles) throws MojoFailureException {
        List<String> languageNames = this.findLanguageNames(componentJar);
        if (!languageNames.isEmpty()) {
            this.getLog().debug((CharSequence)("Found " + languageNames.size() + " languages"));
            LinkedList<LanguageModel> allModels = new LinkedList<LanguageModel>();
            for (String languageName : languageNames) {
                String json = this.loadLanguageJson(jsonFiles, languageName);
                if (json == null) continue;
                LanguageModel model = JsonMapper.generateLanguageModel((String)json);
                allModels.add(model);
            }
            Map<String, List<LanguageModel>> grModels = allModels.stream().collect(Collectors.groupingBy(BaseModel::getJavaType));
            for (String languageClass : grModels.keySet()) {
                List<LanguageModel> dfModels = grModels.get(languageClass);
                LanguageModel model = dfModels.get(0);
                List aliases = dfModels.stream().map(BaseModel::getName).sorted().collect(Collectors.toList());
                int pos = model.getJavaType().lastIndexOf(".");
                String pkg = model.getJavaType().substring(0, pos) + ".springboot";
                String overrideLanguageName = null;
                if (aliases.size() > 1) {
                    overrideLanguageName = model.getArtifactId().replace("camel-", "");
                }
                boolean complexOptions = model.getOptions().stream().anyMatch(this::isComplexType);
                this.createLanguageConfigurationSource(pkg, model, overrideLanguageName);
                this.createLanguageAutoConfigurationSource(pkg, model, overrideLanguageName, complexOptions);
                if (complexOptions) {
                    this.createLanguageConverterSource(pkg, model);
                }
                this.createLanguageSpringFactorySource(pkg, model);
            }
        }
    }

    private void createComponentConfigurationSource(String packageName, ComponentModel model, String overrideComponentName) throws MojoFailureException {
        int pos = model.getJavaType().lastIndexOf(".");
        String name = model.getJavaType().substring(pos + 1);
        name = name.replace("Component", "ComponentConfiguration");
        JavaClass javaClass = new JavaClass((ClassLoader)this.getProjectClassLoader());
        javaClass.setPackage(packageName);
        javaClass.setName(name);
        javaClass.extendSuperType("ComponentConfigurationPropertiesCommon");
        javaClass.addImport("org.apache.camel.spring.boot.ComponentConfigurationPropertiesCommon");
        Property bogus = javaClass.addProperty("java.lang.Boolean", "enabled");
        String scheme = overrideComponentName != null ? overrideComponentName : model.getScheme();
        bogus.getField().getJavaDoc().setText("Whether to enable auto configuration of the " + scheme + " component. This is enabled by default.");
        bogus.removeAccessor();
        bogus.removeMutator();
        String doc = "Generated by camel-package-maven-plugin - do not edit this file!";
        if (!Strings.isNullOrEmpty((String)model.getDescription())) {
            doc = model.getDescription() + "\n\n" + doc;
        }
        javaClass.getJavaDoc().setText(doc);
        String prefix = "camel.component." + (overrideComponentName != null ? overrideComponentName : model.getScheme());
        prefix = prefix.toLowerCase(Locale.US);
        javaClass.addAnnotation(Generated.class.getName()).setStringValue("value", SpringBootAutoConfigurationMojo.class.getName());
        javaClass.addAnnotation("org.springframework.boot.context.properties.ConfigurationProperties").setStringValue("prefix", prefix);
        for (ComponentModel.ComponentOptionModel option : model.getComponentOptions()) {
            String value;
            if (SpringBootAutoConfigurationMojo.skipComponentOption(model, option)) continue;
            String type = option.getJavaType();
            type = this.getSimpleJavaType(type);
            Property prop = javaClass.addProperty(type, option.getName());
            if (option.isDeprecated()) {
                prop.getField().addAnnotation(Deprecated.class);
                prop.getAccessor().addAnnotation(Deprecated.class);
                prop.getMutator().addAnnotation(Deprecated.class);
                prop.getAccessor().addAnnotation(DeprecatedConfigurationProperty.class);
            }
            if (!Strings.isNullOrEmpty((String)option.getDescription())) {
                boolean complex;
                String desc = option.getDescription();
                boolean bl = complex = this.isComplexTypeOrDuration(option) && this.isBlank(option.getEnums());
                if (complex) {
                    if (!desc.endsWith(".")) {
                        desc = desc + ".";
                    }
                    desc = desc + " The option is a " + option.getJavaType() + " type.";
                }
                prop.getField().getJavaDoc().setFullText(desc);
            }
            if (this.isBlank(option.getDefaultValue())) continue;
            if ("java.lang.String".equals(option.getJavaType())) {
                prop.getField().setStringInitializer(option.getDefaultValue().toString());
                continue;
            }
            if ("duration".equals(option.getType())) {
                value = this.convertDurationToMills(option.getDefaultValue().toString());
                if ("long".equals(option.getJavaType()) || "java.lang.Long".equals(option.getJavaType())) {
                    value = value + "L";
                }
                prop.getField().setLiteralInitializer(value);
                continue;
            }
            if ("long".equals(option.getJavaType()) || "java.lang.Long".equals(option.getJavaType())) {
                value = option.getDefaultValue() + "L";
                prop.getField().setLiteralInitializer(value);
                continue;
            }
            if ("integer".equals(option.getType()) || "java.lang.Integer".equals(option.getJavaType()) || "boolean".equals(option.getType()) || "java.lang.Boolean".equals(option.getJavaType())) {
                prop.getField().setLiteralInitializer(option.getDefaultValue().toString());
                continue;
            }
            if (this.isBlank(option.getEnums())) continue;
            String enumShortName = type.substring(type.lastIndexOf(".") + 1);
            prop.getField().setLiteralInitializer(enumShortName + "." + option.getDefaultValue());
            javaClass.addImport(model.getJavaType());
        }
        String fileName = packageName.replaceAll("\\.", "\\/") + "/" + name + ".java";
        this.writeSourceIfChanged(javaClass, fileName, true);
    }

    private String convertDurationToMills(String pattern) {
        String value;
        if ((pattern = pattern.toLowerCase()).contains("ms")) {
            pattern = pattern.replaceAll("ms", "");
        }
        try {
            Duration d = Duration.parse("PT" + pattern);
            value = String.valueOf(d.toMillis());
        }
        catch (DateTimeParseException e) {
            value = pattern;
        }
        return value;
    }

    private boolean isBlank(Object value) {
        if (value instanceof String) {
            return "".equals(value);
        }
        if (value instanceof Collection) {
            return ((Collection)value).isEmpty();
        }
        return value == null;
    }

    private boolean isComplexTypeOrDuration(ComponentModel.ComponentOptionModel option) {
        if (option.getJavaType().startsWith("java.util.Map") || option.getJavaType().startsWith("java.util.List") || option.getJavaType().startsWith("java.util.Set")) {
            return false;
        }
        return "object".equals(option.getType()) || "duration".equals(option.getType());
    }

    private boolean isComplexType(ComponentModel.ComponentOptionModel option) {
        if (option.getJavaType().startsWith("java.util.Map") || option.getJavaType().startsWith("java.util.List") || option.getJavaType().startsWith("java.util.Set")) {
            return false;
        }
        if (option.getEnums() != null && !option.getEnums().isEmpty()) {
            return false;
        }
        if ("java.lang.Object".equals(option.getJavaType())) {
            return false;
        }
        return "object".equals(option.getType());
    }

    private boolean isComplexType(DataFormatModel.DataFormatOptionModel option) {
        if (option.getJavaType().startsWith("java.util.Map") || option.getJavaType().startsWith("java.util.List") || option.getJavaType().startsWith("java.util.Set")) {
            return false;
        }
        if (option.getEnums() != null && !option.getEnums().isEmpty()) {
            return false;
        }
        return "object".equals(option.getType());
    }

    private boolean isComplexType(LanguageModel.LanguageOptionModel option) {
        if (option.getJavaType().startsWith("java.util.Map") || option.getJavaType().startsWith("java.util.List") || option.getJavaType().startsWith("java.util.Set")) {
            return false;
        }
        if (option.getEnums() != null && !option.getEnums().isEmpty()) {
            return false;
        }
        return "object".equals(option.getType());
    }

    private GenericType loadType(String type) throws MojoFailureException {
        try {
            return GenericType.parse((String)type, (ClassLoader)this.getProjectClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new MojoFailureException("Unable to load type", (Throwable)e);
        }
    }

    private Class<?> loadClass(String loadClassName) throws MojoFailureException {
        Class<?> optionClass;
        while (true) {
            try {
                optionClass = this.getProjectClassLoader().loadClass(loadClassName);
            }
            catch (ClassNotFoundException e) {
                int dotIndex = loadClassName.lastIndexOf(46);
                if (dotIndex == -1) {
                    throw new MojoFailureException(e.getMessage(), (Throwable)e);
                }
                loadClassName = loadClassName.substring(0, dotIndex) + "$" + loadClassName.substring(dotIndex + 1);
                continue;
            }
            break;
        }
        return optionClass;
    }

    protected DynamicClassLoader getProjectClassLoader() {
        if (this.projectClassLoader == null) {
            List classpathElements;
            try {
                classpathElements = this.project.getTestClasspathElements();
            }
            catch (DependencyResolutionRequiredException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            this.projectClassLoader = DynamicClassLoader.createDynamicClassLoader(classpathElements);
        }
        return this.projectClassLoader;
    }

    private String getSimpleJavaType(String type) {
        String wrapper = PRIMITIVEMAP.get(type);
        if (wrapper != null) {
            type = wrapper;
        }
        return type;
    }

    private JavaClass readJavaType(String type) {
        if (!(type.startsWith("java.lang.") || type.contains("<") && type.contains(">"))) {
            String sourceCode = "";
            try {
                Class<?> clazz = this.getProjectClassLoader().loadClass(type);
                URL url = clazz != null ? this.getProjectClassLoader().getResource(clazz.getName().replace('.', '/') + ".class") : null;
                Artifact mainDep = (Artifact)this.project.getArtifactMap().get(this.getMainDepGroupId() + ":" + this.getMainDepArtifactId());
                if (url == null || mainDep == null || !url.toString().contains(mainDep.getFile().toURI().toString())) {
                    return null;
                }
                JavaClass nestedType = new JavaClass((ClassLoader)this.getProjectClassLoader()).setPackage(clazz.getPackage().getName()).setName(clazz.getSimpleName()).setEnum(clazz.isEnum()).setClass(!clazz.isInterface()).setAbstract((clazz.getModifiers() & 0x400) != 0).setStatic((clazz.getModifiers() & 8) != 0).extendSuperType(clazz.getGenericSuperclass() != null ? new GenericType(clazz.getGenericSuperclass()).toString() : null);
                List publicMethods = Stream.of(clazz.getDeclaredMethods()).filter(m -> Modifier.isPublic(m.getModifiers())).collect(Collectors.toList());
                List allSetters = publicMethods.stream().filter(m -> m.getReturnType() == Void.TYPE || m.getReturnType() == clazz).filter(m -> m.getParameterCount() == 1).filter(m -> m.getName().matches("set[A-Z][a-zA-Z0-9]*")).collect(Collectors.toList());
                List allGetters = publicMethods.stream().filter(m -> m.getReturnType() != Void.TYPE).filter(m -> m.getParameterCount() == 0).filter(m -> m.getName().matches("(get|is)[A-Z][a-zA-Z0-9]*")).collect(Collectors.toList());
                allSetters.stream().sorted(Comparator.comparingInt(m -> this.getSetterPosition(sourceCode, (java.lang.reflect.Method)m)).thenComparing(java.lang.reflect.Method::getName)).map(m -> StringUtils.uncapitalize((String)m.getName().substring(3))).forEach(fn -> {
                    java.lang.reflect.Method accessor;
                    boolean isBoolean;
                    Type wft;
                    Class<?> ft;
                    java.lang.reflect.Method mutator;
                    Field field = Stream.of(clazz.getDeclaredFields()).filter(f -> f.getName().equals(fn)).findAny().orElse(null);
                    List setters = allSetters.stream().filter(m -> m.getName().equals("set" + StringUtils.capitalize((String)fn))).collect(Collectors.toList());
                    List getters = allGetters.stream().filter(m -> m.getName().equals("get" + StringUtils.capitalize((String)fn)) || m.getName().equals("is" + StringUtils.capitalize((String)fn))).collect(Collectors.toList());
                    if (setters.size() == 1) {
                        mutator = (java.lang.reflect.Method)setters.get(0);
                        ft = mutator.getParameterTypes()[0];
                        wft = PRIMITIVE_CLASSES.getOrDefault(ft, ft);
                        isBoolean = ft == Boolean.TYPE || ft == Boolean.class;
                        accessor = allGetters.stream().filter(m -> m.getName().equals("get" + StringUtils.capitalize((String)fn)) || isBoolean && m.getName().equals("is" + StringUtils.capitalize((String)fn))).filter(m -> PRIMITIVE_CLASSES.getOrDefault(m.getReturnType(), m.getReturnType()) == wft).findAny().orElse(null);
                    } else if (field != null) {
                        ft = field.getType();
                        wft = PRIMITIVE_CLASSES.getOrDefault(ft, ft);
                        isBoolean = ft == Boolean.TYPE || ft == Boolean.class;
                        mutator = allSetters.stream().filter(m -> m.getName().equals("set" + StringUtils.capitalize((String)fn))).filter(m -> PRIMITIVE_CLASSES.getOrDefault(m.getParameterTypes()[0], m.getParameterTypes()[0]) == wft).findAny().orElse(null);
                        accessor = allGetters.stream().filter(m -> m.getName().equals("get" + StringUtils.capitalize((String)fn)) || isBoolean && m.getName().equals("is" + StringUtils.capitalize((String)fn))).filter(m -> PRIMITIVE_CLASSES.getOrDefault(m.getReturnType(), m.getReturnType()) == wft).findAny().orElse(null);
                    } else {
                        if (getters.size() != 1) {
                            throw new IllegalStateException("Unable to determine type for property " + fn);
                        }
                        ft = ((java.lang.reflect.Method)getters.get(0)).getReturnType();
                        wft = PRIMITIVE_CLASSES.getOrDefault(ft, ft);
                        mutator = setters.stream().filter(m -> PRIMITIVE_CLASSES.getOrDefault(m.getParameterTypes()[0], m.getParameterTypes()[0]) == wft).findAny().orElse(null);
                        accessor = getters.stream().filter(m -> PRIMITIVE_CLASSES.getOrDefault(m.getReturnType(), m.getReturnType()) == wft).findAny().orElse(null);
                    }
                    if (mutator == null) {
                        throw new IllegalStateException("Could not find mutator for property " + fn);
                    }
                    Property property = nestedType.addProperty(new GenericType(wft), fn);
                    property.getMutator().getJavaDoc().setText(this.getSetterJavaDoc(sourceCode, (String)fn));
                    for (java.lang.annotation.Annotation ann : mutator.getAnnotations()) {
                        this.addAnnotation(ac -> property.getMutator().addAnnotation(ac), ann);
                    }
                    if (accessor != null) {
                        for (java.lang.annotation.Annotation ann : accessor.getAnnotations()) {
                            this.addAnnotation(ac -> property.getAccessor().addAnnotation(ac), ann);
                        }
                    } else {
                        property.removeAccessor();
                    }
                    if (field != null) {
                        for (java.lang.annotation.Annotation ann : field.getAnnotations()) {
                            this.addAnnotation(ac -> property.getField().addAnnotation(ac), ann);
                        }
                    } else {
                        property.removeField();
                    }
                });
                return nestedType;
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        return null;
    }

    private int getSetterPosition(String sourceCode, java.lang.reflect.Method m) {
        int i0 = sourceCode.indexOf("void " + m.getName() + "(");
        int i1 = sourceCode.indexOf(m.getDeclaringClass().getSimpleName() + " " + m.getName() + "(");
        int l = sourceCode.length();
        return Math.min(i0 > 0 ? i0 : l, i1 > 0 ? i1 : l);
    }

    private String getSetterJavaDoc(String sourceCode, String name) {
        int idx = sourceCode.indexOf("public void set" + StringUtils.capitalize((String)name) + "(");
        if (idx > 0 && (idx = (sourceCode = sourceCode.substring(0, idx)).lastIndexOf("/**")) > 0 && (idx = (sourceCode = sourceCode.substring(idx + 3)).indexOf("*/")) > 0) {
            int lastLine;
            sourceCode = sourceCode.substring(0, idx);
            List lines = Stream.of(sourceCode.split("\n")).map(String::trim).map(s -> s.startsWith("*") ? s.substring(1) : s).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
            for (lastLine = 0; lastLine < lines.size() && !((String)lines.get(lastLine)).startsWith("@"); ++lastLine) {
            }
            sourceCode = lines.subList(0, lastLine).stream().map(s -> s.replaceAll("  ", " ")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.joining(" "));
            return sourceCode;
        }
        return null;
    }

    private void addAnnotation(Function<Class<? extends java.lang.annotation.Annotation>, Annotation> creator, java.lang.annotation.Annotation ann) {
        Class<? extends java.lang.annotation.Annotation> ac = ann.annotationType();
        Annotation a = creator.apply(ac);
        for (java.lang.reflect.Method m : ac.getMethods()) {
            if ("equals".equals(m.getName()) || "toString".equals(m.getName()) || "hashCode".equals(m.getName())) continue;
            String n = m.getName();
            try {
                Object v = m.invoke((Object)ann, new Object[0]);
                if (v == null) continue;
                a.setLiteralValue(n, v.toString());
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to retrieve annotation value " + n + " on " + ac.getName());
            }
        }
    }

    private static boolean skipComponentOption(ComponentModel model, ComponentModel.ComponentOptionModel option) {
        String name;
        return "netty-http".equals(model.getScheme()) && ((name = option.getName()).equals("textline") || name.equals("delimiter") || name.equals("autoAppendDelimiter") || name.equals("decoderMaxLineLength") || name.equals("encoding") || name.equals("allowDefaultCodec") || name.equals("udpConnectionlessSending") || name.equals("networkInterface") || name.equals("clientMode") || name.equals("reconnect") || name.equals("reconnectInterval") || name.equals("useByteBuf") || name.equals("udpByteArrayCodec") || name.equals("broadcast"));
    }

    private void createDataFormatConfigurationSource(String packageName, DataFormatModel model, String overrideDataFormatName) throws MojoFailureException {
        JavaClass javaClass = new JavaClass((ClassLoader)this.getProjectClassLoader());
        int pos = model.getJavaType().lastIndexOf(".");
        String name = model.getJavaType().substring(pos + 1);
        name = name.replace("DataFormat", "DataFormatConfiguration");
        javaClass.setPackage(packageName).setName(name);
        javaClass.extendSuperType("DataFormatConfigurationPropertiesCommon");
        javaClass.addImport("org.apache.camel.spring.boot.DataFormatConfigurationPropertiesCommon");
        Property bogus = javaClass.addProperty("java.lang.Boolean", "enabled");
        bogus.getField().getJavaDoc().setText("Whether to enable auto configuration of the " + model.getName() + " data format. This is enabled by default.");
        bogus.removeAccessor();
        bogus.removeMutator();
        String doc = "Generated by camel-package-maven-plugin - do not edit this file!";
        if (!Strings.isNullOrEmpty((String)model.getDescription())) {
            doc = model.getDescription() + "\n\n" + doc;
        }
        javaClass.getJavaDoc().setFullText(doc);
        String prefix = "camel.dataformat." + (overrideDataFormatName != null ? overrideDataFormatName : model.getName());
        prefix = prefix.toLowerCase(Locale.US);
        javaClass.addAnnotation(Generated.class).setStringValue("value", SpringBootAutoConfigurationMojo.class.getName());
        javaClass.addAnnotation("org.springframework.boot.context.properties.ConfigurationProperties").setStringValue("prefix", prefix);
        for (DataFormatModel.DataFormatOptionModel option : model.getOptions()) {
            boolean complex;
            if ("id".equals(option.getName())) continue;
            Object defaultValue = option.getDefaultValue();
            String type = option.getJavaType();
            type = this.getSimpleJavaType(type);
            if ("org.apache.camel.model.dataformat.BindyType".equals(option.getJavaType())) {
                type = "java.lang.String";
                defaultValue = null;
            } else if (option.getJavaType().contains("org.apache.camel.model.dataformat")) continue;
            boolean bl = complex = this.isComplexType(option) && this.isBlank(option.getEnums());
            if (complex) {
                type = "java.lang.String";
            }
            Property prop = javaClass.addProperty(type, option.getName());
            if (option.isDeprecated()) {
                prop.getField().addAnnotation(Deprecated.class);
                prop.getAccessor().addAnnotation(Deprecated.class);
                prop.getMutator().addAnnotation(Deprecated.class);
                prop.getAccessor().addAnnotation(DeprecatedConfigurationProperty.class);
            }
            if (!Strings.isNullOrEmpty((String)option.getDescription())) {
                String desc = option.getDescription();
                if (complex) {
                    if (!desc.endsWith(".")) {
                        desc = desc + ".";
                    }
                    desc = desc + " The option is a " + option.getJavaType() + " type.";
                }
                prop.getField().getJavaDoc().setFullText(desc);
            }
            if (this.isBlank(defaultValue)) continue;
            if ("java.lang.String".equals(option.getJavaType())) {
                prop.getField().setStringInitializer(defaultValue.toString());
                continue;
            }
            if ("long".equals(option.getJavaType()) || "java.lang.Long".equals(option.getJavaType())) {
                String value = defaultValue + "L";
                prop.getField().setLiteralInitializer(value);
                continue;
            }
            if ("integer".equals(option.getType()) || "java.lang.Integer".equals(option.getJavaType()) || "boolean".equals(option.getType()) || "java.lang.Boolean".equals(option.getJavaType())) {
                prop.getField().setLiteralInitializer(defaultValue.toString());
                continue;
            }
            if (this.isBlank(option.getEnums())) continue;
            String enumShortName = type.substring(type.lastIndexOf(".") + 1);
            prop.getField().setLiteralInitializer(enumShortName + "." + defaultValue);
            javaClass.addImport(model.getJavaType());
        }
        String fileName = packageName.replaceAll("\\.", "\\/") + "/" + name + ".java";
        this.writeSourceIfChanged(javaClass, fileName, true);
    }

    private void createLanguageConfigurationSource(String packageName, LanguageModel model, String overrideLanguageName) throws MojoFailureException {
        JavaClass javaClass = new JavaClass((ClassLoader)this.getProjectClassLoader());
        int pos = model.getJavaType().lastIndexOf(".");
        String name = model.getJavaType().substring(pos + 1);
        name = name.replace("Language", "LanguageConfiguration");
        javaClass.setPackage(packageName).setName(name);
        javaClass.extendSuperType("LanguageConfigurationPropertiesCommon");
        javaClass.addImport("org.apache.camel.spring.boot.LanguageConfigurationPropertiesCommon");
        Property bogus = javaClass.addProperty("java.lang.Boolean", "enabled");
        bogus.getField().getJavaDoc().setText("Whether to enable auto configuration of the " + model.getName() + " language. This is enabled by default.");
        bogus.removeAccessor();
        bogus.removeMutator();
        String doc = "Generated by camel-package-maven-plugin - do not edit this file!";
        if (!Strings.isNullOrEmpty((String)model.getDescription())) {
            doc = model.getDescription() + "\n\n" + doc;
        }
        javaClass.getJavaDoc().setFullText(doc);
        String prefix = "camel.language." + (overrideLanguageName != null ? overrideLanguageName : model.getName());
        prefix = prefix.toLowerCase(Locale.US);
        javaClass.addAnnotation(Generated.class).setStringValue("value", SpringBootAutoConfigurationMojo.class.getName());
        javaClass.addAnnotation("org.springframework.boot.context.properties.ConfigurationProperties").setStringValue("prefix", prefix);
        for (LanguageModel.LanguageOptionModel option : model.getOptions()) {
            boolean complex;
            if ("id".equals(option.getName()) || "expression".equals(option.getName()) || "resultType".equals(option.getName()) || ("bean".equals(model.getName()) ? "bean".equals(option.getName()) || "ref".equals(option.getName()) || "method".equals(option.getName()) || "beanType".equals(option.getName()) : ("tokenize".equals(model.getName()) ? "token".equals(option.getName()) || "endToken".equals(option.getName()) || "inheritNamespaceTagName".equals(option.getName()) || "headerName".equals(option.getName()) || "regex".equals(option.getName()) || "xml".equals(option.getName()) || "includeTokens".equals(option.getName()) || "group".equals(option.getName()) || "skipFirst".equals(option.getName()) : ("xtokenize".equals(model.getName()) ? "headerName".equals(option.getName()) || "group".equals(option.getName()) : ("xpath".equals(model.getName()) ? "headerName".equals(option.getName()) : "xquery".equals(model.getName()) && "headerName".equals(option.getName())))))) continue;
            String type = option.getJavaType();
            type = this.getSimpleJavaType(type);
            boolean bl = complex = this.isComplexType(option) && this.isBlank(option.getEnums());
            if (complex) {
                type = "java.lang.String";
            }
            Property prop = javaClass.addProperty(type, option.getName());
            if (option.isDeprecated()) {
                prop.getField().addAnnotation(Deprecated.class);
                prop.getAccessor().addAnnotation(Deprecated.class);
                prop.getMutator().addAnnotation(Deprecated.class);
                prop.getAccessor().addAnnotation(DeprecatedConfigurationProperty.class);
            }
            if (!Strings.isNullOrEmpty((String)option.getDescription())) {
                String desc = option.getDescription();
                if (complex) {
                    if (!desc.endsWith(".")) {
                        desc = desc + ".";
                    }
                    desc = desc + " The option is a " + option.getJavaType() + " type.";
                }
                prop.getField().getJavaDoc().setFullText(desc);
            }
            if (this.isBlank(option.getDefaultValue())) continue;
            if ("java.lang.String".equals(option.getJavaType())) {
                prop.getField().setStringInitializer(option.getDefaultValue().toString());
                continue;
            }
            if ("long".equals(option.getJavaType()) || "java.lang.Long".equals(option.getJavaType())) {
                String value = option.getDefaultValue() + "L";
                prop.getField().setLiteralInitializer(value);
                continue;
            }
            if ("integer".equals(option.getType()) || "java.lang.Integer".equals(option.getJavaType()) || "boolean".equals(option.getType()) || "java.lang.Boolean".equals(option.getJavaType())) {
                prop.getField().setLiteralInitializer(option.getDefaultValue().toString());
                continue;
            }
            if (!this.isBlank(option.getEnums())) continue;
            String enumShortName = type.substring(type.lastIndexOf(".") + 1);
            prop.getField().setLiteralInitializer(enumShortName + "." + option.getDefaultValue());
            javaClass.addImport(model.getJavaType());
        }
        String fileName = packageName.replaceAll("\\.", "\\/") + "/" + name + ".java";
        this.writeSourceIfChanged(javaClass, fileName, true);
    }

    private Class<?> generateDummyClass(String clazzName) {
        return this.getProjectClassLoader().generateDummyClass(clazzName);
    }

    private void createComponentAutoConfigurationSource(String packageName, ComponentModel model, String overrideName, boolean complexOptions) throws MojoFailureException {
        String name = model.getJavaType().substring(model.getJavaType().lastIndexOf(".") + 1).replace("Component", "ComponentAutoConfiguration");
        String configurationName = name.replace("ComponentAutoConfiguration", "ComponentConfiguration");
        String componentName = (overrideName != null ? overrideName : model.getScheme()).toLowerCase(Locale.US);
        Class<?> configClass = this.generateDummyClass(packageName + "." + configurationName);
        JavaClass javaClass = new JavaClass((ClassLoader)this.getProjectClassLoader());
        javaClass.setPackage(packageName);
        javaClass.setName(name);
        javaClass.getJavaDoc().setFullText("Generated by camel-package-maven-plugin - do not edit this file!");
        javaClass.addAnnotation(Generated.class).setStringValue("value", SpringBootAutoConfigurationMojo.class.getName());
        javaClass.addAnnotation(Configuration.class).setLiteralValue("proxyBeanMethods", "false");
        javaClass.addAnnotation(Conditional.class).setLiteralValue("ConditionalOnCamelContextAndAutoConfigurationBeans.class");
        javaClass.addAnnotation(EnableConfigurationProperties.class).setLiteralValue("{ComponentConfigurationProperties.class," + configurationName + ".class}");
        javaClass.addAnnotation("org.apache.camel.spring.boot.util.ConditionalOnHierarchicalProperties").setStringArrayValue("value", new String[]{"camel.component", "camel.component." + componentName});
        if (complexOptions) {
            String cn = name.replace("ComponentAutoConfiguration", "ComponentConverter");
            javaClass.addAnnotation(AutoConfigureAfter.class).setLiteralValue("{CamelAutoConfiguration.class, " + cn + ".class}");
        } else {
            javaClass.addAnnotation(AutoConfigureAfter.class).setLiteralValue("CamelAutoConfiguration.class");
        }
        javaClass.addImport(ApplicationContext.class);
        javaClass.addImport("org.apache.camel.CamelContext");
        javaClass.addImport("org.apache.camel.Component");
        javaClass.addImport("org.apache.camel.spi.ComponentCustomizer");
        javaClass.addImport("org.apache.camel.spring.boot.CamelAutoConfiguration");
        javaClass.addImport("org.apache.camel.spring.boot.ComponentConfigurationProperties");
        javaClass.addImport("org.apache.camel.spring.boot.util.CamelPropertiesHelper");
        javaClass.addImport("org.apache.camel.spring.boot.util.ConditionalOnCamelContextAndAutoConfigurationBeans");
        javaClass.addImport("org.apache.camel.spring.boot.util.HierarchicalPropertiesEvaluator");
        javaClass.addImport(model.getJavaType());
        javaClass.addField().setPrivate().setName("applicationContext").setType(ApplicationContext.class).addAnnotation(Autowired.class);
        javaClass.addField().setPrivate().setFinal(true).setName("camelContext").setType(this.loadClass("org.apache.camel.CamelContext"));
        javaClass.addField().setPrivate().setName("configuration").setType(configClass).addAnnotation(Autowired.class);
        Method ctr = javaClass.addMethod().setConstructor(true).setPublic().setName(name).addParameter("org.apache.camel.CamelContext", "camelContext");
        ctr.setBody("this.camelContext = camelContext;\n");
        String body = SpringBootAutoConfigurationMojo.createComponentBody(model.getShortJavaType(), componentName);
        String methodName = "configure" + model.getShortJavaType();
        Method method = javaClass.addMethod().setName(methodName).setPublic().setBody(body).setReturnType(this.loadType("org.apache.camel.spi.ComponentCustomizer"));
        method.addAnnotation(Lazy.class);
        method.addAnnotation(Bean.class);
        SpringBootAutoConfigurationMojo.sortImports(javaClass);
        String fileName = packageName.replaceAll("\\.", "\\/") + "/" + name + ".java";
        this.writeSourceIfChanged(javaClass, fileName, false);
    }

    private void createComponentConverterSource(String packageName, ComponentModel model) throws MojoFailureException {
        String name = model.getJavaType().substring(model.getJavaType().lastIndexOf(".") + 1).replace("Component", "ComponentConverter");
        JavaClass javaClass = new JavaClass((ClassLoader)this.getProjectClassLoader());
        javaClass.setPackage(packageName);
        javaClass.setName(name);
        javaClass.getJavaDoc().setFullText("Generated by camel-package-maven-plugin - do not edit this file!");
        javaClass.addAnnotation(Generated.class).setStringValue("value", SpringBootAutoConfigurationMojo.class.getName());
        javaClass.addAnnotation(Configuration.class).setLiteralValue("proxyBeanMethods", "false");
        javaClass.addAnnotation("org.springframework.boot.context.properties.ConfigurationPropertiesBinding");
        javaClass.addAnnotation("org.springframework.stereotype.Component");
        javaClass.addImport("java.util.LinkedHashSet");
        javaClass.addImport("java.util.Set");
        javaClass.addImport("org.springframework.core.convert.TypeDescriptor");
        javaClass.addImport("org.springframework.core.convert.converter.GenericConverter");
        javaClass.implementInterface("GenericConverter");
        javaClass.addField().setPrivate().setName("applicationContext").setType(this.loadClass("org.springframework.context.ApplicationContext")).addAnnotation(Autowired.class);
        String body = this.createConverterPairBody(model);
        javaClass.addMethod().setName("getConvertibleTypes").setPublic().setReturnType("Set<ConvertiblePair>").setBody(body);
        body = this.createConvertBody(model);
        javaClass.addMethod().setName("convert").setPublic().setReturnType("Object").addParameter("Object", "source").addParameter("TypeDescriptor", "sourceType").addParameter("TypeDescriptor", "targetType").setBody(body);
        SpringBootAutoConfigurationMojo.sortImports(javaClass);
        String fileName = packageName.replaceAll("\\.", "\\/") + "/" + name + ".java";
        this.writeSourceIfChanged(javaClass, fileName, false);
        this.writeComponentSpringFactorySource(packageName, name);
    }

    private String createConvertBody(ComponentModel model) {
        StringBuilder sb = new StringBuilder();
        sb.append("if (source == null) {\n");
        sb.append("    return null;\n");
        sb.append("}\n");
        sb.append("String ref = source.toString();\n");
        sb.append("if (!ref.startsWith(\"#\")) {\n");
        sb.append("    return null;\n");
        sb.append("}\n");
        sb.append("ref = ref.startsWith(\"#bean:\") ? ref.substring(6) : ref.substring(1);\n");
        sb.append("switch (targetType.getName()) {\n");
        Stream<String> s = model.getComponentOptions().stream().filter(this::isComplexType).map(SpringBootAutoConfigurationMojo::getJavaType).distinct();
        s.forEach(type -> sb.append("    case \"").append((String)type).append("\": return applicationContext.getBean(ref, ").append((String)type).append(".class);\n"));
        sb.append("}\n");
        sb.append("return null;\n");
        return sb.toString();
    }

    private String createConvertBody(DataFormatModel model) {
        StringBuilder sb = new StringBuilder();
        sb.append("if (source == null) {\n");
        sb.append("    return null;\n");
        sb.append("}\n");
        sb.append("String ref = source.toString();\n");
        sb.append("if (!ref.startsWith(\"#\")) {\n");
        sb.append("    return null;\n");
        sb.append("}\n");
        sb.append("ref = ref.startsWith(\"#bean:\") ? ref.substring(6) : ref.substring(1);\n");
        sb.append("switch (targetType.getName()) {\n");
        Stream<String> s = model.getOptions().stream().filter(this::isComplexType).map(SpringBootAutoConfigurationMojo::getJavaType).distinct();
        s.forEach(type -> sb.append("    case \"").append((String)type).append("\": return applicationContext.getBean(ref, ").append((String)type).append(".class);\n"));
        sb.append("}\n");
        sb.append("return null;\n");
        return sb.toString();
    }

    private String createConvertBody(LanguageModel model) {
        StringBuilder sb = new StringBuilder();
        sb.append("if (source == null) {\n");
        sb.append("    return null;\n");
        sb.append("}\n");
        sb.append("String ref = source.toString();\n");
        sb.append("if (!ref.startsWith(\"#\")) {\n");
        sb.append("    return null;\n");
        sb.append("}\n");
        sb.append("ref = ref.startsWith(\"#bean:\") ? ref.substring(6) : ref.substring(1);\n");
        sb.append("switch (targetType.getName()) {\n");
        Stream<String> s = model.getOptions().stream().filter(this::isComplexType).map(SpringBootAutoConfigurationMojo::getJavaType).distinct();
        s.forEach(type -> sb.append("    case \"").append((String)type).append("\": return applicationContext.getBean(ref, ").append((String)type).append(".class);\n"));
        sb.append("}\n");
        sb.append("return null;\n");
        return sb.toString();
    }

    private String createConverterPairBody(ComponentModel model) {
        StringBuilder sb = new StringBuilder();
        sb.append("Set<ConvertiblePair> answer = new LinkedHashSet<>();\n");
        Stream<String> s = model.getOptions().stream().filter(this::isComplexType).map(SpringBootAutoConfigurationMojo::getJavaType).distinct();
        s.forEach(type -> {
            sb.append("answer.add(new ConvertiblePair(String.class, ");
            sb.append((String)type);
            sb.append(".class));\n");
        });
        sb.append("return answer;\n");
        return sb.toString();
    }

    private String createConverterPairBody(DataFormatModel model) {
        StringBuilder sb = new StringBuilder();
        sb.append("Set<ConvertiblePair> answer = new LinkedHashSet<>();\n");
        Stream<String> s = model.getOptions().stream().filter(this::isComplexType).map(SpringBootAutoConfigurationMojo::getJavaType).distinct();
        s.forEach(type -> {
            sb.append("answer.add(new ConvertiblePair(String.class, ");
            sb.append((String)type);
            sb.append(".class));\n");
        });
        sb.append("return answer;\n");
        return sb.toString();
    }

    private String createConverterPairBody(LanguageModel model) {
        StringBuilder sb = new StringBuilder();
        sb.append("Set<ConvertiblePair> answer = new LinkedHashSet<>();\n");
        Stream<String> s = model.getOptions().stream().filter(this::isComplexType).map(SpringBootAutoConfigurationMojo::getJavaType).distinct();
        s.forEach(type -> {
            sb.append("answer.add(new ConvertiblePair(String.class, ");
            sb.append((String)type);
            sb.append(".class));\n");
        });
        sb.append("return answer;\n");
        return sb.toString();
    }

    private void createDataFormatAutoConfigurationSource(String packageName, DataFormatModel model, String overrideName, boolean complexOptions) throws MojoFailureException {
        String name = model.getJavaType().substring(model.getJavaType().lastIndexOf(".") + 1).replace("DataFormat", "DataFormatAutoConfiguration");
        String configurationName = name.replace("DataFormatAutoConfiguration", "DataFormatConfiguration");
        String dataformatName = (overrideName != null ? overrideName : model.getName()).toLowerCase(Locale.US);
        Class<?> configClass = this.generateDummyClass(packageName + "." + configurationName);
        JavaClass javaClass = new JavaClass((ClassLoader)this.getProjectClassLoader());
        javaClass.setPackage(packageName);
        javaClass.setName(name);
        javaClass.getJavaDoc().setFullText("Generated by camel-package-maven-plugin - do not edit this file!");
        javaClass.addAnnotation(Generated.class).setStringValue("value", SpringBootAutoConfigurationMojo.class.getName());
        javaClass.addAnnotation(Configuration.class).setLiteralValue("proxyBeanMethods", "false");
        javaClass.addAnnotation(AutoConfigureAfter.class).setLiteralValue("CamelAutoConfiguration.class");
        javaClass.addAnnotation(Conditional.class).setLiteralValue("ConditionalOnCamelContextAndAutoConfigurationBeans.class");
        javaClass.addAnnotation(EnableConfigurationProperties.class).setLiteralValue("{DataFormatConfigurationProperties.class," + configurationName + ".class}");
        javaClass.addAnnotation("org.apache.camel.spring.boot.util.ConditionalOnHierarchicalProperties").setStringArrayValue("value", new String[]{"camel.dataformat", "camel.dataformat." + dataformatName});
        javaClass.addImport(ApplicationContext.class);
        javaClass.addImport("org.springframework.boot.convert.ApplicationConversionService");
        javaClass.addImport("org.apache.camel.CamelContext");
        javaClass.addImport("org.apache.camel.spring.boot.CamelAutoConfiguration");
        javaClass.addImport("org.apache.camel.spring.boot.DataFormatConfigurationProperties");
        javaClass.addImport("org.apache.camel.spring.boot.util.CamelPropertiesHelper");
        javaClass.addImport("org.apache.camel.spring.boot.util.ConditionalOnCamelContextAndAutoConfigurationBeans");
        javaClass.addImport("org.apache.camel.spring.boot.util.HierarchicalPropertiesEvaluator");
        javaClass.addImport("org.apache.camel.spi.DataFormat");
        javaClass.addImport("org.apache.camel.spi.DataFormatCustomizer");
        javaClass.addImport(model.getJavaType());
        javaClass.addField().setPrivate().setName("applicationContext").setType(ApplicationContext.class).addAnnotation(Autowired.class);
        javaClass.addField().setPrivate().setFinal(true).setName("camelContext").setType(this.loadClass("org.apache.camel.CamelContext"));
        javaClass.addField().setPrivate().setName("configuration").setType(configClass).addAnnotation(Autowired.class);
        Method ctr = javaClass.addMethod().setConstructor(true).setPublic().setName(name).addParameter("org.apache.camel.CamelContext", "camelContext");
        ctr.setBody("this.camelContext = camelContext;\n");
        String body = SpringBootAutoConfigurationMojo.createDataFormatBody(model.getShortJavaType(), dataformatName);
        String methodName = "configure" + model.getShortJavaType() + "Factory";
        Method method = javaClass.addMethod().setName(methodName).setPublic().setBody(body).setReturnType(this.loadType("org.apache.camel.spi.DataFormatCustomizer"));
        method.addAnnotation(Lazy.class);
        method.addAnnotation(Bean.class);
        SpringBootAutoConfigurationMojo.sortImports(javaClass);
        String fileName = packageName.replaceAll("\\.", "\\/") + "/" + name + ".java";
        this.writeSourceIfChanged(javaClass, fileName, false);
    }

    private void createDataFormatConverterSource(String packageName, DataFormatModel model) throws MojoFailureException {
        String name = model.getJavaType().substring(model.getJavaType().lastIndexOf(".") + 1).replace("DataFormat", "DataFormatConverter");
        JavaClass javaClass = new JavaClass((ClassLoader)this.getProjectClassLoader());
        javaClass.setPackage(packageName);
        javaClass.setName(name);
        javaClass.getJavaDoc().setFullText("Generated by camel-package-maven-plugin - do not edit this file!");
        javaClass.addAnnotation(Generated.class).setStringValue("value", SpringBootAutoConfigurationMojo.class.getName());
        javaClass.addImport("java.util.LinkedHashSet");
        javaClass.addImport("java.util.Set");
        javaClass.addImport("org.apache.camel.CamelContext");
        javaClass.addImport("org.springframework.core.convert.TypeDescriptor");
        javaClass.addImport("org.springframework.core.convert.converter.GenericConverter");
        javaClass.implementInterface("org.springframework.core.convert.converter.GenericConverter");
        javaClass.addField().setPrivate().setFinal(true).setName("camelContext").setType(this.loadClass("org.apache.camel.CamelContext"));
        javaClass.addMethod().setConstructor(true).setPublic().setPublic().setName(name).addParameter("org.apache.camel.CamelContext", "camelContext").setBody("this.camelContext = camelContext;\n");
        String body = this.createConverterPairBody(model);
        javaClass.addMethod().setName("getConvertibleTypes").setPublic().setReturnType("Set<ConvertiblePair>").setBody(body);
        body = this.createConvertBody(model);
        javaClass.addMethod().setName("convert").setPublic().setReturnType("Object").addParameter("Object", "source").addParameter("TypeDescriptor", "sourceType").addParameter("TypeDescriptor", "targetType").setBody(body);
        SpringBootAutoConfigurationMojo.sortImports(javaClass);
        String fileName = packageName.replaceAll("\\.", "\\/") + "/" + name + ".java";
        this.writeSourceIfChanged(javaClass, fileName, false);
    }

    private void createLanguageAutoConfigurationSource(String packageName, LanguageModel model, String overrideName, boolean complexOptions) throws MojoFailureException {
        String name = model.getJavaType().substring(model.getJavaType().lastIndexOf(".") + 1).replace("Language", "LanguageAutoConfiguration");
        String configurationName = name.replace("LanguageAutoConfiguration", "LanguageConfiguration");
        String languageName = (overrideName != null ? overrideName : model.getName()).toLowerCase(Locale.US);
        Class<?> configClass = this.generateDummyClass(packageName + "." + configurationName);
        JavaClass javaClass = new JavaClass((ClassLoader)this.getProjectClassLoader());
        javaClass.setPackage(packageName);
        javaClass.setName(name);
        javaClass.getJavaDoc().setFullText("Generated by camel-package-maven-plugin - do not edit this file!");
        javaClass.addAnnotation(Generated.class).setStringValue("value", SpringBootAutoConfigurationMojo.class.getName());
        javaClass.addAnnotation(Configuration.class).setLiteralValue("proxyBeanMethods", "false");
        javaClass.addAnnotation(AutoConfigureAfter.class).setLiteralValue("CamelAutoConfiguration.class");
        javaClass.addAnnotation(Conditional.class).setLiteralValue("ConditionalOnCamelContextAndAutoConfigurationBeans.class");
        javaClass.addAnnotation(EnableConfigurationProperties.class).setLiteralValue("{LanguageConfigurationProperties.class," + configurationName + ".class}");
        javaClass.addAnnotation("org.apache.camel.spring.boot.util.ConditionalOnHierarchicalProperties").setStringArrayValue("value", new String[]{"camel.language", "camel.language." + languageName});
        javaClass.addImport(ApplicationContext.class);
        javaClass.addImport("org.springframework.boot.convert.ApplicationConversionService");
        javaClass.addImport("org.apache.camel.CamelContext");
        javaClass.addImport("org.apache.camel.spring.boot.CamelAutoConfiguration");
        javaClass.addImport("org.apache.camel.spring.boot.LanguageConfigurationProperties");
        javaClass.addImport("org.apache.camel.spring.boot.util.CamelPropertiesHelper");
        javaClass.addImport("org.apache.camel.spring.boot.util.ConditionalOnCamelContextAndAutoConfigurationBeans");
        javaClass.addImport("org.apache.camel.spring.boot.util.HierarchicalPropertiesEvaluator");
        javaClass.addImport("org.apache.camel.spi.Language");
        javaClass.addImport("org.apache.camel.spi.LanguageCustomizer");
        javaClass.addImport(model.getJavaType());
        javaClass.addField().setPrivate().setName("applicationContext").setType(ApplicationContext.class).addAnnotation(Autowired.class);
        javaClass.addField().setPrivate().setFinal(true).setName("camelContext").setType(this.loadClass("org.apache.camel.CamelContext"));
        javaClass.addField().setPrivate().setName("configuration").setType(configClass).addAnnotation(Autowired.class);
        Method ctr = javaClass.addMethod().setConstructor(true).setPublic().setName(name).addParameter("org.apache.camel.CamelContext", "camelContext");
        ctr.setBody("this.camelContext = camelContext;\n");
        String body = SpringBootAutoConfigurationMojo.createLanguageBody(model.getShortJavaType(), languageName);
        String methodName = "configure" + model.getShortJavaType();
        Method method = javaClass.addMethod().setName(methodName).setPublic().setBody(body).setReturnType("org.apache.camel.spi.LanguageCustomizer");
        method.addAnnotation(Lazy.class);
        method.addAnnotation(Bean.class);
        String fileName = packageName.replaceAll("\\.", "\\/") + "/" + name + ".java";
        this.writeSourceIfChanged(javaClass, fileName, false);
    }

    private void createComponentSpringFactorySource(String packageName, ComponentModel model) throws MojoFailureException {
        int pos = model.getJavaType().lastIndexOf(".");
        String name = model.getJavaType().substring(pos + 1);
        name = name.replace("Component", "ComponentAutoConfiguration");
        this.writeComponentSpringFactorySource(packageName, name);
    }

    private void createLanguageConverterSource(String packageName, LanguageModel model) throws MojoFailureException {
        String name = model.getJavaType().substring(model.getJavaType().lastIndexOf(".") + 1).replace("Language", "LanguageConverter");
        JavaClass javaClass = new JavaClass((ClassLoader)this.getProjectClassLoader());
        javaClass.setPackage(packageName);
        javaClass.setName(name);
        javaClass.getJavaDoc().setFullText("Generated by camel-package-maven-plugin - do not edit this file!");
        javaClass.addAnnotation(Generated.class).setStringValue("value", SpringBootAutoConfigurationMojo.class.getName());
        javaClass.addImport("java.util.LinkedHashSet");
        javaClass.addImport("java.util.Set");
        javaClass.addImport("org.apache.camel.CamelContext");
        javaClass.addImport("org.springframework.core.convert.TypeDescriptor");
        javaClass.addImport("org.springframework.core.convert.converter.GenericConverter");
        javaClass.implementInterface("org.springframework.core.convert.converter.GenericConverter");
        javaClass.addField().setPrivate().setFinal(true).setName("camelContext").setType(this.loadClass("org.apache.camel.CamelContext"));
        javaClass.addMethod().setConstructor(true).setPublic().setName(name).addParameter("org.apache.camel.CamelContext", "camelContext").setBody("this.camelContext = camelContext;\n");
        String body = this.createConverterPairBody(model);
        javaClass.addMethod().setName("getConvertibleTypes").setPublic().setReturnType("Set<ConvertiblePair>").setBody(body);
        body = this.createConvertBody(model);
        javaClass.addMethod().setName("convert").setPublic().setReturnType("Object").addParameter("Object", "source").addParameter("TypeDescriptor", "sourceType").addParameter("TypeDescriptor", "targetType").setBody(body);
        SpringBootAutoConfigurationMojo.sortImports(javaClass);
        String fileName = packageName.replaceAll("\\.", "\\/") + "/" + name + ".java";
        this.writeSourceIfChanged(javaClass, fileName, false);
    }

    private void createDataFormatSpringFactorySource(String packageName, DataFormatModel model) throws MojoFailureException {
        int pos = model.getJavaType().lastIndexOf(".");
        String name = model.getJavaType().substring(pos + 1);
        name = name.replace("DataFormat", "DataFormatAutoConfiguration");
        this.writeComponentSpringFactorySource(packageName, name);
    }

    private void createLanguageSpringFactorySource(String packageName, LanguageModel model) throws MojoFailureException {
        int pos = model.getJavaType().lastIndexOf(".");
        String name = model.getJavaType().substring(pos + 1);
        name = name.replace("Language", "LanguageAutoConfiguration");
        this.writeComponentSpringFactorySource(packageName, name);
    }

    private static String createComponentBody(String shortJavaType, String name) {
        return "return new ComponentCustomizer() {\n" + "    @Override\n" + "    public void configure(String name, Component target) {\n" + "        CamelPropertiesHelper.copyProperties(camelContext, configuration, target);\n" + "    }\n" + "    @Override\n" + "    public boolean isEnabled(String name, Component target) {\n" + "        return HierarchicalPropertiesEvaluator.evaluate(\n" + "                applicationContext,\n" + "                \"camel.component.customizer\",\n" + "                \"camel.component." + name + ".customizer\")\n" + "            && target instanceof " + shortJavaType + ";\n" + "    }\n" + "};\n";
    }

    private static String createDataFormatBody(String shortJavaType, String name) {
        return "return new DataFormatCustomizer() {\n" + "    @Override\n" + "    public void configure(String name, DataFormat target) {\n" + "        CamelPropertiesHelper.copyProperties(camelContext, configuration, target);\n" + "    }\n" + "    @Override\n" + "    public boolean isEnabled(String name, DataFormat target) {\n" + "        return HierarchicalPropertiesEvaluator.evaluate(\n" + "                applicationContext,\n" + "                \"camel.dataformat.customizer\",\n" + "                \"camel.dataformat." + name + ".customizer\")\n" + "            && target instanceof " + shortJavaType + ";\n" + "    }\n" + "};\n";
    }

    private static String createLanguageBody(String shortJavaType, String name) {
        return "return new LanguageCustomizer() {\n" + "    @Override\n" + "    public void configure(String name, Language target) {\n" + "        CamelPropertiesHelper.copyProperties(camelContext, configuration, target);\n" + "    }\n" + "    @Override\n" + "    public boolean isEnabled(String name, Language target) {\n" + "        return HierarchicalPropertiesEvaluator.evaluate(\n" + "                applicationContext,\n" + "                \"camel.language.customizer\",\n" + "                \"camel.language." + name + ".customizer\")\n" + "            && target instanceof " + shortJavaType + ";\n" + "    }\n" + "};\n";
    }

    private static void sortImports(JavaClass importer) {
    }

    private static String getJavaType(ComponentModel.ComponentOptionModel option) {
        String type = option.getJavaType();
        if (type.indexOf(60) != -1) {
            type = type.substring(0, type.indexOf(60));
        }
        type = type.replace('$', '.');
        return type;
    }

    private static String getJavaType(DataFormatModel.DataFormatOptionModel option) {
        String type = option.getJavaType();
        if (type.indexOf(60) != -1) {
            type = type.substring(0, type.indexOf(60));
        }
        type = type.replace('$', '.');
        return type;
    }

    private static String getJavaType(LanguageModel.LanguageOptionModel option) {
        String type = option.getJavaType();
        if (type.indexOf(60) != -1) {
            type = type.substring(0, type.indexOf(60));
        }
        type = type.replace('$', '.');
        return type;
    }

    private void findComponentNames(Set<String> componentNames) {
        this.componentJar.stream().filter(je -> !je.isDirectory()).map(ZipEntry::getName).filter(s -> s.startsWith("META-INF/services/org/apache/camel/component/")).map(s -> s.substring("META-INF/services/org/apache/camel/component/".length())).filter(s -> !s.startsWith(".") && !s.contains("/")).forEach(componentNames::add);
    }

    private List<String> findDataFormatNames() {
        return this.componentJar.stream().filter(je -> !je.isDirectory()).map(ZipEntry::getName).filter(s -> s.startsWith("META-INF/services/org/apache/camel/dataformat/")).map(s -> s.substring("META-INF/services/org/apache/camel/dataformat/".length())).filter(s -> !s.startsWith(".") && !s.contains("/")).collect(Collectors.toList());
    }

    private List<String> findLanguageNames() {
        return this.componentJar.stream().filter(je -> !je.isDirectory()).map(ZipEntry::getName).filter(s -> s.startsWith("META-INF/services/org/apache/camel/language/")).map(s -> s.substring("META-INF/services/org/apache/camel/language/".length())).filter(s -> !s.startsWith(".") && !s.contains("/")).collect(Collectors.toList());
    }

    private void writeSourceIfChanged(JavaClass source, String fileName, boolean innerClassesLast) throws MojoFailureException {
        this.writeSourceIfChanged(source.printClass(innerClassesLast), fileName);
    }

    private void writeSourceIfChanged(String source, String fileName) throws MojoFailureException {
        File target = new File(new File(this.baseDir, "src/main/java"), fileName);
        this.deleteFileOnMainArtifact(target);
        try {
            String header;
            try (InputStream is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("license-header-java.txt");){
                header = PackageHelper.loadText((InputStream)is);
            }
            String code = header + source;
            this.getLog().debug((CharSequence)("Source code generated:\n" + code));
            AbstractGeneratorMojo.updateResource(null, (Path)target.toPath(), (String)code);
        }
        catch (Exception e) {
            throw new MojoFailureException("IOError with file " + target, (Throwable)e);
        }
    }

    private void writeComponentSpringFactorySource(String packageName, String name) throws MojoFailureException {
        StringBuilder sb = new StringBuilder();
        sb.append("org.springframework.boot.autoconfigure.EnableAutoConfiguration=\\\n");
        String lineToAdd = packageName + "." + name + "\n";
        sb.append(lineToAdd);
        String fileName = "META-INF/spring.factories";
        File target = new File(new File(this.baseDir, "src/main/resources"), fileName);
        this.deleteFileOnMainArtifact(target);
        if (target.exists()) {
            try {
                boolean found = false;
                List lines = FileUtils.readLines((File)target, (Charset)StandardCharsets.UTF_8);
                for (String line : lines) {
                    if (!line.contains(name)) continue;
                    found = true;
                    break;
                }
                if (found) {
                    this.getLog().debug((CharSequence)("No changes to existing file: " + target));
                }
                int lastLine = 0;
                for (int i = lines.size() - 1; i >= 0; --i) {
                    String line = (String)lines.get(i);
                    if (line.trim().isEmpty()) continue;
                    line = line + ",\\";
                    lines.set(i, line);
                    lastLine = i;
                    break;
                }
                lines.add(lastLine + 1, lineToAdd);
                StringBuilder code = new StringBuilder();
                for (String line : lines) {
                    code.append(line).append("\n");
                }
                FileUtils.write((File)target, (CharSequence)code.toString(), (Charset)StandardCharsets.UTF_8, (boolean)false);
                this.getLog().info((CharSequence)("Updated existing file: " + target));
            }
            catch (Exception e) {
                throw new MojoFailureException("IOError with file " + target, (Throwable)e);
            }
        } else {
            try {
                InputStream is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("license-header.txt");
                String header = PackageHelper.loadText((InputStream)is);
                String code = sb.toString();
                code = header + "\n" + code;
                this.getLog().debug((CharSequence)("Source code generated:\n" + code));
                FileUtils.write((File)target, (CharSequence)code, (Charset)StandardCharsets.UTF_8);
                this.getLog().info((CharSequence)("Created file: " + target));
            }
            catch (Exception e) {
                throw new MojoFailureException("IOError with file " + target, (Throwable)e);
            }
        }
    }

    private String getStarterArtifactId() {
        if ("camel-core-engine".equals(this.project.getArtifactId())) {
            return "camel-core";
        }
        return this.project.getArtifactId();
    }

    private void deleteFileOnMainArtifact(File starterFile) {
    }

    static {
        PRIMITIVE_CLASSES = new HashMap<Type, Type>();
        PRIMITIVE_CLASSES.put(Boolean.TYPE, (Type)((Object)Boolean.class));
        PRIMITIVE_CLASSES.put(Character.TYPE, (Type)((Object)Character.class));
        PRIMITIVE_CLASSES.put(Long.TYPE, (Type)((Object)Long.class));
        PRIMITIVE_CLASSES.put(Integer.TYPE, (Type)((Object)Integer.class));
        PRIMITIVE_CLASSES.put(Byte.TYPE, (Type)((Object)Byte.class));
        PRIMITIVE_CLASSES.put(Short.TYPE, (Type)((Object)Short.class));
        PRIMITIVE_CLASSES.put(Double.TYPE, (Type)((Object)Double.class));
        PRIMITIVE_CLASSES.put(Float.TYPE, (Type)((Object)Float.class));
        PRIMITIVEMAP = new HashMap<String, String>();
        PRIMITIVEMAP.put("boolean", "java.lang.Boolean");
        PRIMITIVEMAP.put("char", "java.lang.Character");
        PRIMITIVEMAP.put("long", "java.lang.Long");
        PRIMITIVEMAP.put("int", "java.lang.Integer");
        PRIMITIVEMAP.put("integer", "java.lang.Integer");
        PRIMITIVEMAP.put("byte", "java.lang.Byte");
        PRIMITIVEMAP.put("short", "java.lang.Short");
        PRIMITIVEMAP.put("double", "java.lang.Double");
        PRIMITIVEMAP.put("float", "java.lang.Float");
    }
}

