/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.springboot.maven;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.camel.springboot.maven.AbstractSpringBootGenerator;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="prepare-catalog-springboot", threadSafe=true, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public class PrepareCatalogSpringBootMojo
extends AbstractSpringBootGenerator {
    private static final String[] IGNORE_MODULES = new String[]{"camel-spring-boot-xml", "camel-spring-boot-engine"};
    @Parameter(defaultValue="${basedir}/../../catalog/camel-catalog-provider-springboot")
    protected File catalogDir;

    @Override
    protected void executeAll() throws MojoExecutionException, MojoFailureException, IOException {
        if ("camel-core".equals(this.getMainDepArtifactId())) {
            this.executeAll(this.getMainDepGroupId(), "camel-core");
            this.executeAll(this.getMainDepGroupId(), "camel-base");
            this.executeAll(this.getMainDepGroupId(), "camel-core-engine");
        } else {
            this.executeAll(this.getMainDepGroupId(), this.getMainDepArtifactId());
        }
    }

    private void executeAll(String groupId, String artifactId) throws MojoExecutionException, MojoFailureException, IOException {
        try (JarFile componentJar = this.getJarFile(groupId, artifactId);){
            Map<String, Supplier<String>> files = this.getJSonFiles(componentJar);
            this.executeOthers(componentJar, files);
            this.executeComponents(componentJar, files);
            this.executeDataFormats(componentJar, files);
            this.executeLanguages(componentJar, files);
        }
    }

    @Override
    protected boolean isIgnore(String artifactId) {
        return Arrays.asList(IGNORE_MODULES).contains(artifactId);
    }

    protected void executeComponents(JarFile componentJar, Map<String, Supplier<String>> jsonFiles) throws MojoExecutionException, MojoFailureException, IOException {
        List<String> componentNames = this.findComponentNames(componentJar);
        if (!componentNames.isEmpty()) {
            this.getLog().info((CharSequence)("Components found: " + String.join((CharSequence)", ", componentNames)));
            ArrayList<String> actual = new ArrayList<String>();
            for (String componentName : componentNames) {
                String json = this.loadComponentJson(jsonFiles, componentName);
                if (json == null) continue;
                json = json.replace("\"groupId\": \"" + this.getMainDepGroupId() + "\"", "\"groupId\": \"" + this.project.getGroupId() + "\"").replace("\"artifactId\": \"" + this.getMainDepArtifactId() + "\"", "\"artifactId\": \"" + this.project.getArtifactId() + "\"").replace("\"version\": \"" + this.getMainDepVersion() + "\"", "\"version\": \"" + this.project.getVersion() + "\"");
                this.writeIfChanged(json, new File(this.catalogDir, "src/main/resources/org/apache/camel/springboot/catalog/components/" + componentName + ".json"));
                actual.add(componentName);
            }
            File components = new File(this.catalogDir, "src/main/resources/org/apache/camel/springboot/catalog/components.properties");
            Stream existing = components.isFile() ? Files.lines(components.toPath()) : Stream.empty();
            String content = Stream.concat(existing, actual.stream()).sorted().distinct().collect(Collectors.joining("\n"));
            this.writeIfChanged(content, components);
        }
    }

    protected void executeDataFormats(JarFile componentJar, Map<String, Supplier<String>> jsonFiles) throws MojoExecutionException, MojoFailureException, IOException {
        List<String> dataFormatNames = this.findDataFormatNames(componentJar);
        if (!dataFormatNames.isEmpty()) {
            this.getLog().info((CharSequence)("Dataformats found: " + String.join((CharSequence)", ", dataFormatNames)));
            ArrayList<String> actual = new ArrayList<String>();
            for (String dataformatName : dataFormatNames) {
                String json = this.loadDataFormatJson(jsonFiles, dataformatName);
                if (json == null) continue;
                json = json.replace("\"groupId\": \"" + this.getMainDepGroupId() + "\"", "\"groupId\": \"" + this.project.getGroupId() + "\"").replace("\"artifactId\": \"" + this.getMainDepArtifactId() + "\"", "\"artifactId\": \"" + this.project.getArtifactId() + "\"").replace("\"version\": \"" + this.getMainDepVersion() + "\"", "\"version\": \"" + this.project.getVersion() + "\"");
                this.writeIfChanged(json, new File(this.catalogDir, "src/main/resources/org/apache/camel/springboot/catalog/dataformats/" + dataformatName + ".json"));
                actual.add(dataformatName);
            }
            File dataformats = new File(this.catalogDir, "src/main/resources/org/apache/camel/springboot/catalog/dataformats.properties");
            Stream existing = dataformats.isFile() ? Files.lines(dataformats.toPath()) : Stream.empty();
            String content = Stream.concat(existing, actual.stream()).sorted().distinct().collect(Collectors.joining("\n"));
            this.writeIfChanged(content, dataformats);
        }
    }

    protected void executeLanguages(JarFile componentJar, Map<String, Supplier<String>> jsonFiles) throws MojoExecutionException, MojoFailureException, IOException {
        List<String> languageNames = this.findLanguageNames(componentJar);
        if (!languageNames.isEmpty()) {
            this.getLog().info((CharSequence)("Languages found: " + String.join((CharSequence)", ", languageNames)));
            ArrayList<String> actual = new ArrayList<String>();
            for (String languageName : languageNames) {
                String json = this.loadLanguageJson(jsonFiles, languageName);
                if (json == null) continue;
                json = json.replace("\"groupId\": \"" + this.getMainDepGroupId() + "\"", "\"groupId\": \"" + this.project.getGroupId() + "\"").replace("\"artifactId\": \"" + this.getMainDepArtifactId() + "\"", "\"artifactId\": \"" + this.project.getArtifactId() + "\"").replace("\"version\": \"" + this.getMainDepVersion() + "\"", "\"version\": \"" + this.project.getVersion() + "\"");
                this.writeIfChanged(json, new File(this.catalogDir, "src/main/resources/org/apache/camel/springboot/catalog/languages/" + languageName + ".json"));
                actual.add(languageName);
            }
            File languages = new File(this.catalogDir, "src/main/resources/org/apache/camel/springboot/catalog/languages.properties");
            Stream existing = languages.isFile() ? Files.lines(languages.toPath()) : Stream.empty();
            String content = Stream.concat(existing, actual.stream()).sorted().distinct().collect(Collectors.joining("\n"));
            this.writeIfChanged(content, languages);
        }
    }

    protected void executeOthers(JarFile componentJar, Map<String, Supplier<String>> jsonFiles) throws MojoExecutionException, MojoFailureException, IOException {
        List otherNames = this.findNames(componentJar, "").stream().map(s -> s.substring(0, s.length() - ".json".length())).filter(s -> !s.endsWith("-common") && !s.equals("as2") && !s.equals("cbor") && !s.equals("salesforce") && !s.equals("servicenow")).collect(Collectors.toList());
        if (!otherNames.isEmpty()) {
            this.getLog().info((CharSequence)("Others found: " + String.join((CharSequence)", ", otherNames)));
            ArrayList<String> actual = new ArrayList<String>();
            for (String otherName : otherNames) {
                String json = this.loadOtherJson(jsonFiles, otherName);
                if (json == null) continue;
                json = json.replace("\"groupId\": \"" + this.getMainDepGroupId() + "\"", "\"groupId\": \"" + this.project.getGroupId() + "\"").replace("\"artifactId\": \"" + this.getMainDepArtifactId() + "\"", "\"artifactId\": \"" + this.project.getArtifactId() + "\"").replace("\"version\": \"" + this.getMainDepVersion() + "\"", "\"version\": \"" + this.project.getVersion() + "\"");
                this.writeIfChanged(json, new File(this.catalogDir, "src/main/resources/org/apache/camel/springboot/catalog/others/" + otherName + ".json"));
                actual.add(otherName);
            }
            File others = new File(this.catalogDir, "src/main/resources/org/apache/camel/springboot/catalog/others.properties");
            Stream existing = others.isFile() ? Files.lines(others.toPath()) : Stream.empty();
            String content = Stream.concat(existing, actual.stream()).sorted().distinct().collect(Collectors.joining("\n"));
            this.writeIfChanged(content, others);
        }
    }
}

