/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.springboot.maven;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import org.apache.camel.tooling.util.PackageHelper;
import org.apache.commons.io.IOUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class AbstractSpringBootGenerator
extends AbstractMojo {
    @Parameter(property="project", required=true, readonly=true)
    protected MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.project.getArtifactId().equals("components-starter")) {
            return;
        }
        if (this.isIgnore(this.getMainDepArtifactId())) {
            this.getLog().info((CharSequence)"Skipping module contained in the ignore list");
            return;
        }
        try {
            this.executeAll();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error executing mojo", (Exception)e);
        }
    }

    protected boolean isIgnore(String artifactId) {
        return false;
    }

    protected String getMainDepArtifactId() {
        if (this.project.getArtifactId().equals("camel-core-starter")) {
            return "camel-core-engine";
        }
        return this.project.getArtifactId().substring(0, this.project.getArtifactId().length() - "-starter".length());
    }

    protected String getMainDepGroupId() {
        if ("camel-spring-boot-starter".equals(this.project.getArtifactId())) {
            return "org.apache.camel.springboot";
        }
        return "org.apache.camel";
    }

    protected Artifact getMainDep() {
        return (Artifact)this.project.getArtifactMap().get(this.getMainDepGroupId() + ":" + this.getMainDepArtifactId());
    }

    protected String getMainDepVersion() {
        return this.getMainDep().getVersion();
    }

    protected abstract void executeAll() throws MojoExecutionException, MojoFailureException, IOException;

    protected JarFile getJarFile() throws IOException {
        return this.getJarFile(this.getMainDepGroupId(), this.getMainDepArtifactId());
    }

    protected JarFile getJarFile(String groupId, String artifactId) throws IOException {
        return new JarFile(((Artifact)this.project.getArtifactMap().get(groupId + ":" + artifactId)).getFile());
    }

    protected Map<String, Supplier<String>> getJSonFiles(JarFile componentJar) {
        Artifact mainDep = this.getMainDep();
        Map<String, Supplier<String>> files = componentJar.stream().filter(je -> je.getName().endsWith(".json")).collect(Collectors.toMap(je -> "jar:" + mainDep.getFile().toURI().toString() + "!" + je.getName(), je -> AbstractSpringBootGenerator.cache(() -> AbstractSpringBootGenerator.loadJson(componentJar, je))));
        return files;
    }

    protected List<String> findComponentNames(JarFile componentJar) {
        return this.findNames(componentJar, "META-INF/services/org/apache/camel/component/");
    }

    protected List<String> findDataFormatNames(JarFile componentJar) {
        return this.findNames(componentJar, "META-INF/services/org/apache/camel/dataformat/");
    }

    protected List<String> findLanguageNames(JarFile componentJar) {
        return this.findNames(componentJar, "META-INF/services/org/apache/camel/language/");
    }

    protected List<String> findNames(JarFile componentJar, String dir) {
        return componentJar.stream().filter(je -> !je.isDirectory()).map(ZipEntry::getName).filter(s -> s.startsWith(dir)).map(s -> s.substring(dir.length())).filter(s -> !s.startsWith(".") && !s.contains("/")).collect(Collectors.toList());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static String loadJson(JarFile jar, JarEntry je) {
        try (InputStream is = jar.getInputStream(je);){
            String string = PackageHelper.loadText((InputStream)is);
            return string;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    protected static <T> Supplier<T> cache(final Supplier<T> supplier) {
        return new Supplier<T>(){
            T value;

            @Override
            public T get() {
                if (this.value == null) {
                    this.value = supplier.get();
                }
                return this.value;
            }
        };
    }

    protected String loadModelJson(Map<String, Supplier<String>> jsonFiles, String modelName) {
        return this.loadJsonOfType(jsonFiles, modelName + ".json", "model");
    }

    protected String loadComponentJson(Map<String, Supplier<String>> jsonFiles, String componentName) {
        return this.loadJsonOfType(jsonFiles, componentName + ".json", "component");
    }

    protected String loadDataFormatJson(Map<String, Supplier<String>> jsonFiles, String dataFormatName) {
        return this.loadJsonOfType(jsonFiles, dataFormatName + ".json", "dataformat");
    }

    protected String loadLanguageJson(Map<String, Supplier<String>> jsonFiles, String languageName) {
        return this.loadJsonOfType(jsonFiles, languageName + ".json", "language");
    }

    protected String loadOtherJson(Map<String, Supplier<String>> jsonFiles, String otherName) {
        return this.loadJsonOfType(jsonFiles, otherName + ".json", "other");
    }

    protected String loadJsonOfType(Map<String, Supplier<String>> jsonFiles, String modelName, String type) {
        for (Map.Entry<String, Supplier<String>> entry : jsonFiles.entrySet()) {
            String json;
            if (!entry.getKey().endsWith("/" + modelName) && !entry.getKey().endsWith("!" + modelName) || !(json = entry.getValue().get()).contains("\"kind\": \"" + type + "\"")) continue;
            return json;
        }
        return null;
    }

    protected void writeIfChanged(String content, File file) throws IOException {
        Throwable throwable;
        boolean write = true;
        if ((file = file.getCanonicalFile()).exists()) {
            throwable = null;
            try (FileReader fr = new FileReader(file);){
                String oldContent = IOUtils.toString((Reader)fr);
                if (!content.equals(oldContent)) {
                    this.getLog().debug((CharSequence)("Writing new file " + file.getAbsolutePath()));
                    fr.close();
                }
                this.getLog().debug((CharSequence)("File " + file.getAbsolutePath() + " has been left unchanged"));
                write = false;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        } else {
            File parent = file.getParentFile();
            parent.mkdirs();
        }
        if (write) {
            throwable = null;
            try (FileWriter fw = new FileWriter(file);){
                IOUtils.write((String)content, (Writer)fw);
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
    }
}

