/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.springboot.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.camel.springboot.maven.ExtMvelHelper;
import org.apache.camel.tooling.model.ArtifactModel;
import org.apache.camel.tooling.model.BaseModel;
import org.apache.camel.tooling.model.ComponentModel;
import org.apache.camel.tooling.model.DataFormatModel;
import org.apache.camel.tooling.model.JsonMapper;
import org.apache.camel.tooling.model.LanguageModel;
import org.apache.camel.tooling.model.OtherModel;
import org.apache.camel.tooling.util.PackageHelper;
import org.apache.camel.tooling.util.Strings;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.mvel2.templates.TemplateRuntime;

@Mojo(name="update-doc-components-list", threadSafe=true)
public class UpdateDocComponentsListMojo
extends AbstractMojo {
    @Parameter(property="project", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${project.build.directory}/classes/org/apache/camel/springboot/catalog/components")
    protected File componentsDir;
    @Parameter(defaultValue="${project.build.directory}/classes/org/apache/camel/springboot/catalog/dataformats")
    protected File dataFormatsDir;
    @Parameter(defaultValue="${project.build.directory}/classes/org/apache/camel/springboot/catalog/languages")
    protected File languagesDir;
    @Parameter(defaultValue="${project.build.directory}/classes/org/apache/camel/springboot/catalog/others")
    protected File othersDir;
    @Parameter(defaultValue="${project.directory}/../../../components-starter")
    protected File readmeComponentsStarterDir;
    @Parameter(defaultValue="${project.directory}/../../../docs/modules/ROOT/pages")
    protected File websiteDocBaseDir;
    @Component
    private MavenProjectHelper projectHelper;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.executeComponentsReadme();
        this.executeDataFormatsReadme();
        this.executeLanguagesReadme();
        this.executeOthersReadme();
    }

    protected void executeComponentsReadme() throws MojoExecutionException, MojoFailureException {
        File[] files;
        TreeSet<File> componentFiles = new TreeSet<File>();
        if (this.componentsDir != null && this.componentsDir.isDirectory() && (files = this.componentsDir.listFiles()) != null) {
            componentFiles.addAll(Arrays.asList(files));
        }
        try {
            ArrayList<ComponentModel> models = new ArrayList<ComponentModel>();
            for (File file : componentFiles) {
                String json = PackageHelper.loadText((InputStream)new FileInputStream(file));
                ComponentModel model = this.generateComponentModel(json);
                boolean add = true;
                if (model.getAlternativeSchemes() != null && !model.getAlternativeSchemes().isEmpty()) {
                    String first = model.getAlternativeSchemes().split(",")[0];
                    if (!model.getScheme().equals(first)) {
                        add = false;
                    }
                }
                if (!add) continue;
                models.add(model);
                if (!"imap".equals(model.getScheme())) continue;
                model.setScheme("mail");
                model.setTitle("Mail");
            }
            Collections.sort(models, new ComponentComparator());
            ArrayList<ComponentModel> components = new ArrayList<ComponentModel>();
            for (ComponentModel model : models) {
                components.add(model);
            }
            int n = components.stream().map(ArtifactModel::getArtifactId).collect(Collectors.toSet()).size();
            long deprecated = components.stream().filter(BaseModel::isDeprecated).count();
            File file = new File(this.readmeComponentsStarterDir, "README.adoc");
            boolean exists = file.exists();
            String changed = this.templateComponents(components, n, deprecated);
            boolean updated = this.updateComponents(file, changed);
            if (updated) {
                this.getLog().info((CharSequence)("Updated readme.adoc file: " + file));
            } else if (exists) {
                this.getLog().debug((CharSequence)("No changes to readme.adoc file: " + file));
            } else {
                this.getLog().warn((CharSequence)("No readme.adoc file: " + file));
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Error due " + e.getMessage(), (Throwable)e);
        }
    }

    protected void executeDataFormatsReadme() throws MojoExecutionException, MojoFailureException {
        File[] files;
        TreeSet<File> dataFormatFiles = new TreeSet<File>();
        if (this.dataFormatsDir != null && this.dataFormatsDir.isDirectory() && (files = this.dataFormatsDir.listFiles()) != null) {
            dataFormatFiles.addAll(Arrays.asList(files));
        }
        try {
            ArrayList<DataFormatModel> models = new ArrayList<DataFormatModel>();
            for (File file : dataFormatFiles) {
                String json = PackageHelper.loadText((InputStream)new FileInputStream(file));
                DataFormatModel model = this.generateDataFormatModel(json);
                if (model.getName().startsWith("bindy")) {
                    model.setName("bindy");
                }
                models.add(model);
            }
            Collections.sort(models, new DataFormatComparator());
            int count = models.stream().map(ArtifactModel::getArtifactId).collect(Collectors.toSet()).size();
            long deprecated = models.stream().filter(BaseModel::isDeprecated).count();
            ArrayList<DataFormatModel> dataFormats = new ArrayList<DataFormatModel>();
            for (DataFormatModel model : models) {
                dataFormats.add(model);
            }
            File file = new File(this.readmeComponentsStarterDir, "README.adoc");
            boolean exists = file.exists();
            String changed = this.templateDataFormats(dataFormats, count, deprecated);
            boolean updated = this.updateDataFormats(file, changed);
            if (updated) {
                this.getLog().info((CharSequence)("Updated readme.adoc file: " + file));
            } else if (exists) {
                this.getLog().debug((CharSequence)("No changes to readme.adoc file: " + file));
            } else {
                this.getLog().warn((CharSequence)("No readme.adoc file: " + file));
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Error due " + e.getMessage(), (Throwable)e);
        }
    }

    protected void executeLanguagesReadme() throws MojoExecutionException, MojoFailureException {
        File[] files;
        TreeSet<File> languageFiles = new TreeSet<File>();
        if (this.languagesDir != null && this.languagesDir.isDirectory() && (files = this.languagesDir.listFiles()) != null) {
            languageFiles.addAll(Arrays.asList(files));
        }
        try {
            ArrayList<LanguageModel> models = new ArrayList<LanguageModel>();
            for (File file : languageFiles) {
                String json = PackageHelper.loadText((InputStream)new FileInputStream(file));
                LanguageModel model = this.generateLanguageModel(json);
                models.add(model);
            }
            Collections.sort(models, new LanguageComparator());
            ArrayList<LanguageModel> languages = new ArrayList<LanguageModel>();
            for (LanguageModel model : models) {
                languages.add(model);
            }
            int n = languages.stream().map(ArtifactModel::getArtifactId).collect(Collectors.toSet()).size();
            long deprecated = languages.stream().filter(BaseModel::isDeprecated).count();
            File file = new File(this.readmeComponentsStarterDir, "README.adoc");
            boolean exists = file.exists();
            String changed = this.templateLanguages(languages, n, deprecated);
            boolean updated = this.updateLanguages(file, changed);
            if (updated) {
                this.getLog().info((CharSequence)("Updated readme.adoc file: " + file));
            } else if (exists) {
                this.getLog().debug((CharSequence)("No changes to readme.adoc file: " + file));
            } else {
                this.getLog().warn((CharSequence)("No readme.adoc file: " + file));
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Error due " + e.getMessage(), (Throwable)e);
        }
    }

    protected void executeOthersReadme() throws MojoExecutionException, MojoFailureException {
        File[] files;
        TreeSet<File> otherFiles = new TreeSet<File>();
        if (this.othersDir != null && this.othersDir.isDirectory() && (files = this.othersDir.listFiles()) != null) {
            otherFiles.addAll(Arrays.asList(files));
        }
        try {
            ArrayList<OtherModel> others = new ArrayList<OtherModel>();
            for (File file : otherFiles) {
                String json = PackageHelper.loadText((InputStream)new FileInputStream(file));
                OtherModel model = this.generateOtherModel(json);
                others.add(model);
            }
            Collections.sort(others, new OtherComparator());
            int count = others.stream().map(ArtifactModel::getArtifactId).collect(Collectors.toSet()).size();
            long deprecated = others.stream().filter(BaseModel::isDeprecated).count();
            File file = new File(this.readmeComponentsStarterDir, "README.adoc");
            boolean exists = file.exists();
            String changed = this.templateOthers(others, count, deprecated);
            boolean updated = this.updateOthers(file, changed);
            if (updated) {
                this.getLog().info((CharSequence)("Updated readme.adoc file: " + file));
            } else if (exists) {
                this.getLog().debug((CharSequence)("No changes to readme.adoc file: " + file));
            } else {
                this.getLog().warn((CharSequence)("No readme.adoc file: " + file));
            }
        }
        catch (IOException e) {
            throw new MojoFailureException("Error due " + e.getMessage(), (Throwable)e);
        }
    }

    private String templateComponents(List<ComponentModel> models, int artifacts, long deprecated) throws MojoExecutionException {
        try {
            String template = PackageHelper.loadText((InputStream)UpdateDocComponentsListMojo.class.getClassLoader().getResourceAsStream("readme-components.mvel"));
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("components", models);
            map.put("numberOfArtifacts", artifacts);
            map.put("numberOfDeprecated", deprecated);
            String out = (String)TemplateRuntime.eval((String)template, map, Collections.singletonMap("util", new ExtMvelHelper(this.getComponentsStarterDocPath())));
            return out;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error processing mvel template. Reason: " + e, e);
        }
    }

    private String templateDataFormats(List<DataFormatModel> models, int artifacts, long deprecated) throws MojoExecutionException {
        try {
            String template = PackageHelper.loadText((InputStream)UpdateDocComponentsListMojo.class.getClassLoader().getResourceAsStream("readme-dataformats.mvel"));
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("dataformats", models);
            map.put("numberOfArtifacts", artifacts);
            map.put("numberOfDeprecated", deprecated);
            String out = (String)TemplateRuntime.eval((String)template, map, Collections.singletonMap("util", new ExtMvelHelper(this.getComponentsStarterDocPath())));
            return out;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error processing mvel template. Reason: " + e, e);
        }
    }

    private String templateLanguages(List<LanguageModel> models, int artifacts, long deprecated) throws MojoExecutionException {
        try {
            String template = PackageHelper.loadText((InputStream)UpdateDocComponentsListMojo.class.getClassLoader().getResourceAsStream("readme-languages.mvel"));
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("languages", models);
            map.put("numberOfArtifacts", artifacts);
            map.put("numberOfDeprecated", deprecated);
            String out = (String)TemplateRuntime.eval((String)template, map, Collections.singletonMap("util", new ExtMvelHelper(this.getComponentsStarterDocPath())));
            return out;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error processing mvel template. Reason: " + e, e);
        }
    }

    private String templateOthers(List<OtherModel> models, int artifacts, long deprecated) throws MojoExecutionException {
        try {
            String template = PackageHelper.loadText((InputStream)UpdateDocComponentsListMojo.class.getClassLoader().getResourceAsStream("readme-others.mvel"));
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("others", models);
            map.put("numberOfArtifacts", artifacts);
            map.put("numberOfDeprecated", deprecated);
            String out = (String)TemplateRuntime.eval((String)template, map, Collections.singletonMap("util", new ExtMvelHelper(this.getComponentsStarterDocPath())));
            return out;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error processing mvel template. Reason: " + e, e);
        }
    }

    private boolean updateComponents(File file, String changed) throws MojoExecutionException {
        if (!file.exists()) {
            return false;
        }
        try {
            String text = PackageHelper.loadText((InputStream)new FileInputStream(file));
            String existing = Strings.between((String)text, (String)"// components: START", (String)"// components: END");
            if (existing != null) {
                if ((existing = existing.trim()).equals(changed = changed.trim())) {
                    return false;
                }
                String before = Strings.before((String)text, (String)"// components: START");
                String after = Strings.after((String)text, (String)"// components: END");
                text = before + "// components: START\n" + changed + "\n// components: END" + after;
                PackageHelper.writeText((File)file, (String)text);
                return true;
            }
            this.getLog().warn((CharSequence)("Cannot find markers in file " + file));
            this.getLog().warn((CharSequence)"Add the following markers");
            this.getLog().warn((CharSequence)"\t// components: START");
            this.getLog().warn((CharSequence)"\t// components: END");
            return false;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error reading file " + file + " Reason: " + e, e);
        }
    }

    private boolean updateDataFormats(File file, String changed) throws MojoExecutionException {
        if (!file.exists()) {
            return false;
        }
        try {
            String text = PackageHelper.loadText((InputStream)new FileInputStream(file));
            String existing = Strings.between((String)text, (String)"// dataformats: START", (String)"// dataformats: END");
            if (existing != null) {
                if ((existing = existing.trim()).equals(changed = changed.trim())) {
                    return false;
                }
                String before = Strings.before((String)text, (String)"// dataformats: START");
                String after = Strings.after((String)text, (String)"// dataformats: END");
                text = before + "// dataformats: START\n" + changed + "\n// dataformats: END" + after;
                PackageHelper.writeText((File)file, (String)text);
                return true;
            }
            this.getLog().warn((CharSequence)("Cannot find markers in file " + file));
            this.getLog().warn((CharSequence)"Add the following markers");
            this.getLog().warn((CharSequence)"\t// dataformats: START");
            this.getLog().warn((CharSequence)"\t// dataformats: END");
            return false;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error reading file " + file + " Reason: " + e, e);
        }
    }

    private boolean updateLanguages(File file, String changed) throws MojoExecutionException {
        if (!file.exists()) {
            return false;
        }
        try {
            String text = PackageHelper.loadText((InputStream)new FileInputStream(file));
            String existing = Strings.between((String)text, (String)"// languages: START", (String)"// languages: END");
            if (existing != null) {
                if ((existing = existing.trim()).equals(changed = changed.trim())) {
                    return false;
                }
                String before = Strings.before((String)text, (String)"// languages: START");
                String after = Strings.after((String)text, (String)"// languages: END");
                text = before + "// languages: START\n" + changed + "\n// languages: END" + after;
                PackageHelper.writeText((File)file, (String)text);
                return true;
            }
            this.getLog().warn((CharSequence)("Cannot find markers in file " + file));
            this.getLog().warn((CharSequence)"Add the following markers");
            this.getLog().warn((CharSequence)"\t// languages: START");
            this.getLog().warn((CharSequence)"\t// languages: END");
            return false;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error reading file " + file + " Reason: " + e, e);
        }
    }

    private boolean updateOthers(File file, String changed) throws MojoExecutionException {
        if (!file.exists()) {
            return false;
        }
        try {
            String text = PackageHelper.loadText((InputStream)new FileInputStream(file));
            String existing = Strings.between((String)text, (String)"// others: START", (String)"// others: END");
            if (existing != null) {
                if ((existing = existing.trim()).equals(changed = changed.trim())) {
                    return false;
                }
                String before = Strings.before((String)text, (String)"// others: START");
                String after = Strings.after((String)text, (String)"// others: END");
                text = before + "// others: START\n" + changed + "\n// others: END" + after;
                PackageHelper.writeText((File)file, (String)text);
                return true;
            }
            this.getLog().warn((CharSequence)("Cannot find markers in file " + file));
            this.getLog().warn((CharSequence)"Add the following markers");
            this.getLog().warn((CharSequence)"\t// others: START");
            this.getLog().warn((CharSequence)"\t// others: END");
            return false;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error reading file " + file + " Reason: " + e, e);
        }
    }

    private ComponentModel generateComponentModel(String json) {
        return JsonMapper.generateComponentModel((String)json);
    }

    private DataFormatModel generateDataFormatModel(String json) {
        return JsonMapper.generateDataFormatModel((String)json);
    }

    private LanguageModel generateLanguageModel(String json) {
        return JsonMapper.generateLanguageModel((String)json);
    }

    private OtherModel generateOtherModel(String json) {
        return JsonMapper.generateOtherModel((String)json);
    }

    private String getJSonValue(String key, List<Map<String, String>> rows) {
        for (Map<String, String> row : rows) {
            if (!row.containsKey(key)) continue;
            return row.get(key);
        }
        return "";
    }

    private Path getComponentsStarterDocPath() {
        return Paths.get(this.websiteDocBaseDir.toString(), "components-starter");
    }

    private static class OtherComparator
    implements Comparator<OtherModel> {
        private OtherComparator() {
        }

        @Override
        public int compare(OtherModel o1, OtherModel o2) {
            return o1.getTitle().compareToIgnoreCase(o2.getTitle());
        }
    }

    private static class LanguageComparator
    implements Comparator<LanguageModel> {
        private LanguageComparator() {
        }

        @Override
        public int compare(LanguageModel o1, LanguageModel o2) {
            return o1.getTitle().compareToIgnoreCase(o2.getTitle());
        }
    }

    private static class DataFormatComparator
    implements Comparator<DataFormatModel> {
        private DataFormatComparator() {
        }

        @Override
        public int compare(DataFormatModel o1, DataFormatModel o2) {
            return o1.getTitle().compareToIgnoreCase(o2.getTitle());
        }
    }

    private static class ComponentComparator
    implements Comparator<ComponentModel> {
        private ComponentComparator() {
        }

        @Override
        public int compare(ComponentModel o1, ComponentModel o2) {
            return o1.getTitle().compareToIgnoreCase(o2.getTitle());
        }
    }
}

