/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.springboot.maven;

import java.nio.file.Path;
import org.apache.camel.maven.packaging.MvelHelper;
import org.apache.camel.tooling.model.ComponentModel;
import org.apache.camel.tooling.model.DataFormatModel;
import org.apache.camel.tooling.model.LanguageModel;
import org.apache.camel.tooling.model.OtherModel;
import org.apache.camel.tooling.model.Strings;

public class ExtMvelHelper {
    private final Path extensionsDocPath;

    public ExtMvelHelper(Path extensionsDocPath) {
        this.extensionsDocPath = extensionsDocPath;
    }

    public static String escape(String raw) {
        return MvelHelper.escape((String)raw);
    }

    public String getFirstVersionShort(Object model) {
        String version = (String)this.invokeGetter(model, "getFirstVersion");
        return Strings.cutLastZeroDigit((String)version);
    }

    public String getDocLink(Object model) {
        if (this.localDocExists(model)) {
            return this.getLocalDocLink(model);
        }
        if (model instanceof ComponentModel) {
            return String.format("link:https://camel.apache.org/%s/latest/%s", "components", this.invokeGetter(model, "getScheme") + "-component.html");
        }
        if (model instanceof DataFormatModel) {
            return String.format("link:https://camel.apache.org/%s/latest/%s", "components", "dataformats/" + this.invokeGetter(model, "getName") + "-dataformat.html");
        }
        if (model instanceof LanguageModel) {
            return String.format("link:https://camel.apache.org/%s/latest/%s", "components", "languages/" + this.invokeGetter(model, "getName") + "-language.html");
        }
        if (model instanceof OtherModel) {
            return String.format("link:https://camel.apache.org/%s/latest/%s", "components", "others/" + this.invokeGetter(model, "getName") + ".html");
        }
        return null;
    }

    private Object invokeGetter(Object model, String method) {
        try {
            return model.getClass().getMethod(method, new Class[0]).invoke(model, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to access " + method + " from " + model, e);
        }
    }

    private boolean localDocExists(Object model) {
        Path path = this.extensionsDocPath.resolve(this.getSpringBootDocName(model));
        return path.toFile().exists();
    }

    private String getLocalDocLink(Object model) {
        return "xref:components-starter/" + this.getSpringBootDocName(model);
    }

    private String getSpringBootDocName(Object model) {
        return org.apache.camel.tooling.util.Strings.after((String)((String)this.invokeGetter(model, "getArtifactId")), (String)"camel-") + ".adoc";
    }
}

