/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.springboot.maven;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.apache.camel.maven.packaging.MvelHelper;
import org.apache.camel.tooling.model.ArtifactModel;
import org.apache.camel.tooling.model.BaseModel;
import org.apache.camel.tooling.model.ComponentModel;
import org.apache.camel.tooling.model.DataFormatModel;
import org.apache.camel.tooling.model.LanguageModel;
import org.apache.camel.tooling.model.OtherModel;
import org.apache.camel.tooling.model.Strings;
import org.apache.camel.tooling.model.SupportLevel;

public class ExtMvelHelper {
    private final Path extensionsDocPath;

    public ExtMvelHelper(Path extensionsDocPath) {
        this.extensionsDocPath = extensionsDocPath;
    }

    public static String escape(String raw) {
        return MvelHelper.escape((String)raw);
    }

    public String getFirstVersionShort(BaseModel<?> model) {
        String version = model.getFirstVersion();
        return Strings.cutLastZeroDigit((String)version);
    }

    public String getSupportLevel(ArtifactModel<?> model) {
        SupportLevel supportLevel = model.getSupportLevel();
        if (supportLevel != null) {
            return model.getSupportLevel().name();
        }
        return SupportLevel.Preview.name();
    }

    public String getDocLink(ArtifactModel<?> model) {
        if (this.isLocalComponent(model)) {
            return String.format("xref:%s.adoc", model.getName());
        }
        if (model instanceof ComponentModel) {
            return String.format("xref:latest@components::%s-component.adoc", ((ComponentModel)model).getScheme());
        }
        if (model instanceof DataFormatModel) {
            return String.format("xref:latest@components:dataformats:%s-dataformat.adoc", ((DataFormatModel)model).getName());
        }
        if (model instanceof LanguageModel) {
            return String.format("xref:latest@components:languages:%s-language.adoc", ((LanguageModel)model).getName());
        }
        if (model instanceof OtherModel) {
            return String.format("xref:latest@components:others:%s.adoc", ((OtherModel)model).getName());
        }
        return null;
    }

    private boolean isLocalComponent(ArtifactModel<?> model) {
        return Files.exists(this.extensionsDocPath.resolve(model.getName() + ".adoc"), new LinkOption[0]);
    }
}

