/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.rest.openapi.springboot;

import org.apache.camel.component.rest.openapi.RestOpenapiProcessorStrategy;
import org.apache.camel.spring.boot.ComponentConfigurationPropertiesCommon;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * To call REST services using OpenAPI specification as contract.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@ConfigurationProperties(prefix = "camel.component.rest-openapi")
public class RestOpenApiComponentConfiguration
        extends
            ComponentConfigurationPropertiesCommon {

    /**
     * Whether to enable auto configuration of the rest-openapi component. This
     * is enabled by default.
     */
    private Boolean enabled;
    /**
     * API basePath, for example /v2. Default is unset, if set overrides the
     * value present in OpenApi specification.
     */
    private String basePath;
    /**
     * Path to the OpenApi specification file. The scheme, host base path are
     * taken from this specification, but these can be overridden with
     * properties on the component or endpoint level. If not given the component
     * tries to load openapi.json resource. Note that the host defined on the
     * component and endpoint of this Component should contain the scheme,
     * hostname and optionally the port in the URI syntax (i.e.
     * https://api.example.com:8080). Can be overridden in endpoint
     * configuration.
     */
    private String specificationUri = "openapi.json";
    /**
     * Sets the context-path to use for servicing the OpenAPI specification
     */
    private String apiContextPath;
    /**
     * Allows for bridging the consumer to the Camel routing Error Handler,
     * which mean any exceptions (if possible) occurred while the Camel consumer
     * is trying to pickup incoming messages, or the likes, will now be
     * processed as a message and handled by the routing Error Handler.
     * Important: This is only possible if the 3rd party component allows Camel
     * to be alerted if an exception was thrown. Some components handle this
     * internally only, and therefore bridgeErrorHandler is not possible. In
     * other situations we may improve the Camel component to hook into the 3rd
     * party component and make this possible for future releases. By default
     * the consumer will use the org.apache.camel.spi.ExceptionHandler to deal
     * with exceptions, that will be logged at WARN or ERROR level and ignored.
     */
    private Boolean bridgeErrorHandler = false;
    /**
     * Whether to enable validation of the client request to check if the
     * incoming request is valid according to the OpenAPI specification
     */
    private Boolean clientRequestValidation = false;
    /**
     * Whether the consumer should fail,ignore or return a mock response for
     * OpenAPI operations that are not mapped to a corresponding route.
     */
    private String missingOperation = "fail";
    /**
     * Package name to use as base (offset) for classpath scanning of POJO
     * classes are located when using binding mode is enabled for JSon or XML.
     * Multiple package names can be separated by comma.
     */
    private String bindingPackageScan;
    /**
     * Name of the Camel component that will service the requests. The component
     * must be present in Camel registry and it must implement
     * RestOpenApiConsumerFactory service provider interface. If not set
     * CLASSPATH is searched for single component that implements
     * RestOpenApiConsumerFactory SPI. Can be overridden in endpoint
     * configuration.
     */
    private String consumerComponentName;
    /**
     * Used for inclusive filtering of mock data from directories. The pattern
     * is using Ant-path style pattern. Multiple patterns can be specified
     * separated by comma.
     */
    private String mockIncludePattern = "classpath:camel-mock/**";
    /**
     * To use a custom strategy for how to process Rest DSL requests. The option
     * is a org.apache.camel.component.rest.openapi.RestOpenapiProcessorStrategy
     * type.
     */
    private RestOpenapiProcessorStrategy restOpenapiProcessorStrategy;
    /**
     * Scheme hostname and port to direct the HTTP requests to in the form of
     * https://hostname:port. Can be configured at the endpoint, component or in
     * the corresponding REST configuration in the Camel Context. If you give
     * this component a name (e.g. petstore) that REST configuration is
     * consulted first, rest-openapi next, and global configuration last. If set
     * overrides any value found in the OpenApi specification,
     * RestConfiguration. Can be overridden in endpoint configuration.
     */
    private String host;
    /**
     * Whether the producer should be started lazy (on the first message). By
     * starting lazy you can use this to allow CamelContext and routes to
     * startup in situations where a producer may otherwise fail during starting
     * and cause the route to fail being started. By deferring this startup to
     * be lazy then the startup failure can be handled during routing messages
     * via Camel's routing error handlers. Beware that when the first message is
     * processed then creating and starting the producer may take a little time
     * and prolong the total processing time of the processing.
     */
    private Boolean lazyStartProducer = false;
    /**
     * Enable validation of requests against the configured OpenAPI
     * specification
     */
    private Boolean requestValidationEnabled = false;
    /**
     * Name of the Camel component that will perform the requests. The component
     * must be present in Camel registry and it must implement
     * RestProducerFactory service provider interface. If not set CLASSPATH is
     * searched for single component that implements RestProducerFactory SPI.
     * Can be overridden in endpoint configuration.
     */
    private String componentName;
    /**
     * What payload type this component capable of consuming. Could be one type,
     * like application/json or multiple types as application/json,
     * application/xml; q=0.5 according to the RFC7231. This equates to the
     * value of Accept HTTP header. If set overrides any value found in the
     * OpenApi specification. Can be overridden in endpoint configuration
     */
    private String consumes;
    /**
     * What payload type this component is producing. For example
     * application/json according to the RFC7231. This equates to the value of
     * Content-Type HTTP header. If set overrides any value present in the
     * OpenApi specification. Can be overridden in endpoint configuration.
     */
    private String produces;
    /**
     * Whether autowiring is enabled. This is used for automatic autowiring
     * options (the option must be marked as autowired) by looking up in the
     * registry to find if there is a single instance of matching type, which
     * then gets configured on the component. This can be used for automatic
     * configuring JDBC data sources, JMS connection factories, AWS Clients,
     * etc.
     */
    private Boolean autowiredEnabled = true;
    /**
     * Customize TLS parameters used by the component. If not set defaults to
     * the TLS parameters set in the Camel context. The option is a
     * org.apache.camel.support.jsse.SSLContextParameters type.
     */
    private SSLContextParameters sslContextParameters;
    /**
     * Enable usage of global SSL context parameters.
     */
    private Boolean useGlobalSslContextParameters = false;

    public String getBasePath() {
        return basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public String getSpecificationUri() {
        return specificationUri;
    }

    public void setSpecificationUri(String specificationUri) {
        this.specificationUri = specificationUri;
    }

    public String getApiContextPath() {
        return apiContextPath;
    }

    public void setApiContextPath(String apiContextPath) {
        this.apiContextPath = apiContextPath;
    }

    public Boolean getBridgeErrorHandler() {
        return bridgeErrorHandler;
    }

    public void setBridgeErrorHandler(Boolean bridgeErrorHandler) {
        this.bridgeErrorHandler = bridgeErrorHandler;
    }

    public Boolean getClientRequestValidation() {
        return clientRequestValidation;
    }

    public void setClientRequestValidation(Boolean clientRequestValidation) {
        this.clientRequestValidation = clientRequestValidation;
    }

    public String getMissingOperation() {
        return missingOperation;
    }

    public void setMissingOperation(String missingOperation) {
        this.missingOperation = missingOperation;
    }

    public String getBindingPackageScan() {
        return bindingPackageScan;
    }

    public void setBindingPackageScan(String bindingPackageScan) {
        this.bindingPackageScan = bindingPackageScan;
    }

    public String getConsumerComponentName() {
        return consumerComponentName;
    }

    public void setConsumerComponentName(String consumerComponentName) {
        this.consumerComponentName = consumerComponentName;
    }

    public String getMockIncludePattern() {
        return mockIncludePattern;
    }

    public void setMockIncludePattern(String mockIncludePattern) {
        this.mockIncludePattern = mockIncludePattern;
    }

    public RestOpenapiProcessorStrategy getRestOpenapiProcessorStrategy() {
        return restOpenapiProcessorStrategy;
    }

    public void setRestOpenapiProcessorStrategy(
            RestOpenapiProcessorStrategy restOpenapiProcessorStrategy) {
        this.restOpenapiProcessorStrategy = restOpenapiProcessorStrategy;
    }

    public String getHost() {
        return host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Boolean getLazyStartProducer() {
        return lazyStartProducer;
    }

    public void setLazyStartProducer(Boolean lazyStartProducer) {
        this.lazyStartProducer = lazyStartProducer;
    }

    public Boolean getRequestValidationEnabled() {
        return requestValidationEnabled;
    }

    public void setRequestValidationEnabled(Boolean requestValidationEnabled) {
        this.requestValidationEnabled = requestValidationEnabled;
    }

    public String getComponentName() {
        return componentName;
    }

    public void setComponentName(String componentName) {
        this.componentName = componentName;
    }

    public String getConsumes() {
        return consumes;
    }

    public void setConsumes(String consumes) {
        this.consumes = consumes;
    }

    public String getProduces() {
        return produces;
    }

    public void setProduces(String produces) {
        this.produces = produces;
    }

    public Boolean getAutowiredEnabled() {
        return autowiredEnabled;
    }

    public void setAutowiredEnabled(Boolean autowiredEnabled) {
        this.autowiredEnabled = autowiredEnabled;
    }

    public SSLContextParameters getSslContextParameters() {
        return sslContextParameters;
    }

    public void setSslContextParameters(
            SSLContextParameters sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }

    public Boolean getUseGlobalSslContextParameters() {
        return useGlobalSslContextParameters;
    }

    public void setUseGlobalSslContextParameters(
            Boolean useGlobalSslContextParameters) {
        this.useGlobalSslContextParameters = useGlobalSslContextParameters;
    }
}