/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.reactive.streams.springboot;

import org.apache.camel.CamelContext;
import org.apache.camel.component.reactive.streams.ReactiveStreamsHelper;
import org.apache.camel.component.reactive.streams.api.CamelReactiveStreamsService;
import org.apache.camel.component.reactive.streams.engine.ReactiveStreamsEngineConfiguration;
import org.apache.camel.component.reactive.streams.springboot.ReactiveStreamsComponentAutoConfiguration;
import org.apache.camel.component.reactive.streams.springboot.ReactiveStreamsComponentConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Lazy;

@AutoConfigureAfter(value={ReactiveStreamsComponentAutoConfiguration.class})
@ConditionalOnBean(value={ReactiveStreamsComponentAutoConfiguration.class})
@EnableConfigurationProperties(value={ReactiveStreamsComponentConfiguration.class})
public class ReactiveStreamsServiceAutoConfiguration {
    @Autowired
    private CamelContext context;
    @Autowired
    private ReactiveStreamsComponentConfiguration configuration;

    @Lazy
    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass(value={CamelContext.class})
    public CamelReactiveStreamsService camelReactiveStreamsService(ApplicationContext ac) throws Exception {
        ReactiveStreamsEngineConfiguration engineConfiguration = new ReactiveStreamsEngineConfiguration();
        if (this.configuration.getReactiveStreamsEngineConfiguration() != null) {
            engineConfiguration = (ReactiveStreamsEngineConfiguration)ac.getBean(this.configuration.getReactiveStreamsEngineConfiguration(), ReactiveStreamsEngineConfiguration.class);
        } else {
            engineConfiguration.setThreadPoolName(this.configuration.getThreadPoolName());
            if (this.configuration.getThreadPoolMinSize() != null) {
                engineConfiguration.setThreadPoolMinSize(this.configuration.getThreadPoolMinSize().intValue());
            }
            if (this.configuration.getThreadPoolMaxSize() != null) {
                engineConfiguration.setThreadPoolMinSize(this.configuration.getThreadPoolMaxSize().intValue());
            }
        }
        return ReactiveStreamsHelper.resolveReactiveStreamsService((CamelContext)this.context, (String)this.configuration.getServiceType(), (ReactiveStreamsEngineConfiguration)engineConfiguration);
    }
}

