/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.platform.http.springboot;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Suspendable;
import org.apache.camel.SuspendableService;
import org.apache.camel.component.platform.http.PlatformHttpEndpoint;
import org.apache.camel.component.platform.http.springboot.PlatformHttpMessage;
import org.apache.camel.component.platform.http.springboot.SpringBootPlatformHttpBinding;
import org.apache.camel.http.common.DefaultHttpBinding;
import org.apache.camel.http.common.HttpBinding;
import org.apache.camel.http.common.HttpHelper;
import org.apache.camel.support.DefaultConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpringBootPlatformHttpConsumer
extends DefaultConsumer
implements Suspendable,
SuspendableService {
    private static final Logger LOG = LoggerFactory.getLogger(SpringBootPlatformHttpConsumer.class);
    private final DefaultHttpBinding binding = new SpringBootPlatformHttpBinding();

    public SpringBootPlatformHttpConsumer(PlatformHttpEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.binding.setHeaderFilterStrategy(endpoint.getHeaderFilterStrategy());
        this.binding.setMuteException(endpoint.isMuteException());
        this.binding.setFileNameExtWhitelist(endpoint.getFileNameExtWhitelist());
    }

    public PlatformHttpEndpoint getEndpoint() {
        return (PlatformHttpEndpoint)super.getEndpoint();
    }

    public void service(HttpServletRequest request, HttpServletResponse response) {
        LOG.trace("Service: {}", (Object)request);
        try {
            this.handleService(request, response);
        }
        catch (Exception e) {
            LOG.warn("Error handling request due to: {}", (Object)e.getMessage(), (Object)e);
            try {
                if (!response.isCommitted()) {
                    response.sendError(500);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleService(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (this.isSuspended()) {
            LOG.debug("Consumer suspended, cannot service request: {}", (Object)request);
            response.sendError(503);
            return;
        }
        Exchange exchange = this.createExchange(true);
        exchange.setPattern(ExchangePattern.InOut);
        HttpHelper.setCharsetFromContentType((String)request.getContentType(), (Exchange)exchange);
        exchange.setIn((Message)new PlatformHttpMessage(exchange, (HttpBinding)this.binding, request, response));
        String contextPath = this.getEndpoint().getPath();
        exchange.getIn().setHeader("CamelPlatformHttpContextPath", (Object)contextPath);
        String httpPath = (String)exchange.getIn().getHeader("CamelHttpPath");
        if (contextPath != null && httpPath.startsWith(contextPath)) {
            exchange.getIn().setHeader("CamelHttpPath", (Object)httpPath.substring(contextPath.length()));
        }
        try {
            this.createUoW(exchange);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Processing request for exchangeId: {}", (Object)exchange.getExchangeId());
        }
        try {
            this.getProcessor().process(exchange);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        finally {
            this.afterProcess(response, exchange, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void afterProcess(HttpServletResponse response, Exchange exchange, boolean rethrow) throws IOException, ServletException {
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Writing res for exchangeId: {}", (Object)exchange.getExchangeId());
            }
            this.binding.writeResponse(exchange, response);
        }
        catch (IOException e) {
            LOG.error("Error processing request", (Throwable)e);
            if (rethrow) {
                throw e;
            }
            exchange.setException((Throwable)e);
        }
        catch (Exception e) {
            LOG.error("Error processing request", (Throwable)e);
            if (rethrow) {
                throw new ServletException((Throwable)e);
            }
            exchange.setException((Throwable)e);
        }
        finally {
            this.doneUoW(exchange);
            this.releaseExchange(exchange, false);
        }
    }
}

