/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.platform.http.springboot;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import org.apache.camel.Message;
import org.apache.camel.component.platform.http.PlatformHttpEndpoint;
import org.apache.camel.http.base.HttpHelper;
import org.apache.camel.http.common.DefaultHttpBinding;

public class SpringBootPlatformHttpBinding
extends DefaultHttpBinding {
    protected void populateRequestParameters(HttpServletRequest request, Message message) {
        super.populateRequestParameters(request, message);
        String path = request.getRequestURI();
        if (path != null && path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path != null) {
            PlatformHttpEndpoint endpoint = (PlatformHttpEndpoint)message.getExchange().getFromEndpoint();
            String consumerPath = endpoint.getPath();
            if (consumerPath != null && consumerPath.startsWith("/")) {
                consumerPath = consumerPath.substring(1);
            }
            if (this.useRestMatching(consumerPath)) {
                HttpHelper.evalPlaceholders((Map)message.getHeaders(), (String)path, (String)consumerPath);
            }
        }
    }

    private boolean useRestMatching(String path) {
        return path.indexOf(123) > -1;
    }
}

