/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.platform.http.springboot;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.camel.component.platform.http.HttpEndpointModel;
import org.apache.camel.component.platform.http.PlatformHttpComponent;
import org.apache.camel.component.platform.http.PlatformHttpEndpoint;
import org.apache.camel.component.platform.http.PlatformHttpListener;
import org.apache.camel.component.platform.http.spi.PlatformHttpEngine;
import org.apache.camel.component.platform.http.springboot.SpringBootPlatformHttpConsumer;
import org.apache.camel.util.ReflectionHelper;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import org.springframework.web.util.ServletRequestPathUtils;

public class CamelRequestHandlerMapping
extends RequestMappingHandlerMapping
implements PlatformHttpListener {
    private final PlatformHttpComponent component;
    private final PlatformHttpEngine engine;

    public CamelRequestHandlerMapping(PlatformHttpComponent component, PlatformHttpEngine engine) {
        this.component = component;
        this.engine = engine;
        this.component.addPlatformHttpListener((PlatformHttpListener)this);
    }

    public int getOrder() {
        return -1;
    }

    protected String[] getCandidateBeanNames() {
        return new String[0];
    }

    protected boolean isHandler(Class<?> beanType) {
        return false;
    }

    protected RequestMappingInfo getMappingForMethod(Method method, Class<?> handlerType) {
        return null;
    }

    protected HandlerMethod getHandlerInternal(HttpServletRequest request) throws Exception {
        ServletRequestPathUtils.parseAndCache((HttpServletRequest)request);
        return super.getHandlerInternal(request);
    }

    public void registerHttpEndpoint(HttpEndpointModel model) {
        RequestMappingInfo info = this.asRequestMappingInfo(model);
        Method m = ReflectionHelper.findMethod(SpringBootPlatformHttpConsumer.class, (String)"service", (Class[])new Class[]{HttpServletRequest.class, HttpServletResponse.class});
        this.registerMapping(info, model.getConsumer(), m);
    }

    public void unregisterHttpEndpoint(HttpEndpointModel model) {
    }

    private RequestMappingInfo asRequestMappingInfo(HttpEndpointModel model) {
        ArrayList<RequestMethod> methods = new ArrayList<RequestMethod>();
        String verbs = model.getVerbs();
        if (verbs == null && model.getConsumer() != null) {
            PlatformHttpEndpoint endpoint = (PlatformHttpEndpoint)model.getConsumer().getEndpoint();
            verbs = endpoint.getHttpMethodRestrict();
        }
        if (verbs != null) {
            for (PlatformHttpEndpoint v : model.getVerbs().split(",")) {
                RequestMethod rm = RequestMethod.resolve((String)v);
                methods.add(rm);
            }
        }
        RequestMappingInfo info = RequestMappingInfo.paths((String[])new String[]{model.getUri()}).methods(methods.toArray(new RequestMethod[0])).options(this.getBuilderConfiguration()).build();
        return info;
    }
}

