/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.namespaces.springboot;

import java.util.HashMap;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.component.kubernetes.namespaces.KubernetesNamespacesComponent;
import org.apache.camel.component.kubernetes.namespaces.springboot.KubernetesNamespacesComponentConfiguration;
import org.apache.camel.spi.ComponentCustomizer;
import org.apache.camel.spi.HasId;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.apache.camel.spring.boot.ComponentConfigurationProperties;
import org.apache.camel.spring.boot.util.CamelPropertiesHelper;
import org.apache.camel.spring.boot.util.ConditionalOnCamelContextAndAutoConfigurationBeans;
import org.apache.camel.spring.boot.util.GroupCondition;
import org.apache.camel.spring.boot.util.HierarchicalPropertiesEvaluator;
import org.apache.camel.support.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.env.Environment;

@Configuration(proxyBeanMethods=false)
@Conditional(value={ConditionalOnCamelContextAndAutoConfigurationBeans.class, GroupConditions.class})
@AutoConfigureAfter(value={CamelAutoConfiguration.class})
@EnableConfigurationProperties(value={ComponentConfigurationProperties.class, KubernetesNamespacesComponentConfiguration.class})
public class KubernetesNamespacesComponentAutoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(KubernetesNamespacesComponentAutoConfiguration.class);
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private CamelContext camelContext;
    @Autowired
    private KubernetesNamespacesComponentConfiguration configuration;
    @Autowired(required=false)
    private List<ComponentCustomizer<KubernetesNamespacesComponent>> customizers;

    @Lazy
    @Bean(name={"kubernetes-namespaces-component"})
    @ConditionalOnMissingBean(value={KubernetesNamespacesComponent.class})
    public KubernetesNamespacesComponent configureKubernetesNamespacesComponent() throws Exception {
        KubernetesNamespacesComponent component = new KubernetesNamespacesComponent();
        component.setCamelContext(this.camelContext);
        HashMap parameters = new HashMap();
        IntrospectionSupport.getProperties((Object)((Object)this.configuration), parameters, null, (boolean)false);
        CamelPropertiesHelper.setCamelProperties((CamelContext)this.camelContext, (Object)component, parameters, (boolean)false);
        if (ObjectHelper.isNotEmpty(this.customizers)) {
            for (ComponentCustomizer<KubernetesNamespacesComponent> customizer : this.customizers) {
                boolean useCustomizer = customizer instanceof HasId ? HierarchicalPropertiesEvaluator.evaluate((Environment)this.applicationContext.getEnvironment(), (String[])new String[]{"camel.component.customizer", "camel.component.kubernetes-namespaces.customizer", ((HasId)customizer).getId()}) : HierarchicalPropertiesEvaluator.evaluate((Environment)this.applicationContext.getEnvironment(), (String[])new String[]{"camel.component.customizer", "camel.component.kubernetes-namespaces.customizer"});
                if (!useCustomizer) continue;
                LOGGER.debug("Configure component {}, with customizer {}", (Object)component, customizer);
                customizer.customize((Component)component);
            }
        }
        return component;
    }

    static class GroupConditions
    extends GroupCondition {
        public GroupConditions() {
            super("camel.component", "camel.component.kubernetes-namespaces");
        }
    }
}

