/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.knative.springboot;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.camel.component.knative.KnativeConfiguration;
import org.apache.camel.component.knative.spi.KnativeConsumerFactory;
import org.apache.camel.component.knative.spi.KnativeEnvironment;
import org.apache.camel.component.knative.spi.KnativeProducerFactory;
import org.apache.camel.component.knative.spi.KnativeSinkBinding;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinding;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.stereotype.Component;

@Configuration(proxyBeanMethods=false)
@ConfigurationPropertiesBinding
@Component
public class KnativeComponentConverter
implements GenericConverter {
    @Autowired
    private ApplicationContext applicationContext;

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        LinkedHashSet<GenericConverter.ConvertiblePair> answer = new LinkedHashSet<GenericConverter.ConvertiblePair>();
        answer.add(new GenericConverter.ConvertiblePair(String.class, KnativeConfiguration.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, KnativeConsumerFactory.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, KnativeEnvironment.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, KnativeProducerFactory.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, KnativeSinkBinding.class));
        return answer;
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return null;
        }
        String ref = source.toString();
        if (!ref.startsWith("#")) {
            return null;
        }
        ref = ref.startsWith("#bean:") ? ref.substring(6) : ref.substring(1);
        switch (targetType.getName()) {
            case "org.apache.camel.component.knative.KnativeConfiguration": {
                return this.applicationContext.getBean(ref, KnativeConfiguration.class);
            }
            case "org.apache.camel.component.knative.spi.KnativeConsumerFactory": {
                return this.applicationContext.getBean(ref, KnativeConsumerFactory.class);
            }
            case "org.apache.camel.component.knative.spi.KnativeEnvironment": {
                return this.applicationContext.getBean(ref, KnativeEnvironment.class);
            }
            case "org.apache.camel.component.knative.spi.KnativeProducerFactory": {
                return this.applicationContext.getBean(ref, KnativeProducerFactory.class);
            }
            case "org.apache.camel.component.knative.spi.KnativeSinkBinding": {
                return this.applicationContext.getBean(ref, KnativeSinkBinding.class);
            }
        }
        return null;
    }
}

