/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http.springboot;

import java.util.LinkedHashSet;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import org.apache.camel.CamelContext;
import org.apache.camel.component.http.HttpClientConfigurer;
import org.apache.camel.http.common.HttpBinding;
import org.apache.camel.http.common.HttpConfiguration;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.http.client.CookieStore;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;

public class HttpComponentConverter
implements GenericConverter {
    private final CamelContext camelContext;

    public HttpComponentConverter(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        LinkedHashSet<GenericConverter.ConvertiblePair> answer = new LinkedHashSet<GenericConverter.ConvertiblePair>();
        answer.add(new GenericConverter.ConvertiblePair(String.class, CookieStore.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, HttpClientConnectionManager.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, HttpBinding.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, HttpClientConfigurer.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, HttpConfiguration.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, HttpContext.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, HeaderFilterStrategy.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, SSLContextParameters.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, HostnameVerifier.class));
        return answer;
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return null;
        }
        String ref = source.toString();
        if (!ref.startsWith("#")) {
            return null;
        }
        ref = ref.startsWith("#bean:") ? ref.substring(6) : ref.substring(1);
        switch (targetType.getName()) {
            case "org.apache.http.client.CookieStore": {
                return this.camelContext.getRegistry().lookupByNameAndType(ref, CookieStore.class);
            }
            case "org.apache.http.conn.HttpClientConnectionManager": {
                return this.camelContext.getRegistry().lookupByNameAndType(ref, HttpClientConnectionManager.class);
            }
            case "org.apache.camel.http.common.HttpBinding": {
                return this.camelContext.getRegistry().lookupByNameAndType(ref, HttpBinding.class);
            }
            case "org.apache.camel.component.http.HttpClientConfigurer": {
                return this.camelContext.getRegistry().lookupByNameAndType(ref, HttpClientConfigurer.class);
            }
            case "org.apache.camel.http.common.HttpConfiguration": {
                return this.camelContext.getRegistry().lookupByNameAndType(ref, HttpConfiguration.class);
            }
            case "org.apache.http.protocol.HttpContext": {
                return this.camelContext.getRegistry().lookupByNameAndType(ref, HttpContext.class);
            }
            case "org.apache.camel.spi.HeaderFilterStrategy": {
                return this.camelContext.getRegistry().lookupByNameAndType(ref, HeaderFilterStrategy.class);
            }
            case "org.apache.camel.support.jsse.SSLContextParameters": {
                return this.camelContext.getRegistry().lookupByNameAndType(ref, SSLContextParameters.class);
            }
            case "javax.net.ssl.HostnameVerifier": {
                return this.camelContext.getRegistry().lookupByNameAndType(ref, HostnameVerifier.class);
            }
        }
        return null;
    }
}

