/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http.springboot;

import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.component.http.HttpComponent;
import org.apache.camel.component.http.springboot.HttpComponentConfiguration;
import org.apache.camel.component.http.springboot.HttpComponentConverter;
import org.apache.camel.spi.ComponentCustomizer;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.apache.camel.spring.boot.ComponentConfigurationProperties;
import org.apache.camel.spring.boot.util.CamelPropertiesHelper;
import org.apache.camel.spring.boot.util.ConditionalOnCamelContextAndAutoConfigurationBeans;
import org.apache.camel.spring.boot.util.ConditionalOnHierarchicalProperties;
import org.apache.camel.spring.boot.util.HierarchicalPropertiesEvaluator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.convert.ApplicationConversionService;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.convert.converter.GenericConverter;

@Configuration(proxyBeanMethods=false)
@AutoConfigureAfter(value={CamelAutoConfiguration.class})
@Conditional(value={ConditionalOnCamelContextAndAutoConfigurationBeans.class})
@EnableConfigurationProperties(value={ComponentConfigurationProperties.class, HttpComponentConfiguration.class})
@ConditionalOnHierarchicalProperties(value={"camel.component", "camel.component.http"})
public class HttpComponentAutoConfiguration {
    @Autowired
    private ApplicationContext applicationContext;
    private final CamelContext camelContext;
    @Autowired
    private HttpComponentConfiguration configuration;

    public HttpComponentAutoConfiguration(CamelContext camelContext) {
        this.camelContext = camelContext;
        ApplicationConversionService acs = (ApplicationConversionService)ApplicationConversionService.getSharedInstance();
        acs.addConverter((GenericConverter)new HttpComponentConverter(camelContext));
    }

    @Lazy
    @Bean
    public ComponentCustomizer configureHttpComponent() {
        return new ComponentCustomizer(){

            public void configure(String name, Component target) {
                CamelPropertiesHelper.copyProperties((CamelContext)HttpComponentAutoConfiguration.this.camelContext, (Object)((Object)HttpComponentAutoConfiguration.this.configuration), (Object)target);
            }

            public boolean isEnabled(String name, Component target) {
                return HierarchicalPropertiesEvaluator.evaluate((ApplicationContext)HttpComponentAutoConfiguration.this.applicationContext, (String[])new String[]{"camel.component.customizer", "camel.component.http.customizer"}) && target instanceof HttpComponent;
            }
        };
    }
}

