/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ehcache.springboot.customizer;

import org.apache.camel.Component;
import org.apache.camel.component.ehcache.EhcacheComponent;
import org.apache.camel.component.ehcache.springboot.customizer.CacheManagerCustomizerConfiguration;
import org.apache.camel.spi.ComponentCustomizer;
import org.apache.camel.spi.HasId;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.apache.camel.spring.boot.util.ConditionalOnHierarchicalProperties;
import org.ehcache.CacheManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnBean(value={CamelAutoConfiguration.class, CacheManager.class})
@ConditionalOnHierarchicalProperties(value={"camel.component.customizer", "camel.component.ehcache.customizer", "camel.component.ehcache.customizer.cache-manager"})
@AutoConfigureAfter(value={CamelAutoConfiguration.class})
@EnableConfigurationProperties(value={CacheManagerCustomizerConfiguration.class})
public class CacheManagerCustomizer
implements HasId,
ComponentCustomizer {
    @Autowired
    private CacheManager cacheManager;
    @Autowired
    private CacheManagerCustomizerConfiguration configuration;

    public void configure(String name, Component target) {
        EhcacheComponent component = (EhcacheComponent)target;
        if (this.configuration.isOverride() || component.getCacheManager() == null) {
            component.setCacheManager(this.cacheManager);
        }
    }

    public boolean isEnabled(String name, Component target) {
        return target instanceof EhcacheComponent;
    }

    public int getOrder() {
        return 2147482647;
    }

    public String getId() {
        return "camel.component.ehcache.customizer.cache-manager";
    }
}

