/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.docker.springboot;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.component.docker.DockerConfiguration;
import org.apache.camel.spring.boot.ComponentConfigurationPropertiesCommon;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * Manage Docker containers.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.springboot.maven.SpringBootAutoConfigurationMojo")
@ConfigurationProperties(prefix = "camel.component.docker")
public class DockerComponentConfiguration
        extends
            ComponentConfigurationPropertiesCommon {

    /**
     * Whether to enable auto configuration of the docker component. This is
     * enabled by default.
     */
    private Boolean enabled;
    /**
     * To use the shared docker configuration. The option is a
     * org.apache.camel.component.docker.DockerConfiguration type.
     */
    private DockerConfiguration configuration;
    /**
     * Email address associated with the user
     */
    private String email;
    /**
     * Docker host
     */
    private String host = "localhost";
    /**
     * Docker port
     */
    private Integer port = 2375;
    /**
     * Request timeout for response (in seconds)
     */
    private Integer requestTimeout;
    /**
     * Allows for bridging the consumer to the Camel routing Error Handler,
     * which mean any exceptions occurred while the consumer is trying to pickup
     * incoming messages, or the likes, will now be processed as a message and
     * handled by the routing Error Handler. By default the consumer will use
     * the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that
     * will be logged at WARN or ERROR level and ignored.
     */
    private Boolean bridgeErrorHandler = false;
    /**
     * Whether the producer should be started lazy (on the first message). By
     * starting lazy you can use this to allow CamelContext and routes to
     * startup in situations where a producer may otherwise fail during starting
     * and cause the route to fail being started. By deferring this startup to
     * be lazy then the startup failure can be handled during routing messages
     * via Camel's routing error handlers. Beware that when the first message is
     * processed then creating and starting the producer may take a little time
     * and prolong the total processing time of the processing.
     */
    private Boolean lazyStartProducer = false;
    /**
     * Whether autowiring is enabled. This is used for automatic autowiring
     * options (the option must be marked as autowired) by looking up in the
     * registry to find if there is a single instance of matching type, which
     * then gets configured on the component. This can be used for automatic
     * configuring JDBC data sources, JMS connection factories, AWS Clients,
     * etc.
     */
    private Boolean autowiredEnabled = true;
    /**
     * The fully qualified class name of the DockerCmdExecFactory implementation
     * to use
     */
    private String cmdExecFactory = "com.github.dockerjava.netty.NettyDockerCmdExecFactory";
    /**
     * Whether to follow redirect filter
     */
    private Boolean followRedirectFilter = false;
    /**
     * Whether to use logging filter
     */
    private Boolean loggingFilter = false;
    /**
     * Maximum route connections
     */
    private Integer maxPerRouteConnections = 100;
    /**
     * Maximum total connections
     */
    private Integer maxTotalConnections = 100;
    /**
     * Additional configuration parameters as key/value pairs
     */
    private Map<String, Object> parameters;
    /**
     * Server address for docker registry.
     */
    private String serverAddress = "https://index.docker.io/v1/";
    /**
     * Socket connection mode
     */
    private Boolean socket = true;
    /**
     * Location containing the SSL certificate chain
     */
    private String certPath;
    /**
     * Password to authenticate with
     */
    private String password;
    /**
     * Use HTTPS communication
     */
    private Boolean secure = false;
    /**
     * Check TLS
     */
    private Boolean tlsVerify = false;
    /**
     * User name to authenticate with
     */
    private String username;

    public DockerConfiguration getConfiguration() {
        return configuration;
    }

    public void setConfiguration(DockerConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getHost() {
        return host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public Integer getPort() {
        return port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public Integer getRequestTimeout() {
        return requestTimeout;
    }

    public void setRequestTimeout(Integer requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public Boolean getBridgeErrorHandler() {
        return bridgeErrorHandler;
    }

    public void setBridgeErrorHandler(Boolean bridgeErrorHandler) {
        this.bridgeErrorHandler = bridgeErrorHandler;
    }

    public Boolean getLazyStartProducer() {
        return lazyStartProducer;
    }

    public void setLazyStartProducer(Boolean lazyStartProducer) {
        this.lazyStartProducer = lazyStartProducer;
    }

    public Boolean getAutowiredEnabled() {
        return autowiredEnabled;
    }

    public void setAutowiredEnabled(Boolean autowiredEnabled) {
        this.autowiredEnabled = autowiredEnabled;
    }

    public String getCmdExecFactory() {
        return cmdExecFactory;
    }

    public void setCmdExecFactory(String cmdExecFactory) {
        this.cmdExecFactory = cmdExecFactory;
    }

    public Boolean getFollowRedirectFilter() {
        return followRedirectFilter;
    }

    public void setFollowRedirectFilter(Boolean followRedirectFilter) {
        this.followRedirectFilter = followRedirectFilter;
    }

    public Boolean getLoggingFilter() {
        return loggingFilter;
    }

    public void setLoggingFilter(Boolean loggingFilter) {
        this.loggingFilter = loggingFilter;
    }

    public Integer getMaxPerRouteConnections() {
        return maxPerRouteConnections;
    }

    public void setMaxPerRouteConnections(Integer maxPerRouteConnections) {
        this.maxPerRouteConnections = maxPerRouteConnections;
    }

    public Integer getMaxTotalConnections() {
        return maxTotalConnections;
    }

    public void setMaxTotalConnections(Integer maxTotalConnections) {
        this.maxTotalConnections = maxTotalConnections;
    }

    public Map<String, Object> getParameters() {
        return parameters;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public String getServerAddress() {
        return serverAddress;
    }

    public void setServerAddress(String serverAddress) {
        this.serverAddress = serverAddress;
    }

    public Boolean getSocket() {
        return socket;
    }

    public void setSocket(Boolean socket) {
        this.socket = socket;
    }

    public String getCertPath() {
        return certPath;
    }

    public void setCertPath(String certPath) {
        this.certPath = certPath;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Boolean getSecure() {
        return secure;
    }

    public void setSecure(Boolean secure) {
        this.secure = secure;
    }

    public Boolean getTlsVerify() {
        return tlsVerify;
    }

    public void setTlsVerify(Boolean tlsVerify) {
        this.tlsVerify = tlsVerify;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }
}