/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.queue.springboot;

import com.azure.storage.common.StorageSharedKeyCredential;
import com.azure.storage.queue.QueueServiceClient;
import java.time.Duration;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.camel.component.azure.storage.queue.QueueConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinding;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.stereotype.Component;

@Configuration(proxyBeanMethods=false)
@ConfigurationPropertiesBinding
@Component
public class QueueComponentConverter
implements GenericConverter {
    @Autowired
    private ApplicationContext applicationContext;

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        LinkedHashSet<GenericConverter.ConvertiblePair> answer = new LinkedHashSet<GenericConverter.ConvertiblePair>();
        answer.add(new GenericConverter.ConvertiblePair(String.class, QueueConfiguration.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, QueueServiceClient.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, Duration.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, StorageSharedKeyCredential.class));
        return answer;
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return null;
        }
        String ref = source.toString();
        if (!ref.startsWith("#")) {
            return null;
        }
        ref = ref.startsWith("#bean:") ? ref.substring(6) : ref.substring(1);
        switch (targetType.getName()) {
            case "org.apache.camel.component.azure.storage.queue.QueueConfiguration": {
                return this.applicationContext.getBean(ref, QueueConfiguration.class);
            }
            case "com.azure.storage.queue.QueueServiceClient": {
                return this.applicationContext.getBean(ref, QueueServiceClient.class);
            }
            case "java.time.Duration": {
                return this.applicationContext.getBean(ref, Duration.class);
            }
            case "com.azure.storage.common.StorageSharedKeyCredential": {
                return this.applicationContext.getBean(ref, StorageSharedKeyCredential.class);
            }
        }
        return null;
    }
}

