/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.datalake.springboot;

import com.azure.identity.ClientSecretCredential;
import com.azure.storage.common.StorageSharedKeyCredential;
import com.azure.storage.file.datalake.DataLakeServiceClient;
import java.time.Duration;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.camel.component.azure.storage.datalake.DataLakeConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinding;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.stereotype.Component;

@Configuration(proxyBeanMethods=false)
@ConfigurationPropertiesBinding
@Component
public class DataLakeComponentConverter
implements GenericConverter {
    @Autowired
    private ApplicationContext applicationContext;

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        LinkedHashSet<GenericConverter.ConvertiblePair> answer = new LinkedHashSet<GenericConverter.ConvertiblePair>();
        answer.add(new GenericConverter.ConvertiblePair(String.class, ClientSecretCredential.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, DataLakeConfiguration.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, DataLakeServiceClient.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, StorageSharedKeyCredential.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, Duration.class));
        return answer;
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return null;
        }
        String ref = source.toString();
        if (!ref.startsWith("#")) {
            return null;
        }
        ref = ref.startsWith("#bean:") ? ref.substring(6) : ref.substring(1);
        switch (targetType.getName()) {
            case "com.azure.identity.ClientSecretCredential": {
                return this.applicationContext.getBean(ref, ClientSecretCredential.class);
            }
            case "org.apache.camel.component.azure.storage.datalake.DataLakeConfiguration": {
                return this.applicationContext.getBean(ref, DataLakeConfiguration.class);
            }
            case "com.azure.storage.file.datalake.DataLakeServiceClient": {
                return this.applicationContext.getBean(ref, DataLakeServiceClient.class);
            }
            case "com.azure.storage.common.StorageSharedKeyCredential": {
                return this.applicationContext.getBean(ref, StorageSharedKeyCredential.class);
            }
            case "java.time.Duration": {
                return this.applicationContext.getBean(ref, Duration.class);
            }
        }
        return null;
    }
}

