/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.blob.springboot;

import com.azure.core.util.Context;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.common.StorageSharedKeyCredential;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.camel.component.azure.storage.blob.BlobConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinding;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.stereotype.Component;

@Configuration(proxyBeanMethods=false)
@ConfigurationPropertiesBinding
@Component
public class BlobComponentConverter
implements GenericConverter {
    @Autowired
    private ApplicationContext applicationContext;

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        LinkedHashSet<GenericConverter.ConvertiblePair> answer = new LinkedHashSet<GenericConverter.ConvertiblePair>();
        answer.add(new GenericConverter.ConvertiblePair(String.class, BlobConfiguration.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, StorageSharedKeyCredential.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, BlobServiceClient.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, Duration.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, Context.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, OffsetDateTime.class));
        return answer;
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return null;
        }
        String ref = source.toString();
        if (!ref.startsWith("#")) {
            return null;
        }
        ref = ref.startsWith("#bean:") ? ref.substring(6) : ref.substring(1);
        switch (targetType.getName()) {
            case "org.apache.camel.component.azure.storage.blob.BlobConfiguration": {
                return this.applicationContext.getBean(ref, BlobConfiguration.class);
            }
            case "com.azure.storage.common.StorageSharedKeyCredential": {
                return this.applicationContext.getBean(ref, StorageSharedKeyCredential.class);
            }
            case "com.azure.storage.blob.BlobServiceClient": {
                return this.applicationContext.getBean(ref, BlobServiceClient.class);
            }
            case "java.time.Duration": {
                return this.applicationContext.getBean(ref, Duration.class);
            }
            case "com.azure.core.util.Context": {
                return this.applicationContext.getBean(ref, Context.class);
            }
            case "java.time.OffsetDateTime": {
                return this.applicationContext.getBean(ref, OffsetDateTime.class);
            }
        }
        return null;
    }
}

