/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.eventbridge.springboot;

import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.component.aws2.eventbridge.EventbridgeComponent;
import org.apache.camel.component.aws2.eventbridge.springboot.EventbridgeComponentConfiguration;
import org.apache.camel.component.aws2.eventbridge.springboot.EventbridgeComponentConverter;
import org.apache.camel.spi.ComponentCustomizer;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.apache.camel.spring.boot.ComponentConfigurationProperties;
import org.apache.camel.spring.boot.util.CamelPropertiesHelper;
import org.apache.camel.spring.boot.util.ConditionalOnCamelContextAndAutoConfigurationBeans;
import org.apache.camel.spring.boot.util.ConditionalOnHierarchicalProperties;
import org.apache.camel.spring.boot.util.HierarchicalPropertiesEvaluator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.convert.ApplicationConversionService;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.convert.converter.GenericConverter;

@Configuration(proxyBeanMethods=false)
@AutoConfigureAfter(value={CamelAutoConfiguration.class})
@Conditional(value={ConditionalOnCamelContextAndAutoConfigurationBeans.class})
@EnableConfigurationProperties(value={ComponentConfigurationProperties.class, EventbridgeComponentConfiguration.class})
@ConditionalOnHierarchicalProperties(value={"camel.component", "camel.component.aws2-eventbridge"})
public class EventbridgeComponentAutoConfiguration {
    @Autowired
    private ApplicationContext applicationContext;
    private final CamelContext camelContext;
    @Autowired
    private EventbridgeComponentConfiguration configuration;

    public EventbridgeComponentAutoConfiguration(CamelContext camelContext) {
        this.camelContext = camelContext;
        ApplicationConversionService acs = (ApplicationConversionService)ApplicationConversionService.getSharedInstance();
        acs.addConverter((GenericConverter)new EventbridgeComponentConverter(camelContext));
    }

    @Lazy
    @Bean
    public ComponentCustomizer configureEventbridgeComponent() {
        return new ComponentCustomizer(){

            public void configure(String name, Component target) {
                CamelPropertiesHelper.copyProperties((CamelContext)EventbridgeComponentAutoConfiguration.this.camelContext, (Object)((Object)EventbridgeComponentAutoConfiguration.this.configuration), (Object)target);
            }

            public boolean isEnabled(String name, Component target) {
                return HierarchicalPropertiesEvaluator.evaluate((ApplicationContext)EventbridgeComponentAutoConfiguration.this.applicationContext, (String[])new String[]{"camel.component.customizer", "camel.component.aws2-eventbridge.customizer"}) && target instanceof EventbridgeComponent;
            }
        };
    }
}

