/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.aws2.ddb.springboot;

import javax.annotation.Generated;
import org.apache.camel.component.aws2.ddb.Ddb2Component;
import org.apache.camel.component.aws2.ddb.Ddb2Operations;
import org.apache.camel.spring.boot.ComponentConfigurationPropertiesCommon;
import org.springframework.boot.context.properties.ConfigurationProperties;
import software.amazon.awssdk.core.Protocol;

/**
 * The aws2-ddb component is used for storing and retrieving data from Amazon's
 * DynamoDB service.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.springboot.maven.SpringBootAutoConfigurationMojo")
@ConfigurationProperties(prefix = "camel.component.aws2-ddb")
public class Ddb2ComponentConfiguration
        extends
            ComponentConfigurationPropertiesCommon {

    /**
     * Whether to enable auto configuration of the aws2-ddb component. This is
     * enabled by default.
     */
    private Boolean enabled;
    /**
     * To use the AmazonDynamoDB as the client. The option is a
     * software.amazon.awssdk.services.dynamodb.DynamoDbClient type.
     */
    private String amazonDDBClient;
    /**
     * The component configuration. The option is a
     * org.apache.camel.component.aws2.ddb.Ddb2Configuration type.
     */
    private String configuration;
    /**
     * Determines whether or not strong consistency should be enforced when data
     * is read.
     */
    private Boolean consistentRead = false;
    /**
     * Attribute name when creating table
     */
    private String keyAttributeName;
    /**
     * Attribute type when creating table
     */
    private String keyAttributeType;
    /**
     * Whether the producer should be started lazy (on the first message). By
     * starting lazy you can use this to allow CamelContext and routes to
     * startup in situations where a producer may otherwise fail during starting
     * and cause the route to fail being started. By deferring this startup to
     * be lazy then the startup failure can be handled during routing messages
     * via Camel's routing error handlers. Beware that when the first message is
     * processed then creating and starting the producer may take a little time
     * and prolong the total processing time of the processing.
     */
    private Boolean lazyStartProducer = false;
    /**
     * What operation to perform
     */
    private Ddb2Operations operation = Ddb2Operations.PutItem;
    /**
     * To define a proxy host when instantiating the DDB client
     */
    private String proxyHost;
    /**
     * The region in which DynamoDB client needs to work. When using this
     * parameter, the configuration will expect the lowercase name of the region
     * (for example ap-east-1) You'll need to use the name Region.EU_WEST_1.id()
     */
    private Integer proxyPort;
    /**
     * To define a proxy protocol when instantiating the DDB client
     */
    private Protocol proxyProtocol = Protocol.HTTPS;
    /**
     * The provisioned throughput to reserve for reading resources from your
     * table
     */
    private Long readCapacity;
    /**
     * The region in which DDB client needs to work
     */
    private String region;
    /**
     * The provisioned throughput to reserved for writing resources to your
     * table
     */
    private Long writeCapacity;
    /**
     * Whether the component should use basic property binding (Camel 2.x) or
     * the newer property binding with additional capabilities
     */
    private Boolean basicPropertyBinding = false;
    /**
     * Amazon AWS Access Key
     */
    private String accessKey;
    /**
     * Amazon AWS Secret Key
     */
    private String secretKey;

    public String getAmazonDDBClient() {
        return amazonDDBClient;
    }

    public void setAmazonDDBClient(String amazonDDBClient) {
        this.amazonDDBClient = amazonDDBClient;
    }

    public String getConfiguration() {
        return configuration;
    }

    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }

    public Boolean getConsistentRead() {
        return consistentRead;
    }

    public void setConsistentRead(Boolean consistentRead) {
        this.consistentRead = consistentRead;
    }

    public String getKeyAttributeName() {
        return keyAttributeName;
    }

    public void setKeyAttributeName(String keyAttributeName) {
        this.keyAttributeName = keyAttributeName;
    }

    public String getKeyAttributeType() {
        return keyAttributeType;
    }

    public void setKeyAttributeType(String keyAttributeType) {
        this.keyAttributeType = keyAttributeType;
    }

    public Boolean getLazyStartProducer() {
        return lazyStartProducer;
    }

    public void setLazyStartProducer(Boolean lazyStartProducer) {
        this.lazyStartProducer = lazyStartProducer;
    }

    public Ddb2Operations getOperation() {
        return operation;
    }

    public void setOperation(Ddb2Operations operation) {
        this.operation = operation;
    }

    public String getProxyHost() {
        return proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public Integer getProxyPort() {
        return proxyPort;
    }

    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    public Protocol getProxyProtocol() {
        return proxyProtocol;
    }

    public void setProxyProtocol(Protocol proxyProtocol) {
        this.proxyProtocol = proxyProtocol;
    }

    public Long getReadCapacity() {
        return readCapacity;
    }

    public void setReadCapacity(Long readCapacity) {
        this.readCapacity = readCapacity;
    }

    public String getRegion() {
        return region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public Long getWriteCapacity() {
        return writeCapacity;
    }

    public void setWriteCapacity(Long writeCapacity) {
        this.writeCapacity = writeCapacity;
    }

    public Boolean getBasicPropertyBinding() {
        return basicPropertyBinding;
    }

    public void setBasicPropertyBinding(Boolean basicPropertyBinding) {
        this.basicPropertyBinding = basicPropertyBinding;
    }

    public String getAccessKey() {
        return accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }
}