/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.swf.springboot;

import java.util.HashMap;
import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.component.aws.swf.SWFComponent;
import org.apache.camel.component.aws.swf.springboot.SWFComponentConfiguration;
import org.apache.camel.spi.ComponentCustomizer;
import org.apache.camel.spi.HasId;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.apache.camel.spring.boot.ComponentConfigurationProperties;
import org.apache.camel.spring.boot.util.CamelPropertiesHelper;
import org.apache.camel.spring.boot.util.ConditionalOnCamelContextAndAutoConfigurationBeans;
import org.apache.camel.spring.boot.util.GroupCondition;
import org.apache.camel.spring.boot.util.HierarchicalPropertiesEvaluator;
import org.apache.camel.support.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.env.Environment;

@Configuration(proxyBeanMethods=false)
@Conditional(value={ConditionalOnCamelContextAndAutoConfigurationBeans.class, GroupConditions.class})
@AutoConfigureAfter(value={CamelAutoConfiguration.class})
@EnableConfigurationProperties(value={ComponentConfigurationProperties.class, SWFComponentConfiguration.class})
public class SWFComponentAutoConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(SWFComponentAutoConfiguration.class);
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private CamelContext camelContext;
    @Autowired
    private SWFComponentConfiguration configuration;
    @Autowired(required=false)
    private List<ComponentCustomizer<SWFComponent>> customizers;

    @Lazy
    @Bean(name={"aws-swf-component"})
    @ConditionalOnMissingBean(value={SWFComponent.class})
    public SWFComponent configureSWFComponent() throws Exception {
        SWFComponent component = new SWFComponent();
        component.setCamelContext(this.camelContext);
        HashMap parameters = new HashMap();
        IntrospectionSupport.getProperties((Object)((Object)this.configuration), parameters, null, (boolean)false);
        CamelPropertiesHelper.setCamelProperties((CamelContext)this.camelContext, (Object)component, parameters, (boolean)false);
        if (ObjectHelper.isNotEmpty(this.customizers)) {
            for (ComponentCustomizer<SWFComponent> customizer : this.customizers) {
                boolean useCustomizer = customizer instanceof HasId ? HierarchicalPropertiesEvaluator.evaluate((Environment)this.applicationContext.getEnvironment(), (String[])new String[]{"camel.component.customizer", "camel.component.aws-swf.customizer", ((HasId)customizer).getId()}) : HierarchicalPropertiesEvaluator.evaluate((Environment)this.applicationContext.getEnvironment(), (String[])new String[]{"camel.component.customizer", "camel.component.aws-swf.customizer"});
                if (!useCustomizer) continue;
                LOGGER.debug("Configure component {}, with customizer {}", (Object)component, customizer);
                customizer.customize((Component)component);
            }
        }
        return component;
    }

    static class GroupConditions
    extends GroupCondition {
        public GroupConditions() {
            super("camel.component", "camel.component.aws-swf");
        }
    }
}

