/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.lambda.springboot;

import com.amazonaws.services.lambda.AWSLambda;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.component.aws.lambda.LambdaConfiguration;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;

public class LambdaComponentConverter
implements GenericConverter {
    private final CamelContext camelContext;

    public LambdaComponentConverter(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        LinkedHashSet<GenericConverter.ConvertiblePair> answer = new LinkedHashSet<GenericConverter.ConvertiblePair>();
        answer.add(new GenericConverter.ConvertiblePair(String.class, LambdaConfiguration.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, AWSLambda.class));
        return answer;
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return null;
        }
        String ref = source.toString();
        if (!ref.startsWith("#")) {
            return null;
        }
        ref = ref.startsWith("#bean:") ? ref.substring(6) : ref.substring(1);
        switch (targetType.getName()) {
            case "org.apache.camel.component.aws.lambda.LambdaConfiguration": {
                return this.camelContext.getRegistry().lookupByNameAndType(ref, LambdaConfiguration.class);
            }
            case "com.amazonaws.services.lambda.AWSLambda": {
                return this.camelContext.getRegistry().lookupByNameAndType(ref, AWSLambda.class);
            }
        }
        return null;
    }
}

