/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.zendesk.deployment;

import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.AdditionalApplicationArchiveMarkerBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import org.apache.camel.quarkus.core.deployment.util.CamelSupport;
import org.jboss.jandex.IndexView;

class ZendeskProcessor {
    private static final String FEATURE = "camel-zendesk";

    ZendeskProcessor() {
    }

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    AdditionalApplicationArchiveMarkerBuildItem boxArchiveMarker() {
        return new AdditionalApplicationArchiveMarkerBuildItem("org/zendesk");
    }

    @BuildStep
    ReflectiveClassBuildItem registerForReflection(CombinedIndexBuildItem combinedIndex) {
        IndexView index = combinedIndex.getIndex();
        String[] zendeskModelClasses = (String[])index.getKnownClasses().stream().filter(CamelSupport::isConcrete).map(classInfo -> classInfo.name().toString()).filter(className -> className.startsWith("org.zendesk.client.v2.model")).toArray(String[]::new);
        return new ReflectiveClassBuildItem(true, false, zendeskModelClasses);
    }
}

