/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.xslt;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;

public class RuntimeUriResolver
implements URIResolver {
    private static final StreamSource FAKE_SOURCE = new StreamSource(new InputStream(){

        @Override
        public int read() throws IOException {
            throw new UnsupportedOperationException("The translet available in the application archive should be used instead of loading the XSLT template anew");
        }
    });
    private final Map<String, String> uriToTransletName;

    private RuntimeUriResolver(Map<String, String> uriMap) {
        this.uriToTransletName = uriMap;
    }

    @Override
    public Source resolve(String href, String base) throws TransformerException {
        return FAKE_SOURCE;
    }

    public String getTransletClassName(String uri) {
        String transletClassName = this.uriToTransletName.get(uri);
        if (transletClassName == null) {
            throw new RuntimeException("Could not resolve " + uri);
        }
        return transletClassName;
    }

    public static class Builder {
        private Map<String, String> uriMap = new LinkedHashMap<String, String>();

        public Builder entry(String templateUri, String transletClassName) {
            this.uriMap.put(templateUri, transletClassName);
            return this;
        }

        public RuntimeUriResolver build() {
            RuntimeUriResolver result = new RuntimeUriResolver(this.uriMap);
            this.uriMap = null;
            return result;
        }
    }
}

