/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.xslt;

import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import org.apache.camel.component.xslt.TransformerFactoryConfigurationStrategy;
import org.apache.camel.component.xslt.XsltComponent;
import org.apache.camel.component.xslt.XsltEndpoint;
import org.apache.camel.quarkus.component.xslt.CamelXsltConfig;
import org.apache.camel.quarkus.component.xslt.CamelXsltErrorListener;
import org.apache.camel.quarkus.component.xslt.RuntimeUriResolver;
import org.apache.camel.quarkus.support.xalan.XalanTransformerFactory;

@Recorder
public class CamelXsltRecorder {
    public RuntimeValue<XsltComponent> createXsltComponent(CamelXsltConfig config, RuntimeValue<RuntimeUriResolver.Builder> uriResolverBuilder) {
        RuntimeUriResolver uriResolver = ((RuntimeUriResolver.Builder)uriResolverBuilder.getValue()).build();
        QuarkusTransformerFactoryConfigurationStrategy strategy = new QuarkusTransformerFactoryConfigurationStrategy(config.packageName, uriResolver);
        XsltComponent component = new XsltComponent();
        component.setUriResolver((URIResolver)uriResolver);
        component.setTransformerFactoryConfigurationStrategy((TransformerFactoryConfigurationStrategy)strategy);
        component.setTransformerFactoryClass(XalanTransformerFactory.class.getName());
        return new RuntimeValue((Object)component);
    }

    public RuntimeValue<RuntimeUriResolver.Builder> createRuntimeUriResolverBuilder() {
        return new RuntimeValue((Object)new RuntimeUriResolver.Builder());
    }

    public void addRuntimeUriResolverEntry(RuntimeValue<RuntimeUriResolver.Builder> builder, String templateUri, String transletClassName) {
        ((RuntimeUriResolver.Builder)builder.getValue()).entry(templateUri, transletClassName);
    }

    static class QuarkusTransformerFactoryConfigurationStrategy
    implements TransformerFactoryConfigurationStrategy {
        private final String packageName;
        private final RuntimeUriResolver uriResolver;

        public QuarkusTransformerFactoryConfigurationStrategy(String packageName, RuntimeUriResolver uriResolver) {
            this.uriResolver = uriResolver;
            this.packageName = packageName;
        }

        public void configure(TransformerFactory tf, XsltEndpoint endpoint) {
            String className = this.uriResolver.getTransletClassName(endpoint.getResourceUri());
            tf.setAttribute("use-classpath", true);
            tf.setAttribute("translet-name", className);
            tf.setAttribute("package-name", this.packageName);
            tf.setErrorListener(new CamelXsltErrorListener());
            endpoint.setTransformerFactory(tf);
        }
    }
}

