/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.xslt.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBundleBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.camel.quarkus.component.xslt.CamelXsltConfig;
import org.apache.camel.quarkus.component.xslt.deployment.XsltGeneratedClassBuildItem;
import org.apache.camel.support.ResourceHelper;

class XsltNativeImageProcessor {
    public static final String CLASSPATH_SCHEME = "classpath:";

    XsltNativeImageProcessor() {
    }

    @BuildStep
    ReflectiveClassBuildItem reflectiveClasses() {
        return new ReflectiveClassBuildItem(true, false, new String[]{"org.apache.camel.component.xslt.XsltBuilder"});
    }

    @BuildStep
    List<ReflectiveClassBuildItem> generatedReflectiveClasses(List<XsltGeneratedClassBuildItem> generatedClasses) {
        return generatedClasses.stream().map(XsltGeneratedClassBuildItem::getClassName).map(className -> new ReflectiveClassBuildItem(true, false, new String[]{className})).collect(Collectors.toList());
    }

    @BuildStep
    void xsltResources(CamelXsltConfig config, BuildProducer<NativeImageResourceBuildItem> nativeResources, BuildProducer<NativeImageResourceBundleBuildItem> nativeResourceBundles) {
        if (!config.sources.isPresent()) {
            return;
        }
        List sources = (List)config.sources.get();
        ArrayList<String> paths = new ArrayList<String>(sources.size() + 5);
        for (String source : sources) {
            String scheme = ResourceHelper.getScheme((String)source);
            if (!Objects.isNull(scheme) && !Objects.equals(scheme, CLASSPATH_SCHEME)) continue;
            if (Objects.equals(scheme, CLASSPATH_SCHEME)) {
                source = source.substring(CLASSPATH_SCHEME.length() + 1);
            }
            paths.add(source);
        }
        paths.add("org/apache/xml/serializer/Encodings.properties");
        paths.add("org/apache/xml/serializer/output_html.properties");
        paths.add("org/apache/xml/serializer/output_text.properties");
        paths.add("org/apache/xml/serializer/output_unknown.properties");
        paths.add("org/apache/xml/serializer/output_xml.properties");
        nativeResources.produce((BuildItem)new NativeImageResourceBuildItem(paths));
        nativeResourceBundles.produce((BuildItem)new NativeImageResourceBundleBuildItem("org.apache.xml.serializer.HTMLEntities"));
        nativeResourceBundles.produce((BuildItem)new NativeImageResourceBundleBuildItem("org.apache.xml.serializer.XMLEntities"));
    }
}

