/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.xslt.deployment;

import java.io.IOException;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.camel.quarkus.component.xslt.deployment.UriResolverEntryBuildItem;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.StringHelper;

public class BuildTimeUriResolver {
    public ResolutionResult resolve(String templateUri) {
        String effectiveScheme;
        if (templateUri == null) {
            throw new RuntimeException("href parameter cannot be null");
        }
        String scheme = ResourceHelper.getScheme((String)(templateUri = templateUri.trim()));
        String string = effectiveScheme = scheme == null ? "classpath:" : scheme;
        if (!"classpath:".equals(effectiveScheme)) {
            throw new RuntimeException("URI scheme '" + effectiveScheme + "' not supported for build time compilation of XSL templates. Only 'classpath:' URIs are supported");
        }
        String compacted = BuildTimeUriResolver.compact(templateUri, scheme);
        String transletName = this.toTransletName(compacted);
        URL url = Thread.currentThread().getContextClassLoader().getResource(compacted);
        if (url == null) {
            throw new IllegalStateException("Could not find the XSLT resource " + compacted + " in the classpath");
        }
        try {
            StreamSource src = new StreamSource(url.openStream());
            return new ResolutionResult(templateUri, transletName, src);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read the class path resource " + templateUri, e);
        }
    }

    private String toTransletName(String compacted) {
        String fileName = FileUtil.stripPath((String)compacted);
        String name = FileUtil.stripExt((String)fileName, (boolean)true);
        return StringHelper.capitalize((String)name, (boolean)true);
    }

    private static String compact(String href, String scheme) {
        String afterScheme = scheme != null ? StringHelper.after((String)href, (String)scheme) : href;
        String compacted = FileUtil.compactPath((String)afterScheme, (char)'/');
        return compacted;
    }

    static final class ResolutionResult {
        final String templateUri;
        final String transletClassName;
        final Source source;

        public ResolutionResult(String templateUri, String transletClassName, Source source) {
            this.templateUri = templateUri;
            this.transletClassName = transletClassName;
            this.source = source;
        }

        public UriResolverEntryBuildItem toBuildItem() {
            return new UriResolverEntryBuildItem(this.templateUri, this.transletClassName);
        }
    }
}

